/*
 * Decompiled with CFR 0.152.
 */
package ch.oli4.os;

import ch.oli4.os.OMessageQueue;
import java.io.PrintStream;

public final class OStatemachine
implements Runnable {
    private OMessageQueue eventQueue;
    private State initState;
    private State currentState;
    private State lastState;
    private boolean running;
    private boolean disposed;
    private boolean verbose;
    private PrintStream verboseStream;
    private String name;

    private OStatemachine() {
    }

    public OStatemachine(String name) {
        this.name = name;
        this.initState = null;
        this.currentState = null;
        this.lastState = null;
        this.running = false;
        this.disposed = false;
        this.eventQueue = new OMessageQueue();
        this.verbose = false;
        this.verboseStream = System.out;
        Thread t = new Thread(this);
        t.start();
    }

    public final void addState(State state) {
        if (this.initState == null) {
            this.initState = state;
        }
        state.setOwner(this);
    }

    public final void start() {
        this.currentState = this.initState;
        this.lastState = null;
        this.running = true;
        this.currentState.entry();
        this.step();
    }

    public final void stop() {
        this.running = false;
    }

    public void dispose() {
        this.disposed = true;
    }

    public boolean isRunning() {
        return this.running;
    }

    public void resume() {
        this.running = true;
    }

    public final void step() {
        this.step(null);
    }

    public final void step(Event event) {
        if (this.disposed) {
            throw new Error("statemachine \"" + this.toString() + "\" disposed or crashed!");
        }
        if (this.running) {
            this.eventQueue.put(event);
        }
    }

    public State getLastState() {
        return this.lastState;
    }

    private final void realStep(Event event) {
        State s;
        if (this.verbose) {
            if (event != null) {
                this.verboseStream.println("step:       t=" + System.currentTimeMillis() + ", machine=" + this.toString() + ", state=" + this.currentState.toString() + ", event=" + event.toString());
            } else {
                this.verboseStream.println("step:       t=" + System.currentTimeMillis() + ", machine=" + this.toString() + ", state=" + this.currentState.toString());
            }
        }
        if ((s = this.currentState.transit(event)) != null && s != this.currentState) {
            if (!s.isOwner(this)) {
                throw new Error("statemachine \"" + this.toString() + "\" attempt to transit to foreign state \"" + s.toString() + "\"");
            }
            this.currentState.exit();
            this.lastState = this.currentState;
            this.currentState = s;
            this.currentState.entry();
            if (this.verbose) {
                this.verboseStream.println("transition: t=" + System.currentTimeMillis() + ", machine=" + this.toString() + ", next state=" + this.currentState.toString());
            }
            this.realStep(null);
        }
    }

    public final void run() {
        try {
            while (!this.disposed) {
                Event e = (Event)this.eventQueue.get();
                this.realStep(e);
            }
        }
        catch (Error err) {
            err.printStackTrace();
            this.disposed = true;
        }
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setVerboseStream(PrintStream vs) {
        this.verboseStream = vs;
    }

    public String toString() {
        return String.valueOf(this.name) + ":" + this.currentState.name;
    }

    public static class Event {
        private String name;

        private Event() {
        }

        public Event(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    public static abstract class State {
        private OStatemachine owner = null;
        private String name;

        private State() {
        }

        void setOwner(OStatemachine owner) {
            this.owner = owner;
        }

        boolean isOwner(OStatemachine presumedOwner) {
            return this.owner == presumedOwner;
        }

        public State(String name) {
            this.name = name;
        }

        public void entry() {
        }

        public abstract State transit(Event var1);

        public void exit() {
        }

        public String toString() {
            return this.name;
        }
    }
}

