/*
 * Decompiled with CFR 0.152.
 */
package ch.oli4.os;

public class OSemaphore {
    private int counter;

    public OSemaphore(int count) {
        this.counter = count;
    }

    public synchronized void waitSignal(boolean blocking) {
        if (blocking) {
            while (this.counter <= 0) {
                try {
                    this.wait();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        --this.counter;
    }

    public void waitSignal() {
        this.waitSignal(true);
    }

    public synchronized int getCounter() {
        return this.counter;
    }

    public synchronized void signal() {
        ++this.counter;
        this.notifyAll();
    }

    public static void main(String[] arg) {
        OSemaphore s = new OSemaphore(10);
        TestA a = new TestA(s);
        TestB b = new TestB(s);
        while (true) {
            try {
                Thread.sleep(2000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            System.out.println("a=" + a.i + " b=" + b.i + " delta=" + (a.i - b.i));
        }
    }

    static class TestA
    implements Runnable {
        private OSemaphore s;
        public int i;

        public TestA(OSemaphore s) {
            this.s = s;
            Thread t = new Thread(this);
            t.start();
        }

        public void run() {
            while (true) {
                this.s.signal();
                ++this.i;
            }
        }
    }

    static class TestB
    implements Runnable {
        private OSemaphore s;
        public int i;

        public TestB(OSemaphore s) {
            this.s = s;
            Thread t = new Thread(this);
            t.start();
        }

        public void run() {
            while (true) {
                this.s.waitSignal();
                ++this.i;
            }
        }
    }
}

