/*
 * Decompiled with CFR 0.152.
 */
package ch.oli4.mmedia.game;

import ch.oli4.console.CConsole;
import ch.oli4.console.CSimpleCommand;
import ch.oli4.io.CommandLineParser;
import ch.oli4.mmedia.MAudio;
import ch.oli4.mmedia.MMouse;
import ch.oli4.mmedia.MPanel;
import ch.oli4.mmedia.game.Cache;
import ch.oli4.mmedia.game.GameCollectedObjects;
import ch.oli4.mmedia.game.GameState;
import ch.oli4.mmedia.game.Path;
import ch.oli4.mmedia.game.Room;
import ch.oli4.trace.Trace;
import ch.oli4.ui.UiToolkit;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public final class Game
implements WindowListener,
KeyListener {
    private static Game instance = null;
    private MPanel panel;
    private JFrame frame;
    private Cache<MAudio> audioCache;
    private String title = "";
    private Room mainRoom = null;
    private Path current = new Path("/");
    private Path entryPath = new Path("/");
    private Path exitPath = new Path("/");
    private boolean isPathBackupable = false;
    private CConsole console;

    public static Game getInstance() {
        if (instance == null) {
            instance = new Game();
        }
        return instance;
    }

    private Game() {
        this.audioCache = new Cache<MAudio>(new Cache.CacheFactory<MAudio>(){

            @Override
            public MAudio createInstance(String name) {
                return new MAudio(name);
            }

            @Override
            public boolean dispose(MAudio object) {
                if (object.isPlayingOrLooping()) {
                    return false;
                }
                object.dispose();
                return true;
            }
        }, 20);
        this.frame = new JFrame();
        UiToolkit.setFrameFullScreen(this.frame);
        this.panel = new MPanel(1280, 768, Math.min((float)this.frame.getWidth() / 1280.0f, (float)this.frame.getHeight() / 768.0f));
        this.panel.setFocusable(true);
        MMouse.getInstance().setPanel(this.panel);
        this.frame.getContentPane().add(this.panel);
        this.frame.pack();
        this.frame.setResizable(false);
        this.frame.setDefaultCloseOperation(0);
        this.frame.addWindowListener(this);
        this.panel.addKeyListener(this);
        this.frame.setVisible(true);
        Trace.getInstance().setOutputStream(System.out);
        Trace.getInstance().setAutoFlushBlockSize(1);
        Trace.getInstance().setVerboseLevel(0);
        Trace.getInstance().addEntry(1, "game created");
    }

    public void rescale(float f) {
        this.panel.setScaleFactor(f);
        this.frame.pack();
        UiToolkit.setFrameInMiddleOfScreen(this.frame);
    }

    public MPanel getPanel() {
        return this.panel;
    }

    public MAudio getAudio(String name) {
        return this.audioCache.get(name);
    }

    public void setTitle(String title) {
        this.title = title;
        this.frame.setTitle(title);
    }

    public void setMainRoom(Room r) {
        this.mainRoom = r;
        this.current = this.mainRoom.getPath();
    }

    public Room getMainRoom() {
        return this.mainRoom;
    }

    public void run() {
        Thread.currentThread().setPriority(1);
        Trace.getInstance().addEntry(1, "game " + this.title + " starts");
        this.mainRoom.run();
        try {
            Thread.sleep(444L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        GameState.getInstance().backup();
        this.frame.setVisible(false);
        this.getPanel().dispose();
        this.audioCache.clear();
        Trace.getInstance().addEntry(1, "bye!");
        System.exit(0);
    }

    public void setNextPath(Path path) {
        this.current.apply(path);
        Trace.getInstance().addEntry(1, "current path set to " + this.current.toString());
        if (path.toString().equals(this.getLastGamesPath(this.entryPath.toString()))) {
            Trace.getInstance().addEntry(1, "path is now backupable");
            this.isPathBackupable = true;
        }
    }

    public String getLastGamesPath(String defaultPath) {
        return GameState.getInstance().getString("current-path", defaultPath);
    }

    public Path getCurrentPath() {
        return this.current;
    }

    public void setEntryPath(Path p) {
        this.entryPath = p;
        this.setNextPath(p);
    }

    public void setExitPath(Path p) {
        this.exitPath = p;
    }

    public void exit() {
        if (this.isPathBackupable) {
            Trace.getInstance().addEntry(1, "game " + this.title + " will exit");
            GameState.getInstance().setString("current-path", this.getCurrentPath().toString());
            this.setNextPath(this.exitPath);
        }
        Trace.getInstance().addEntry(1, "path is now not backupable anymore");
        this.isPathBackupable = false;
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }

    public void windowClosing(WindowEvent e) {
        this.exit();
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
        if (e.getKeyChar() == ' ' && JOptionPane.showOptionDialog(this.panel, GameCollectedObjects.getInstance().getPanel(), "objects", 0, 1, new ImageIcon(), new String[]{"continue", "exit"}, "continue") == 1) {
            this.exit();
        }
    }

    private void initConsole() {
        this.console = new CConsole(System.in, System.out);
        this.console.setPromptString("> ");
        this.console.addSystemCommands();
        this.console.addCommand(new CommandGoto());
        this.console.addCommand(new CommandTrace());
        this.console.addCommand(new CommandScale());
        this.console.addCommand(new CommandState());
        this.console.addCommand(new CommandRooms());
        this.console.addCommand(new CommandMemory());
        this.console.addCommand(new CommandExit());
        this.console.start();
    }

    public void startDebugging(int verboseLevel) {
        this.initConsole();
        Trace.getInstance().setVerboseLevel(verboseLevel);
    }

    private class CommandExit
    extends CSimpleCommand {
        public CommandExit() {
            super("x", "", "exits the game");
        }

        public boolean onSimpleConsoleCommand(CommandLineParser cl) {
            Game.this.exit();
            return true;
        }
    }

    private class CommandGoto
    extends CSimpleCommand {
        public CommandGoto() {
            super("goto", "-p path", "goto given path (game location)");
        }

        public boolean onSimpleConsoleCommand(CommandLineParser cl) {
            Game.this.setNextPath(new Path(cl.getFirstArgument("p")));
            return true;
        }
    }

    private class CommandMemory
    extends CSimpleCommand {
        private boolean loop;

        public CommandMemory() {
            super("m", "-lc", "prints the memory usage, none=memory-print c=garbage-collect, l=looping-memory-print (stop using none)");
            this.loop = false;
            new Thread(new Runnable(){

                public void run() {
                    while (true) {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (!CommandMemory.this.loop) continue;
                        CommandMemory.this.println();
                    }
                }
            }).start();
        }

        private void println() {
            System.out.println("free=" + Runtime.getRuntime().freeMemory() / 1000000L + "MB total=" + Runtime.getRuntime().totalMemory() / 1000000L + "MB max=" + Runtime.getRuntime().maxMemory() / 1000000L + "MB");
        }

        public boolean onSimpleConsoleCommand(CommandLineParser cl) {
            if (cl.containsFlag("c")) {
                System.gc();
            } else if (cl.containsFlag("l")) {
                this.loop = true;
            } else {
                this.loop = false;
                this.println();
            }
            return true;
        }
    }

    private class CommandRooms
    extends CSimpleCommand {
        public CommandRooms() {
            super("rooms", "", "prints the whole room-structure");
        }

        public boolean onSimpleConsoleCommand(CommandLineParser cl) {
            System.out.println(Game.this.getMainRoom().toStructure());
            return true;
        }
    }

    private class CommandScale
    extends CSimpleCommand {
        public CommandScale() {
            super("scale", "-f factor", "scales the panel");
        }

        public boolean onSimpleConsoleCommand(CommandLineParser cl) {
            Game.this.rescale(Float.valueOf(cl.getFirstArgument("f")).floatValue());
            return true;
        }
    }

    private class CommandState
    extends CSimpleCommand {
        public CommandState() {
            super("state", "-sbigl key [value]", "setString/setBoolean/setInteger/Get/List game states");
        }

        public boolean onSimpleConsoleCommand(CommandLineParser cl) {
            if (cl.containsFlag("s")) {
                GameState.getInstance().setString(cl.getArguments("s")[0], cl.getArguments("s")[1]);
            } else if (cl.containsFlag("i")) {
                GameState.getInstance().setInteger(cl.getArguments("i")[0], Integer.parseInt(cl.getArguments("i")[1]));
            } else if (cl.containsFlag("b")) {
                GameState.getInstance().setBoolean(cl.getArguments("b")[0], Boolean.parseBoolean(cl.getArguments("b")[1]));
            } else if (cl.containsFlag("g")) {
                System.out.println(GameState.getInstance().getString(cl.getArguments("g")[0], ""));
            } else if (cl.containsFlag("l")) {
                System.out.println(GameState.getInstance().getAllStates());
            }
            return true;
        }
    }

    private class CommandTrace
    extends CSimpleCommand {
        public CommandTrace() {
            super("trace", "-v verbose", "set the given trace verbose level");
        }

        public boolean onSimpleConsoleCommand(CommandLineParser cl) {
            Trace.getInstance().setVerboseLevel(Integer.valueOf(cl.getFirstArgument("v")));
            return true;
        }
    }
}

