/*
 * Decompiled with CFR 0.152.
 */
package ch.oli4.mmedia.game;

import ch.oli4.mmedia.game.ActiveArea;
import ch.oli4.mmedia.game.CObject;
import ch.oli4.mmedia.game.CPerspective;
import ch.oli4.mmedia.game.EventProducer;
import ch.oli4.mmedia.game.Game;
import ch.oli4.mmedia.game.GameState;
import ch.oli4.mmedia.game.Path;
import ch.oli4.mmedia.game.Perspective;

public class CObjectNavigation
extends CObject {
    public ActiveArea area;
    public String noise;
    public String path;
    private String naviCondition;

    public CObjectNavigation(ActiveArea area, String noise, String path) {
        this.area = area;
        this.noise = noise;
        this.path = path;
        this.naviCondition = null;
    }

    public CObjectNavigation(ActiveArea area, String noise, String path, String naviCondition) {
        this.area = area;
        this.noise = noise;
        this.path = path;
        this.naviCondition = naviCondition;
    }

    void init(Perspective p) {
        p.add(this.area);
    }

    void setup() {
    }

    void setEnabled(boolean enable) {
        this.area.setEnabled(enable);
    }

    void perform(CPerspective p, EventProducer a) {
        if (a == this.area && GameState.getInstance().getBoolean(this.naviCondition, true)) {
            if (this.noise != null) {
                Game.getInstance().getAudio(this.noise).play();
            }
            if (this.path != null) {
                Game.getInstance().setNextPath(new Path(this.path));
            }
        }
    }

    void cleanup() {
    }
}

