/*
 * Decompiled with CFR 0.152.
 */
package ch.oli4.mmedia;

import ch.oli4.mmedia.MPanel;
import ch.oli4.mmedia.MTimer;

public class MAnimation {
    private String[] names;
    private String namePrefix;
    private String namePostfix;
    private int numberOfFrames;
    private MPanel panel;
    private int x;
    private int y;
    private int asynchIndex;
    private static final int HALT = 0;
    private static final int FORWARD = 1;
    private static final int BACKWARD = 2;
    private static final int ZIGZAG = 3;
    private static final int SEQUENCE = 4;
    private int asynchMode = 0;
    private int asynchPeriod;
    private MTimer timer;
    private int asynchCycles;
    private int asynchCycleCnt;
    private int[] asynchSequence;

    public MAnimation(String fileName, int numberOfFrames, MPanel p, int x, int y) {
        this.namePrefix = fileName.substring(0, fileName.indexOf(46));
        this.namePostfix = fileName.substring(fileName.indexOf(46));
        this.names = new String[numberOfFrames];
        int i = 0;
        while (i < this.names.length) {
            this.names[i] = String.valueOf(this.namePrefix) + (i + 1) + this.namePostfix;
            ++i;
        }
        this.numberOfFrames = numberOfFrames;
        this.panel = p;
        this.x = x;
        this.y = y;
        this.timer = new MTimer();
    }

    public void synchForward(int period, int cycles) {
        int i = 0;
        while (i < cycles) {
            this.synchForward(period);
            ++i;
        }
    }

    public void synchForward(int period) {
        int i = 0;
        while (i < this.numberOfFrames) {
            this.panel.printImage(this.names[i], this.x, this.y);
            this.panel.reprint(true);
            MTimer.sleep(period);
            ++i;
        }
    }

    public void synchBackward(int period, int cycles) {
        int i = 0;
        while (i < cycles) {
            this.synchBackward(period);
            ++i;
        }
    }

    public void synchBackward(int period) {
        int i = this.numberOfFrames - 1;
        while (i >= 0) {
            this.panel.printImage(this.names[i], this.x, this.y);
            this.panel.reprint(true);
            MTimer.sleep(period);
            --i;
        }
    }

    public void synchZigzag(int period, int cycles) {
        int i = 0;
        while (i < cycles) {
            this.synchZigzag(period);
            ++i;
        }
    }

    public void synchZigzag(int period) {
        this.synchForward(period);
        this.synchBackward(period);
    }

    public void synchSequence(int[] sequence, int period, int cycles) {
        int i = 0;
        while (i < cycles) {
            this.synchSequence(sequence, period);
            ++i;
        }
    }

    public void synchSequence(int[] sequence, int period) {
        int i = 0;
        while (i < sequence.length) {
            this.panel.printImage(this.names[sequence[i]], this.x, this.y);
            this.panel.reprint(true);
            MTimer.sleep(period);
            ++i;
        }
    }

    private boolean nextCycle() {
        return this.asynchCycles == 0 || ++this.asynchCycleCnt < this.asynchCycles;
    }

    public void asynchForward(int period, int cycles) {
        this.asynchMode = 1;
        this.asynchPeriod = period;
        this.asynchCycles = cycles;
        this.asynchCycleCnt = 0;
        this.asynchIndex = -1;
        this.timer.start(this.asynchPeriod);
    }

    public void asynchForward(int period, boolean looping) {
        this.asynchForward(period, looping ? 0 : 1);
    }

    public void asynchBackward(int period, int cycles) {
        this.asynchMode = 2;
        this.asynchPeriod = period;
        this.asynchCycles = cycles;
        this.asynchCycleCnt = 0;
        this.asynchIndex = this.numberOfFrames;
        this.timer.start(this.asynchPeriod);
    }

    public void asynchBackward(int period, boolean looping) {
        this.asynchBackward(period, looping ? 0 : 1);
    }

    public void asynchZigzag(int period, int cycles) {
        this.asynchMode = 3;
        this.asynchPeriod = period;
        this.asynchCycles = cycles;
        this.asynchCycleCnt = 0;
        this.asynchIndex = -1;
        this.timer.start(this.asynchPeriod);
    }

    public void asynchZigzag(int period, boolean looping) {
        this.asynchZigzag(period, looping ? 0 : 1);
    }

    public void asynchSequence(int[] sequence, int period, int cycles) {
        this.asynchMode = 4;
        this.asynchSequence = sequence;
        this.asynchPeriod = period;
        this.asynchCycles = cycles;
        this.asynchCycleCnt = 0;
        this.asynchIndex = -1;
        this.timer.start(this.asynchPeriod);
    }

    public void asynchSequence(int[] sequence, int period, boolean looping) {
        this.asynchSequence(sequence, period, looping ? 0 : 1);
    }

    public void asynchStop() {
        this.asynchMode = 0;
        this.timer.stop();
    }

    public void run() {
        this.timer.run();
        if (this.timer.isTriggered()) {
            switch (this.asynchMode) {
                case 1: {
                    if (++this.asynchIndex < this.numberOfFrames) {
                        this.panel.printImage(this.names[this.asynchIndex], this.x, this.y);
                        this.timer.start(this.asynchPeriod);
                        break;
                    }
                    if (this.nextCycle()) {
                        this.asynchIndex = 0;
                        this.panel.printImage(this.names[this.asynchIndex], this.x, this.y);
                        this.timer.start(this.asynchPeriod);
                        break;
                    }
                    this.asynchMode = 0;
                    break;
                }
                case 2: {
                    if (--this.asynchIndex >= 0) {
                        this.panel.printImage(this.names[this.asynchIndex], this.x, this.y);
                        this.timer.start(this.asynchPeriod);
                        break;
                    }
                    if (this.nextCycle()) {
                        this.asynchIndex = this.numberOfFrames - 1;
                        this.panel.printImage(this.names[this.asynchIndex], this.x, this.y);
                        this.timer.start(this.asynchPeriod);
                        break;
                    }
                    this.asynchMode = 0;
                    break;
                }
                case 3: {
                    if (++this.asynchIndex < this.numberOfFrames * 2 - 2) {
                        this.panel.printImage(this.names[this.asynchIndex < this.numberOfFrames ? this.asynchIndex : 2 * this.numberOfFrames - 2 - this.asynchIndex], this.x, this.y);
                        this.timer.start(this.asynchPeriod);
                        break;
                    }
                    if (this.nextCycle()) {
                        this.asynchIndex = 0;
                        this.panel.printImage(this.names[Math.abs(this.asynchIndex)], this.x, this.y);
                        this.timer.start(this.asynchPeriod);
                        break;
                    }
                    this.asynchIndex = 0;
                    this.panel.printImage(this.names[Math.abs(this.asynchIndex)], this.x, this.y);
                    this.asynchMode = 0;
                    break;
                }
                case 4: {
                    if (++this.asynchIndex < this.asynchSequence.length) {
                        this.panel.printImage(this.names[this.asynchSequence[this.asynchIndex]], this.x, this.y);
                        this.timer.start(this.asynchPeriod);
                        break;
                    }
                    if (this.nextCycle()) {
                        this.asynchIndex = 0;
                        this.panel.printImage(this.names[this.asynchSequence[this.asynchIndex]], this.x, this.y);
                        this.timer.start(this.asynchPeriod);
                        break;
                    }
                    this.asynchMode = 0;
                }
            }
        }
    }
}

