/*
 * Decompiled with CFR 0.152.
 */
package ch.oli4.io;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;

public class XmlInputStream {
    private InputStream is;
    private byte[] data;
    private int dataLength;
    private char dataSeparator;
    private int type;
    public static final int NOTHING = 0;
    public static final int SYSTEM_TAG = 1;
    public static final int COMMENT_TAG = 2;
    public static final int BEGIN_TAG = 3;
    public static final int END_TAG = 4;
    public static final int BEGIN_END_TAG = 5;
    public static final int DATA_CHUNK = 6;
    public static final int EOF = -1;
    private String name;
    private String dataChunk;
    private HashMap attributes;
    private static final int ST_TAG = 0;
    private static final int ST_DATA = 1;
    private int state;

    public XmlInputStream(InputStream is) {
        this.is = is;
        this.data = new byte[1000];
        this.dataSeparator = (char)32;
        this.type = 0;
        this.name = "";
        this.dataChunk = "";
        this.attributes = new HashMap();
        this.entryData();
    }

    private boolean found(String d, int offset, String s) {
        int i = 0;
        while (i < s.length()) {
            if (d.charAt(offset + i) != s.charAt(i)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private String decodeSpecialCharacters(String d) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < d.length()) {
            if (d.charAt(i) == '&') {
                if (this.found(d, i + 1, "lt;")) {
                    sb.append('<');
                    i += 3;
                } else if (this.found(d, i + 1, "gt;")) {
                    sb.append('>');
                    i += 3;
                } else if (this.found(d, i + 1, "quot;")) {
                    sb.append('\"');
                    i += 5;
                } else if (this.found(d, i + 1, "amp;")) {
                    sb.append('&');
                    i += 4;
                } else if (this.found(d, i + 1, "cent;")) {
                    sb.append('%');
                    i += 5;
                }
            } else {
                sb.append(d.charAt(i));
            }
            ++i;
        }
        return sb.toString();
    }

    private boolean isTagStart(int d) {
        return d == 60;
    }

    private boolean isTagStop(int d) {
        return d == 62;
    }

    private boolean isEOF(int d) {
        return d < 0;
    }

    public void setDataSeparator(char c) {
        this.dataSeparator = c;
    }

    public int available() {
        return this.type;
    }

    public String getTagName() {
        return this.name;
    }

    public String getDataChunk() {
        return this.dataChunk;
    }

    public HashMap getAttributes() {
        return this.attributes;
    }

    public String getAttribute(String key) {
        return (String)this.attributes.get(key);
    }

    public boolean containsAttribute(String key) {
        return this.attributes.containsKey(key);
    }

    private void printState() {
    }

    private void entryEof() {
        this.type = -1;
    }

    private void entryTag() {
        this.data[0] = this.data[this.dataLength];
        this.dataLength = 0;
        this.state = 0;
    }

    private void exitTag() {
        int eq;
        String s = new String(this.data, 0, this.dataLength + 1).trim();
        int begin = 0;
        int end = 0;
        this.attributes.clear();
        if (s.indexOf("<?") >= 0) {
            this.type = 1;
            begin = s.indexOf("<?") + 2;
            end = s.indexOf("?>");
        } else if (s.indexOf("<!--") >= 0) {
            this.type = 2;
            begin = s.indexOf("<!--") + 4;
            end = s.indexOf("-->");
        } else if (s.indexOf("</") >= 0) {
            this.type = 4;
            begin = s.indexOf("</") + 2;
            end = s.indexOf(">");
        } else if (s.indexOf("/>") >= 0) {
            this.type = 5;
            begin = s.indexOf("<") + 1;
            end = s.indexOf("/>");
        } else if (s.indexOf(">") >= 0) {
            this.type = 3;
            begin = s.indexOf("<") + 1;
            end = s.indexOf(">");
        }
        s = s.substring(begin, end).trim();
        begin = 0;
        end = s.indexOf(32);
        if (end == -1) {
            end = s.length();
        }
        this.name = s.substring(begin, end).trim();
        s = s.substring(end).trim();
        while ((eq = s.indexOf(61)) != -1) {
            String attrName = s.substring(begin, eq).trim();
            int quot1 = s.indexOf(34);
            int quot2 = s.indexOf(34, quot1 + 1);
            String attrValue = this.decodeSpecialCharacters(s.substring(quot1 + 1, quot2).trim());
            this.attributes.put(attrName, attrValue);
            s = s.substring(quot2 + 1).trim();
        }
    }

    private void doTag() throws IOException {
        do {
            this.data[++this.dataLength] = (byte)this.is.read();
            this.printState();
            if (!this.isTagStop(this.data[this.dataLength])) continue;
            this.exitTag();
            this.entryData();
            return;
        } while (!this.isEOF(this.data[this.dataLength]));
        this.entryEof();
    }

    private void entryData() {
        this.dataLength = -1;
        this.state = 1;
    }

    private void exitDataChunk() {
        this.dataChunk = this.dataLength > 0 ? new String(this.data, 0, this.dataLength).trim() : "";
        this.type = 6;
    }

    private void doData() throws IOException {
        do {
            this.data[++this.dataLength] = (byte)this.is.read();
            this.printState();
            if (this.data[this.dataLength] == this.dataSeparator) {
                this.exitDataChunk();
                this.dataLength = -1;
                return;
            }
            if (!this.isTagStart(this.data[this.dataLength])) continue;
            this.exitDataChunk();
            this.entryTag();
            return;
        } while (!this.isEOF(this.data[this.dataLength]));
        this.entryEof();
    }

    public int read() throws IOException {
        switch (this.state) {
            case 0: {
                this.doTag();
                break;
            }
            case 1: {
                this.doData();
            }
        }
        return this.type;
    }

    public void close() throws IOException {
        this.is.close();
    }
}

