/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.sampled.convert.javalayer;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javazoom.jl.decoder.Bitstream;
import javazoom.jl.decoder.BitstreamException;
import javazoom.jl.decoder.Decoder;
import javazoom.jl.decoder.DecoderException;
import javazoom.jl.decoder.Header;
import javazoom.jl.decoder.Obuffer;
import org.tritonus.share.TDebug;
import org.tritonus.share.sampled.Encodings;
import org.tritonus.share.sampled.TConversionTool;
import org.tritonus.share.sampled.convert.TAsynchronousFilteredAudioInputStream;
import org.tritonus.share.sampled.convert.TMatrixFormatConversionProvider;

public class MpegFormatConversionProvider
extends TMatrixFormatConversionProvider {
    public static final AudioFormat.Encoding MPEG1L1 = Encodings.getEncoding("MPEG1L1");
    public static final AudioFormat.Encoding MPEG1L2 = Encodings.getEncoding("MPEG1L2");
    public static final AudioFormat.Encoding MPEG1L3 = Encodings.getEncoding("MPEG1L3");
    public static final AudioFormat.Encoding MPEG2L1 = Encodings.getEncoding("MPEG2L1");
    public static final AudioFormat.Encoding MPEG2L2 = Encodings.getEncoding("MPEG2L2");
    public static final AudioFormat.Encoding MPEG2L3 = Encodings.getEncoding("MPEG2L3");
    public static final AudioFormat.Encoding MPEG2DOT5L1 = Encodings.getEncoding("MPEG2DOT5L1");
    public static final AudioFormat.Encoding MPEG2DOT5L2 = Encodings.getEncoding("MPEG2DOT5L2");
    public static final AudioFormat.Encoding MPEG2DOT5L3 = Encodings.getEncoding("MPEG2DOT5L3");
    private static final AudioFormat[] INPUT_FORMATS = new AudioFormat[]{new AudioFormat(MPEG1L1, 32000.0f, -1, 1, -1, -1.0f, false), new AudioFormat(MPEG1L1, 32000.0f, -1, 2, -1, -1.0f, false), new AudioFormat(MPEG1L1, 44100.0f, -1, 1, -1, -1.0f, false), new AudioFormat(MPEG1L1, 44100.0f, -1, 2, -1, -1.0f, false), new AudioFormat(MPEG1L1, 48000.0f, -1, 1, -1, -1.0f, false), new AudioFormat(MPEG1L1, 48000.0f, -1, 2, -1, -1.0f, false), new AudioFormat(MPEG1L2, 32000.0f, -1, 1, -1, -1.0f, false), new AudioFormat(MPEG1L2, 32000.0f, -1, 2, -1, -1.0f, false), new AudioFormat(MPEG1L2, 44100.0f, -1, 1, -1, -1.0f, false), new AudioFormat(MPEG1L2, 44100.0f, -1, 2, -1, -1.0f, false), new AudioFormat(MPEG1L2, 48000.0f, -1, 1, -1, -1.0f, false), new AudioFormat(MPEG1L2, 48000.0f, -1, 2, -1, -1.0f, false), new AudioFormat(MPEG1L3, 32000.0f, -1, 1, -1, -1.0f, false), new AudioFormat(MPEG1L3, 32000.0f, -1, 2, -1, -1.0f, false), new AudioFormat(MPEG1L3, 44100.0f, -1, 1, -1, -1.0f, false), new AudioFormat(MPEG1L3, 44100.0f, -1, 2, -1, -1.0f, false), new AudioFormat(MPEG1L3, 48000.0f, -1, 1, -1, -1.0f, false), new AudioFormat(MPEG1L3, 48000.0f, -1, 2, -1, -1.0f, false), new AudioFormat(MPEG2L1, 16000.0f, -1, 1, -1, -1.0f, false), new AudioFormat(MPEG2L1, 16000.0f, -1, 2, -1, -1.0f, false), new AudioFormat(MPEG2L1, 22050.0f, -1, 1, -1, -1.0f, false), new AudioFormat(MPEG2L1, 22050.0f, -1, 2, -1, -1.0f, false), new AudioFormat(MPEG2L1, 24000.0f, -1, 1, -1, -1.0f, false), new AudioFormat(MPEG2L1, 24000.0f, -1, 2, -1, -1.0f, false), new AudioFormat(MPEG2L2, 16000.0f, -1, 1, -1, -1.0f, false), new AudioFormat(MPEG2L2, 16000.0f, -1, 2, -1, -1.0f, false), new AudioFormat(MPEG2L2, 22050.0f, -1, 1, -1, -1.0f, false), new AudioFormat(MPEG2L2, 22050.0f, -1, 2, -1, -1.0f, false), new AudioFormat(MPEG2L2, 24000.0f, -1, 1, -1, -1.0f, false), new AudioFormat(MPEG2L2, 24000.0f, -1, 2, -1, -1.0f, false), new AudioFormat(MPEG2L3, 16000.0f, -1, 1, -1, -1.0f, false), new AudioFormat(MPEG2L3, 16000.0f, -1, 2, -1, -1.0f, false), new AudioFormat(MPEG2L3, 22050.0f, -1, 1, -1, -1.0f, false), new AudioFormat(MPEG2L3, 22050.0f, -1, 2, -1, -1.0f, false), new AudioFormat(MPEG2L3, 24000.0f, -1, 1, -1, -1.0f, false), new AudioFormat(MPEG2L3, 24000.0f, -1, 2, -1, -1.0f, false), new AudioFormat(MPEG2DOT5L1, 8000.0f, -1, 1, -1, -1.0f, false), new AudioFormat(MPEG2DOT5L1, 8000.0f, -1, 2, -1, -1.0f, false), new AudioFormat(MPEG2DOT5L1, 11025.0f, -1, 1, -1, -1.0f, false), new AudioFormat(MPEG2DOT5L1, 11025.0f, -1, 2, -1, -1.0f, false), new AudioFormat(MPEG2DOT5L1, 12000.0f, -1, 1, -1, -1.0f, false), new AudioFormat(MPEG2DOT5L1, 12000.0f, -1, 2, -1, -1.0f, false), new AudioFormat(MPEG2DOT5L2, 8000.0f, -1, 1, -1, -1.0f, false), new AudioFormat(MPEG2DOT5L2, 8000.0f, -1, 2, -1, -1.0f, false), new AudioFormat(MPEG2DOT5L2, 11025.0f, -1, 1, -1, -1.0f, false), new AudioFormat(MPEG2DOT5L2, 11025.0f, -1, 2, -1, -1.0f, false), new AudioFormat(MPEG2DOT5L2, 12000.0f, -1, 1, -1, -1.0f, false), new AudioFormat(MPEG2DOT5L2, 12000.0f, -1, 2, -1, -1.0f, false), new AudioFormat(MPEG2DOT5L3, 8000.0f, -1, 1, -1, -1.0f, false), new AudioFormat(MPEG2DOT5L3, 8000.0f, -1, 2, -1, -1.0f, false), new AudioFormat(MPEG2DOT5L3, 11025.0f, -1, 1, -1, -1.0f, false), new AudioFormat(MPEG2DOT5L3, 11025.0f, -1, 2, -1, -1.0f, false), new AudioFormat(MPEG2DOT5L3, 12000.0f, -1, 1, -1, -1.0f, false), new AudioFormat(MPEG2DOT5L3, 12000.0f, -1, 2, -1, -1.0f, false)};
    private static final AudioFormat[] OUTPUT_FORMATS = new AudioFormat[]{new AudioFormat(8000.0f, 16, 1, true, false), new AudioFormat(8000.0f, 16, 1, true, true), new AudioFormat(8000.0f, 16, 2, true, false), new AudioFormat(8000.0f, 16, 2, true, true), new AudioFormat(11025.0f, 16, 1, true, false), new AudioFormat(11025.0f, 16, 1, true, true), new AudioFormat(11025.0f, 16, 2, true, false), new AudioFormat(11025.0f, 16, 2, true, true), new AudioFormat(12000.0f, 16, 1, true, false), new AudioFormat(12000.0f, 16, 1, true, true), new AudioFormat(12000.0f, 16, 2, true, false), new AudioFormat(12000.0f, 16, 2, true, true), new AudioFormat(16000.0f, 16, 1, true, false), new AudioFormat(16000.0f, 16, 1, true, true), new AudioFormat(16000.0f, 16, 2, true, false), new AudioFormat(16000.0f, 16, 2, true, true), new AudioFormat(22050.0f, 16, 1, true, false), new AudioFormat(22050.0f, 16, 1, true, true), new AudioFormat(22050.0f, 16, 2, true, false), new AudioFormat(22050.0f, 16, 2, true, true), new AudioFormat(24000.0f, 16, 1, true, false), new AudioFormat(24000.0f, 16, 1, true, true), new AudioFormat(24000.0f, 16, 2, true, false), new AudioFormat(24000.0f, 16, 2, true, true), new AudioFormat(32000.0f, 16, 1, true, false), new AudioFormat(32000.0f, 16, 1, true, true), new AudioFormat(32000.0f, 16, 2, true, false), new AudioFormat(32000.0f, 16, 2, true, true), new AudioFormat(44100.0f, 16, 1, true, false), new AudioFormat(44100.0f, 16, 1, true, true), new AudioFormat(44100.0f, 16, 2, true, false), new AudioFormat(44100.0f, 16, 2, true, true), new AudioFormat(48000.0f, 16, 1, true, false), new AudioFormat(48000.0f, 16, 1, true, true), new AudioFormat(48000.0f, 16, 2, true, false), new AudioFormat(48000.0f, 16, 2, true, true)};
    private static final boolean t = true;
    private static final boolean f = false;
    private static final boolean[][] CONVERSIONS;

    public AudioInputStream getAudioInputStream(AudioFormat audioFormat, AudioInputStream audioInputStream) {
        AudioFormat audioFormat2;
        if (TDebug.TraceAudioConverter) {
            TDebug.out("MpegFormatConversionProvider.getAudioInputStream(AudioFormat, AudioInputStream):");
            TDebug.out("trying to convert");
            TDebug.out("\tfrom: " + audioInputStream.getFormat());
            TDebug.out("\tto: " + audioFormat);
        }
        if ((audioFormat2 = this.getMatchingFormat(audioFormat, audioInputStream.getFormat())) != null) {
            if (TDebug.TraceAudioConverter) {
                TDebug.out("MpegFormatConversionProvider.getAudioInputStream(AudioFormat, AudioInputStream):");
                TDebug.out("\tisConversionSupported() accepted it; now setting up the conversion");
            }
            audioFormat = MpegFormatConversionProvider.setUnspecifiedFieldsFromProto(audioFormat, audioFormat2);
            if (TDebug.TraceAudioConverter) {
                TDebug.out("MpegFormatConversionProvider.getAudioInputStream(AudioFormat, AudioInputStream):");
                TDebug.out("\tcompleted target format (1. stage): " + audioFormat);
            }
            audioFormat = MpegFormatConversionProvider.setUnspecifiedFieldsFromProto(audioFormat, audioInputStream.getFormat());
            if (TDebug.TraceAudioConverter) {
                TDebug.out("MpegFormatConversionProvider.getAudioInputStream(AudioFormat, AudioInputStream):");
                TDebug.out("\tcompleted target format (2. stage): " + audioFormat);
            }
            return new DecodedMpegAudioInputStream(audioFormat, audioInputStream);
        }
        throw new IllegalArgumentException("conversion not supported");
    }

    private static final AudioFormat setUnspecifiedFieldsFromProto(AudioFormat audioFormat, AudioFormat audioFormat2) {
        AudioFormat audioFormat3 = new AudioFormat(audioFormat.getEncoding(), MpegFormatConversionProvider.getSpecificValue(audioFormat.getSampleRate(), audioFormat2.getSampleRate()), MpegFormatConversionProvider.getSpecificValue(audioFormat.getSampleSizeInBits(), audioFormat2.getSampleSizeInBits()), MpegFormatConversionProvider.getSpecificValue(audioFormat.getChannels(), audioFormat2.getChannels()), MpegFormatConversionProvider.getSpecificValue(audioFormat.getFrameSize(), audioFormat2.getFrameSize()), MpegFormatConversionProvider.getSpecificValue(audioFormat.getFrameRate(), audioFormat2.getFrameRate()), audioFormat.isBigEndian());
        return audioFormat3;
    }

    private static final float getSpecificValue(float f, float f2) {
        return f == -1.0f ? f2 : f;
    }

    private static final int getSpecificValue(int n, int n2) {
        return n == -1 ? n2 : n;
    }

    public MpegFormatConversionProvider() {
        super(Arrays.asList(INPUT_FORMATS), Arrays.asList(OUTPUT_FORMATS), CONVERSIONS);
        if (TDebug.TraceAudioConverter) {
            TDebug.out("MpegFormatConversionProvider.<init>(): begin");
        }
        if (TDebug.TraceAudioConverter) {
            TDebug.out("MpegFormatConversionProvider.<init>(): end");
        }
    }

    static {
        boolean[][] blArrayArray = new boolean[54][];
        boolean[] blArray = new boolean[36];
        blArray[24] = true;
        blArray[25] = true;
        blArrayArray[0] = blArray;
        boolean[] blArray2 = new boolean[36];
        blArray2[26] = true;
        blArray2[27] = true;
        blArrayArray[1] = blArray2;
        boolean[] blArray3 = new boolean[36];
        blArray3[28] = true;
        blArray3[29] = true;
        blArrayArray[2] = blArray3;
        boolean[] blArray4 = new boolean[36];
        blArray4[30] = true;
        blArray4[31] = true;
        blArrayArray[3] = blArray4;
        boolean[] blArray5 = new boolean[36];
        blArray5[32] = true;
        blArray5[33] = true;
        blArrayArray[4] = blArray5;
        boolean[] blArray6 = new boolean[36];
        blArray6[34] = true;
        blArray6[35] = true;
        blArrayArray[5] = blArray6;
        boolean[] blArray7 = new boolean[36];
        blArray7[24] = true;
        blArray7[25] = true;
        blArrayArray[6] = blArray7;
        boolean[] blArray8 = new boolean[36];
        blArray8[26] = true;
        blArray8[27] = true;
        blArrayArray[7] = blArray8;
        boolean[] blArray9 = new boolean[36];
        blArray9[28] = true;
        blArray9[29] = true;
        blArrayArray[8] = blArray9;
        boolean[] blArray10 = new boolean[36];
        blArray10[30] = true;
        blArray10[31] = true;
        blArrayArray[9] = blArray10;
        boolean[] blArray11 = new boolean[36];
        blArray11[32] = true;
        blArray11[33] = true;
        blArrayArray[10] = blArray11;
        boolean[] blArray12 = new boolean[36];
        blArray12[34] = true;
        blArray12[35] = true;
        blArrayArray[11] = blArray12;
        boolean[] blArray13 = new boolean[36];
        blArray13[24] = true;
        blArray13[25] = true;
        blArrayArray[12] = blArray13;
        boolean[] blArray14 = new boolean[36];
        blArray14[26] = true;
        blArray14[27] = true;
        blArrayArray[13] = blArray14;
        boolean[] blArray15 = new boolean[36];
        blArray15[28] = true;
        blArray15[29] = true;
        blArrayArray[14] = blArray15;
        boolean[] blArray16 = new boolean[36];
        blArray16[30] = true;
        blArray16[31] = true;
        blArrayArray[15] = blArray16;
        boolean[] blArray17 = new boolean[36];
        blArray17[32] = true;
        blArray17[33] = true;
        blArrayArray[16] = blArray17;
        boolean[] blArray18 = new boolean[36];
        blArray18[34] = true;
        blArray18[35] = true;
        blArrayArray[17] = blArray18;
        boolean[] blArray19 = new boolean[36];
        blArray19[12] = true;
        blArray19[13] = true;
        blArrayArray[18] = blArray19;
        boolean[] blArray20 = new boolean[36];
        blArray20[14] = true;
        blArray20[15] = true;
        blArrayArray[19] = blArray20;
        boolean[] blArray21 = new boolean[36];
        blArray21[16] = true;
        blArray21[17] = true;
        blArrayArray[20] = blArray21;
        boolean[] blArray22 = new boolean[36];
        blArray22[18] = true;
        blArray22[19] = true;
        blArrayArray[21] = blArray22;
        boolean[] blArray23 = new boolean[36];
        blArray23[20] = true;
        blArray23[21] = true;
        blArrayArray[22] = blArray23;
        boolean[] blArray24 = new boolean[36];
        blArray24[22] = true;
        blArray24[23] = true;
        blArrayArray[23] = blArray24;
        boolean[] blArray25 = new boolean[36];
        blArray25[12] = true;
        blArray25[13] = true;
        blArrayArray[24] = blArray25;
        boolean[] blArray26 = new boolean[36];
        blArray26[14] = true;
        blArray26[15] = true;
        blArrayArray[25] = blArray26;
        boolean[] blArray27 = new boolean[36];
        blArray27[16] = true;
        blArray27[17] = true;
        blArrayArray[26] = blArray27;
        boolean[] blArray28 = new boolean[36];
        blArray28[18] = true;
        blArray28[19] = true;
        blArrayArray[27] = blArray28;
        boolean[] blArray29 = new boolean[36];
        blArray29[20] = true;
        blArray29[21] = true;
        blArrayArray[28] = blArray29;
        boolean[] blArray30 = new boolean[36];
        blArray30[22] = true;
        blArray30[23] = true;
        blArrayArray[29] = blArray30;
        boolean[] blArray31 = new boolean[36];
        blArray31[12] = true;
        blArray31[13] = true;
        blArrayArray[30] = blArray31;
        boolean[] blArray32 = new boolean[36];
        blArray32[14] = true;
        blArray32[15] = true;
        blArrayArray[31] = blArray32;
        boolean[] blArray33 = new boolean[36];
        blArray33[16] = true;
        blArray33[17] = true;
        blArrayArray[32] = blArray33;
        boolean[] blArray34 = new boolean[36];
        blArray34[18] = true;
        blArray34[19] = true;
        blArrayArray[33] = blArray34;
        boolean[] blArray35 = new boolean[36];
        blArray35[20] = true;
        blArray35[21] = true;
        blArrayArray[34] = blArray35;
        boolean[] blArray36 = new boolean[36];
        blArray36[22] = true;
        blArray36[23] = true;
        blArrayArray[35] = blArray36;
        boolean[] blArray37 = new boolean[36];
        blArray37[0] = true;
        blArray37[1] = true;
        blArrayArray[36] = blArray37;
        boolean[] blArray38 = new boolean[36];
        blArray38[2] = true;
        blArray38[3] = true;
        blArrayArray[37] = blArray38;
        boolean[] blArray39 = new boolean[36];
        blArray39[4] = true;
        blArray39[5] = true;
        blArrayArray[38] = blArray39;
        boolean[] blArray40 = new boolean[36];
        blArray40[6] = true;
        blArray40[7] = true;
        blArrayArray[39] = blArray40;
        boolean[] blArray41 = new boolean[36];
        blArray41[8] = true;
        blArray41[9] = true;
        blArrayArray[40] = blArray41;
        boolean[] blArray42 = new boolean[36];
        blArray42[10] = true;
        blArray42[11] = true;
        blArrayArray[41] = blArray42;
        boolean[] blArray43 = new boolean[36];
        blArray43[0] = true;
        blArray43[1] = true;
        blArrayArray[42] = blArray43;
        boolean[] blArray44 = new boolean[36];
        blArray44[2] = true;
        blArray44[3] = true;
        blArrayArray[43] = blArray44;
        boolean[] blArray45 = new boolean[36];
        blArray45[4] = true;
        blArray45[5] = true;
        blArrayArray[44] = blArray45;
        boolean[] blArray46 = new boolean[36];
        blArray46[6] = true;
        blArray46[7] = true;
        blArrayArray[45] = blArray46;
        boolean[] blArray47 = new boolean[36];
        blArray47[8] = true;
        blArray47[9] = true;
        blArrayArray[46] = blArray47;
        boolean[] blArray48 = new boolean[36];
        blArray48[10] = true;
        blArray48[11] = true;
        blArrayArray[47] = blArray48;
        boolean[] blArray49 = new boolean[36];
        blArray49[0] = true;
        blArray49[1] = true;
        blArrayArray[48] = blArray49;
        boolean[] blArray50 = new boolean[36];
        blArray50[2] = true;
        blArray50[3] = true;
        blArrayArray[49] = blArray50;
        boolean[] blArray51 = new boolean[36];
        blArray51[4] = true;
        blArray51[5] = true;
        blArrayArray[50] = blArray51;
        boolean[] blArray52 = new boolean[36];
        blArray52[6] = true;
        blArray52[7] = true;
        blArrayArray[51] = blArray52;
        boolean[] blArray53 = new boolean[36];
        blArray53[8] = true;
        blArray53[9] = true;
        blArrayArray[52] = blArray53;
        boolean[] blArray54 = new boolean[36];
        blArray54[10] = true;
        blArray54[11] = true;
        blArrayArray[53] = blArray54;
        CONVERSIONS = blArrayArray;
    }

    public static class DecodedMpegAudioInputStream
    extends TAsynchronousFilteredAudioInputStream {
        private InputStream m_encodedStream;
        private Bitstream m_bitstream;
        private Decoder m_decoder;
        private DMAISObuffer m_oBuffer;

        public void execute() {
            block6: {
                try {
                    Header header = this.m_bitstream.readFrame();
                    if (header == null) {
                        if (TDebug.TraceAudioConverter) {
                            TDebug.out("header is null (end of mpeg stream)");
                        }
                        this.m_circularBuffer.close();
                        return;
                    }
                    Obuffer obuffer = this.m_decoder.decodeFrame(header, this.m_bitstream);
                    this.m_bitstream.closeFrame();
                    this.m_circularBuffer.write(this.m_oBuffer.getBuffer(), 0, this.m_oBuffer.getCurrentBufferSize());
                    this.m_oBuffer.reset();
                }
                catch (BitstreamException bitstreamException) {
                    if (TDebug.TraceAudioConverter || TDebug.TraceAllExceptions) {
                        TDebug.out(bitstreamException);
                    }
                }
                catch (DecoderException decoderException) {
                    if (!TDebug.TraceAudioConverter && !TDebug.TraceAllExceptions) break block6;
                    TDebug.out(decoderException);
                }
            }
        }

        private final boolean isBigEndian() {
            return this.getFormat().isBigEndian();
        }

        public void close() throws IOException {
            super.close();
            this.m_encodedStream.close();
        }

        public DecodedMpegAudioInputStream(AudioFormat audioFormat, AudioInputStream audioInputStream) {
            super(audioFormat, -1);
            this.m_encodedStream = audioInputStream;
            this.m_bitstream = new Bitstream(audioInputStream);
            this.m_decoder = new Decoder(null);
            this.m_oBuffer = new DMAISObuffer(audioFormat.getChannels());
            this.m_decoder.setOutputBuffer(this.m_oBuffer);
        }

        private class DMAISObuffer
        extends Obuffer {
            private int m_nChannels;
            private byte[] m_abBuffer;
            private int[] m_anBufferPointers;
            private boolean m_bIsBigEndian;

            public void append(int n, short s) {
                TConversionTool.shortToBytes16(s, this.m_abBuffer, this.m_anBufferPointers[n], this.m_bIsBigEndian);
                int n2 = n;
                this.m_anBufferPointers[n2] = this.m_anBufferPointers[n2] + this.m_nChannels * 2;
            }

            public void set_stop_flag() {
            }

            public void close() {
            }

            public void write_buffer(int n) {
            }

            public void clear_buffer() {
            }

            public byte[] getBuffer() {
                return this.m_abBuffer;
            }

            public int getCurrentBufferSize() {
                return this.m_anBufferPointers[0];
            }

            public void reset() {
                int n = 0;
                while (n < this.m_nChannels) {
                    this.m_anBufferPointers[n] = n * 2;
                    ++n;
                }
            }

            public DMAISObuffer(int n) {
                this.m_nChannels = n;
                this.m_abBuffer = new byte[2304 * n];
                this.m_anBufferPointers = new int[n];
                this.reset();
                this.m_bIsBigEndian = DecodedMpegAudioInputStream.this.isBigEndian();
            }
        }
    }
}

