/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.sampled.file.gsm;

import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.UnsupportedAudioFileException;
import org.tritonus.share.TDebug;
import org.tritonus.share.sampled.AudioFileTypes;
import org.tritonus.share.sampled.Encodings;
import org.tritonus.share.sampled.file.TAudioFileFormat;
import org.tritonus.share.sampled.file.TAudioFileReader;

public class GSMAudioFileReader
extends TAudioFileReader {
    private static final int GSM_MAGIC = 208;
    private static final int GSM_MAGIC_MASK = 240;

    public AudioFileFormat getAudioFileFormat(InputStream inputStream) throws UnsupportedAudioFileException, IOException {
        if (TDebug.TraceAudioFileReader) {
            TDebug.out((String)"GSMAudioFileReader.getAudioFileFormat(InputStream): begin");
        }
        AudioFileFormat audioFileFormat = this.getAudioFileFormatImpl(inputStream);
        if (TDebug.TraceAudioFileReader) {
            TDebug.out((String)"GSMAudioFileReader.getAudioFileFormat(InputStream): end");
        }
        return audioFileFormat;
    }

    private AudioFileFormat getAudioFileFormatImpl(InputStream inputStream) throws UnsupportedAudioFileException, IOException {
        int n;
        if (TDebug.TraceAudioFileReader) {
            TDebug.out((String)"GSMAudioFileReader.getAudioFileFormatImpl(InputStream /*, byte[]*/): begin");
        }
        if ((n = inputStream.read()) < 0) {
            throw new EOFException();
        }
        if ((n & 0xF0) != 208) {
            throw new UnsupportedAudioFileException("not a GSM stream: wrong magic number");
        }
        int n2 = -1;
        int n3 = -1;
        if (this.getFileLengthInBytes() != -1L) {
            long l = this.getFileLengthInBytes();
            long l2 = l / 33L;
            n2 = l > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)l;
            n3 = l2 > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)l2;
        }
        AudioFormat audioFormat = new AudioFormat(Encodings.getEncoding((String)"GSM0610"), 8000.0f, -1, 1, 33, 50.0f, true);
        TAudioFileFormat tAudioFileFormat = new TAudioFileFormat(AudioFileTypes.getType((String)"GSM", (String)"gsm"), audioFormat, n3, n2);
        if (TDebug.TraceAudioFileReader) {
            TDebug.out((String)"GSMAudioFileReader.getAudioFileFormatImpl(InputStream /*, byte[]*/): end");
        }
        return tAudioFileFormat;
    }

    public AudioInputStream getAudioInputStream(InputStream inputStream) throws UnsupportedAudioFileException, IOException {
        if (TDebug.TraceAudioFileReader) {
            TDebug.out((String)"GSMAudioFileReader.getAudioInputStream(): begin");
        }
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream, 1);
        bufferedInputStream.mark(1);
        AudioFileFormat audioFileFormat = this.getAudioFileFormatImpl(bufferedInputStream);
        bufferedInputStream.reset();
        AudioInputStream audioInputStream = new AudioInputStream(bufferedInputStream, audioFileFormat.getFormat(), audioFileFormat.getFrameLength());
        if (TDebug.TraceAudioFileReader) {
            TDebug.out((String)"GSMAudioFileReader.getAudioInputStream(): end");
        }
        return audioInputStream;
    }
}

