/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.sampled.convert.gsm;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import org.tritonus.lowlevel.gsm.Encoder;
import org.tritonus.lowlevel.gsm.GSMDecoder;
import org.tritonus.lowlevel.gsm.InvalidGSMFrameException;
import org.tritonus.share.TDebug;
import org.tritonus.share.sampled.AudioFormats;
import org.tritonus.share.sampled.Encodings;
import org.tritonus.share.sampled.TConversionTool;
import org.tritonus.share.sampled.convert.TAsynchronousFilteredAudioInputStream;
import org.tritonus.share.sampled.convert.TSimpleFormatConversionProvider;

public class GSMFormatConversionProvider
extends TSimpleFormatConversionProvider {
    private static final boolean MEASURE_DECODING_TIME = false;
    private static final AudioFormat[] FORMATS1 = new AudioFormat[]{new AudioFormat(Encodings.getEncoding((String)"GSM0610"), 8000.0f, -1, 1, 33, 50.0f, false), new AudioFormat(Encodings.getEncoding((String)"GSM0610"), 8000.0f, -1, 1, 33, 50.0f, true), new AudioFormat(Encodings.getEncoding((String)"PCM_SIGNED"), 8000.0f, 16, 1, 2, 8000.0f, false), new AudioFormat(Encodings.getEncoding((String)"PCM_SIGNED"), 8000.0f, 16, 1, 2, 8000.0f, true)};
    private static final AudioFormat[] FORMATS2 = FORMATS1;
    private static final int BUFFER_SIZE = 320;
    private static final int ENCODED_GSM_FRAME_SIZE = 33;

    public GSMFormatConversionProvider() {
        super(Arrays.asList(FORMATS1), Arrays.asList(FORMATS2));
        if (TDebug.TraceAudioConverter) {
            TDebug.out((String)"GSMFormatConversionProvider.<init>(): called");
        }
    }

    public AudioInputStream getAudioInputStream(AudioFormat audioFormat, AudioInputStream audioInputStream) {
        if (TDebug.TraceAudioConverter) {
            TDebug.out((String)"GSMFormatConversionProvider.getAudioInputStream():");
            TDebug.out((String)"checking if conversion supported");
            TDebug.out((String)("from: " + audioInputStream.getFormat()));
            TDebug.out((String)("to: " + audioFormat));
        }
        if (this.isConversionSupported(audioFormat = this.getDefaultTargetFormat(audioFormat, audioInputStream.getFormat()), audioInputStream.getFormat())) {
            if (audioFormat.getEncoding().equals(Encodings.getEncoding((String)"PCM_SIGNED"))) {
                if (TDebug.TraceAudioConverter) {
                    TDebug.out((String)"GSMFormatConversionProvider.getAudioInputStream():");
                    TDebug.out((String)"conversion supported; trying to create DecodedGSMAudioInputStream");
                }
                return new DecodedGSMAudioInputStream(audioFormat, audioInputStream);
            }
            if (TDebug.TraceAudioConverter) {
                TDebug.out((String)"GSMFormatConversionProvider.getAudioInputStream():");
                TDebug.out((String)"conversion supported; trying to create EncodedGSMAudioInputStream");
            }
            return new EncodedGSMAudioInputStream(audioFormat, audioInputStream);
        }
        if (TDebug.TraceAudioConverter) {
            TDebug.out((String)"GSMFormatConversionProvider.getAudioInputStream():");
            TDebug.out((String)"conversion not supported; throwing IllegalArgumentException");
        }
        throw new IllegalArgumentException("conversion not supported");
    }

    protected AudioFormat getDefaultTargetFormat(AudioFormat audioFormat, AudioFormat audioFormat2) {
        Iterator iterator = this.getCollectionTargetFormats().iterator();
        while (iterator.hasNext()) {
            AudioFormat audioFormat3 = (AudioFormat)iterator.next();
            if (!AudioFormats.matches((AudioFormat)audioFormat, (AudioFormat)audioFormat3)) continue;
            return audioFormat3;
        }
        throw new IllegalArgumentException("conversion not supported");
    }

    public static class EncodedGSMAudioInputStream
    extends TAsynchronousFilteredAudioInputStream {
        private AudioInputStream m_decodedStream;
        private Encoder m_encoder;
        private byte[] m_abBuffer;
        private short[] m_asBuffer;
        private byte[] m_abFrameBuffer;

        public EncodedGSMAudioInputStream(AudioFormat audioFormat, AudioInputStream audioInputStream) {
            super(audioFormat, audioInputStream.getFrameLength() == -1L ? -1L : audioInputStream.getFrameLength() / 160L);
            if (TDebug.TraceAudioConverter) {
                TDebug.out((String)"EncodedGSMAudioInputStream.<init>(): called");
            }
            this.m_decodedStream = audioInputStream;
            this.m_encoder = new Encoder();
            this.m_abBuffer = new byte[320];
            this.m_asBuffer = new short[160];
            this.m_abFrameBuffer = new byte[33];
        }

        public void execute() {
            int n;
            if (TDebug.TraceAudioConverter) {
                TDebug.out((String)">EncodedGSMAudioInputStream.execute(): called");
            }
            try {
                n = this.m_decodedStream.read(this.m_abBuffer);
                if (n != this.m_abBuffer.length) {
                    if (TDebug.TraceAudioConverter) {
                        TDebug.out((String)("<EncodedGSMAudioInputStream.execute(): not read whole 160 sample block (" + n + ")"));
                    }
                    this.m_circularBuffer.close();
                    return;
                }
            }
            catch (IOException iOException) {
                if (TDebug.TraceAllExceptions) {
                    TDebug.out((Throwable)iOException);
                }
                this.m_circularBuffer.close();
                if (TDebug.TraceAudioConverter) {
                    TDebug.out((String)"<");
                }
                return;
            }
            n = 0;
            while (n < 160) {
                this.m_asBuffer[n] = TConversionTool.bytesToShort16((byte[])this.m_abBuffer, (int)(n * 2), (boolean)this.isBigEndian());
                ++n;
            }
            this.m_encoder.encode(this.m_asBuffer, this.m_abFrameBuffer);
            this.m_circularBuffer.write(this.m_abFrameBuffer);
            if (TDebug.TraceAudioConverter) {
                TDebug.out((String)"<EncodedGSMAudioInputStream.execute(): encoded GSM frame written");
            }
        }

        private boolean isBigEndian() {
            return this.m_decodedStream.getFormat().isBigEndian();
        }

        public void close() throws IOException {
            super.close();
            this.m_decodedStream.close();
        }
    }

    public static class DecodedGSMAudioInputStream
    extends TAsynchronousFilteredAudioInputStream {
        private DataInputStream m_encodedStream;
        private GSMDecoder m_decoder;
        private byte[] m_abFrameBuffer;
        private byte[] m_abBuffer;

        public DecodedGSMAudioInputStream(AudioFormat audioFormat, AudioInputStream audioInputStream) {
            super(audioFormat, audioInputStream.getFrameLength() == -1L ? -1L : audioInputStream.getFrameLength() * 160L);
            if (TDebug.TraceAudioConverter) {
                TDebug.out((String)"DecodedGSMAudioInputStream.<init>(): called");
            }
            this.m_encodedStream = new DataInputStream(audioInputStream);
            this.m_decoder = new GSMDecoder();
            this.m_abFrameBuffer = new byte[33];
            this.m_abBuffer = new byte[320];
        }

        public void execute() {
            if (TDebug.TraceAudioConverter) {
                TDebug.out((String)"DecodedGSMAudioInputStream.execute(): begin");
            }
            try {
                this.m_encodedStream.readFully(this.m_abFrameBuffer);
            }
            catch (IOException iOException) {
                if (TDebug.TraceAllExceptions) {
                    TDebug.out((Throwable)iOException);
                }
                this.m_circularBuffer.close();
                return;
            }
            try {
                this.m_decoder.decode(this.m_abFrameBuffer, 0, this.m_abBuffer, 0, this.isBigEndian());
            }
            catch (InvalidGSMFrameException invalidGSMFrameException) {
                if (TDebug.TraceAllExceptions) {
                    TDebug.out((Throwable)invalidGSMFrameException);
                }
                this.m_circularBuffer.close();
                return;
            }
            this.m_circularBuffer.write(this.m_abBuffer);
            if (TDebug.TraceAudioConverter) {
                TDebug.out((String)"DecodedGSMAudioInputStream.execute(): decoded GSM frame written");
            }
        }

        private boolean isBigEndian() {
            return ((AudioInputStream)((Object)this)).getFormat().isBigEndian();
        }

        public void close() throws IOException {
            super.close();
            this.m_encodedStream.close();
        }
    }
}

