/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.lowlevel.gsm;

import org.tritonus.lowlevel.gsm.Add;

public class Lpc {
    private int[] L_ACF = new int[9];

    public void Gsm_LPC_Analysis(short[] sArray, short[] sArray2) {
        this.Autocorrelation(sArray);
        this.Reflection_coefficients(sArray2);
        this.Transformation_to_Log_Area_Ratios(sArray2);
        this.Quantization_and_coding(sArray2);
    }

    private void Autocorrelation(short[] sArray) throws IllegalArgumentException {
        int n;
        int n2;
        int n3 = 0;
        int n4 = 0;
        short s = 0;
        short s2 = 0;
        int n5 = 0;
        boolean bl = false;
        boolean bl2 = false;
        int n6 = 0;
        while (n6 <= 159) {
            s = Add.GSM_ADD(sArray[n6], (short)0);
            if (s > s2) {
                s2 = s;
            }
            ++n6;
        }
        if (s2 == 0) {
            n5 = 0;
        } else {
            if (s2 <= 0) {
                throw new IllegalArgumentException("Autocorrelation: smax = " + s2 + " should be > 0.");
            }
            n5 = (short)(4 - Add.gsm_norm(s2 << 16));
        }
        if (n5 > 0) {
            if (n5 > 4) {
                throw new IllegalArgumentException("Autocorrelation: scalauto = " + n5 + " should be <= 4.");
            }
            switch (n5) {
                case 1: {
                    int n7 = 0;
                    while (n7 <= 159) {
                        sArray[n7] = Add.GSM_MULT_R(sArray[n7], (short)16384);
                        ++n7;
                    }
                    break;
                }
                case 2: {
                    n2 = 0;
                    while (n2 <= 159) {
                        sArray[n2] = Add.GSM_MULT_R(sArray[n2], (short)8192);
                        ++n2;
                    }
                    break;
                }
                case 3: {
                    int n8 = 0;
                    while (n8 <= 159) {
                        sArray[n8] = Add.GSM_MULT_R(sArray[n8], (short)4096);
                        ++n8;
                    }
                    break;
                }
                case 4: {
                    n = 0;
                    while (n <= 159) {
                        sArray[n] = Add.GSM_MULT_R(sArray[n], (short)2048);
                        ++n;
                    }
                    break;
                }
            }
        }
        short[] sArray2 = sArray;
        n2 = sArray2[n4];
        int[] nArray = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0};
        System.arraycopy(nArray, 0, this.L_ACF, 0, this.L_ACF.length);
        this.L_ACF[0] = this.L_ACF[0] + n2 * sArray2[n4 - 0];
        n2 = sArray2[++n4];
        this.L_ACF[0] = this.L_ACF[0] + n2 * sArray2[n4 - 0];
        this.L_ACF[1] = this.L_ACF[1] + n2 * sArray2[n4 - 1];
        n2 = sArray2[++n4];
        this.L_ACF[0] = this.L_ACF[0] + n2 * sArray2[n4 - 0];
        this.L_ACF[1] = this.L_ACF[1] + n2 * sArray2[n4 - 1];
        this.L_ACF[2] = this.L_ACF[2] + n2 * sArray2[n4 - 2];
        n2 = sArray2[++n4];
        this.L_ACF[0] = this.L_ACF[0] + n2 * sArray2[n4 - 0];
        this.L_ACF[1] = this.L_ACF[1] + n2 * sArray2[n4 - 1];
        this.L_ACF[2] = this.L_ACF[2] + n2 * sArray2[n4 - 2];
        this.L_ACF[3] = this.L_ACF[3] + n2 * sArray2[n4 - 3];
        n2 = sArray2[++n4];
        this.L_ACF[0] = this.L_ACF[0] + n2 * sArray2[n4 - 0];
        this.L_ACF[1] = this.L_ACF[1] + n2 * sArray2[n4 - 1];
        this.L_ACF[2] = this.L_ACF[2] + n2 * sArray2[n4 - 2];
        this.L_ACF[3] = this.L_ACF[3] + n2 * sArray2[n4 - 3];
        this.L_ACF[4] = this.L_ACF[4] + n2 * sArray2[n4 - 4];
        n2 = sArray2[++n4];
        this.L_ACF[0] = this.L_ACF[0] + n2 * sArray2[n4 - 0];
        this.L_ACF[1] = this.L_ACF[1] + n2 * sArray2[n4 - 1];
        this.L_ACF[2] = this.L_ACF[2] + n2 * sArray2[n4 - 2];
        this.L_ACF[3] = this.L_ACF[3] + n2 * sArray2[n4 - 3];
        this.L_ACF[4] = this.L_ACF[4] + n2 * sArray2[n4 - 4];
        this.L_ACF[5] = this.L_ACF[5] + n2 * sArray2[n4 - 5];
        n2 = sArray2[++n4];
        this.L_ACF[0] = this.L_ACF[0] + n2 * sArray2[n4 - 0];
        this.L_ACF[1] = this.L_ACF[1] + n2 * sArray2[n4 - 1];
        this.L_ACF[2] = this.L_ACF[2] + n2 * sArray2[n4 - 2];
        this.L_ACF[3] = this.L_ACF[3] + n2 * sArray2[n4 - 3];
        this.L_ACF[4] = this.L_ACF[4] + n2 * sArray2[n4 - 4];
        this.L_ACF[5] = this.L_ACF[5] + n2 * sArray2[n4 - 5];
        this.L_ACF[6] = this.L_ACF[6] + n2 * sArray2[n4 - 6];
        n2 = sArray2[++n4];
        this.L_ACF[0] = this.L_ACF[0] + n2 * sArray2[n4 - 0];
        this.L_ACF[1] = this.L_ACF[1] + n2 * sArray2[n4 - 1];
        this.L_ACF[2] = this.L_ACF[2] + n2 * sArray2[n4 - 2];
        this.L_ACF[3] = this.L_ACF[3] + n2 * sArray2[n4 - 3];
        this.L_ACF[4] = this.L_ACF[4] + n2 * sArray2[n4 - 4];
        this.L_ACF[5] = this.L_ACF[5] + n2 * sArray2[n4 - 5];
        this.L_ACF[6] = this.L_ACF[6] + n2 * sArray2[n4 - 6];
        this.L_ACF[7] = this.L_ACF[7] + n2 * sArray2[n4 - 7];
        n2 = sArray2[++n4];
        n3 = n4;
        while (n3 < 160) {
            n2 = sArray2[n3];
            this.L_ACF[0] = this.L_ACF[0] + n2 * sArray2[n3 - 0];
            this.L_ACF[1] = this.L_ACF[1] + n2 * sArray2[n3 - 1];
            this.L_ACF[2] = this.L_ACF[2] + n2 * sArray2[n3 - 2];
            this.L_ACF[3] = this.L_ACF[3] + n2 * sArray2[n3 - 3];
            this.L_ACF[4] = this.L_ACF[4] + n2 * sArray2[n3 - 4];
            this.L_ACF[5] = this.L_ACF[5] + n2 * sArray2[n3 - 5];
            this.L_ACF[6] = this.L_ACF[6] + n2 * sArray2[n3 - 6];
            this.L_ACF[7] = this.L_ACF[7] + n2 * sArray2[n3 - 7];
            this.L_ACF[8] = this.L_ACF[8] + n2 * sArray2[n3 - 8];
            ++n3;
        }
        n = 0;
        while (n < 9) {
            int n9 = n++;
            this.L_ACF[n9] = this.L_ACF[n9] << 1;
        }
        if (n5 > 0) {
            if (n5 > 4) {
                throw new IllegalArgumentException("Autocorrelation: scalauto = " + n5 + " should be <= 4.");
            }
            int n10 = 0;
            while (n10 < 160) {
                int n11 = n10++;
                sArray[n11] = (short)(sArray[n11] << n5);
            }
        }
    }

    private void Reflection_coefficients(short[] sArray) throws IllegalArgumentException {
        short s = 0;
        boolean bl = false;
        int n = 0;
        short[] sArray2 = new short[9];
        short[] sArray3 = new short[9];
        short[] sArray4 = new short[9];
        if (this.L_ACF[0] == 0) {
            int n2 = 0;
            while (n2 < 8) {
                sArray[n2] = 0;
                ++n2;
            }
            return;
        }
        if (this.L_ACF[0] == 0) {
            throw new IllegalArgumentException("Reflection_coefficients: L_ACF[0] = " + this.L_ACF[0] + " should not = 0.");
        }
        s = Add.gsm_norm(this.L_ACF[0]);
        if (s < 0 || s >= 32) {
            throw new IllegalArgumentException("Reflection_coefficients: temp = " + s + " should be >= 0 and < 32.");
        }
        int n3 = 0;
        while (n3 <= 8) {
            sArray2[n3] = Add.SASR(this.L_ACF[n3] << s, 16);
            ++n3;
        }
        System.arraycopy(sArray2, 0, sArray4, 0, 7);
        System.arraycopy(sArray2, 0, sArray3, 0, 8);
        int n4 = 1;
        while (n4 <= 8) {
            int n5;
            s = sArray3[1];
            if (sArray3[0] < (s = Add.GSM_ABS(s))) {
                n5 = n4;
                while (n5 < 8) {
                    sArray[n5] = 0;
                    ++n5;
                }
                return;
            }
            sArray[n] = Add.gsm_div(s, sArray3[0]);
            if (sArray[n] < 0) {
                throw new IllegalArgumentException("Reflection_coefficients: r[" + n + "] = " + sArray[n] + " should be >= 0");
            }
            if (sArray3[1] > 0) {
                sArray[n] = -sArray[n];
            }
            if (sArray[n] == Short.MIN_VALUE) {
                throw new IllegalArgumentException("Reflection_coefficients: r[" + n + "] = " + sArray[n] + " should not be " + Short.MIN_VALUE);
            }
            if (n4 == 8) {
                return;
            }
            s = Add.GSM_MULT_R(sArray3[1], sArray[n]);
            sArray3[0] = Add.GSM_ADD(sArray3[0], s);
            n5 = 1;
            while (n5 <= 8 - n4) {
                s = Add.GSM_MULT_R(sArray4[n5], sArray[n]);
                sArray3[n5] = Add.GSM_ADD(sArray3[n5 + 1], s);
                s = Add.GSM_MULT_R(sArray3[n5 + 1], sArray[n]);
                sArray4[n5] = Add.GSM_ADD(sArray4[n5], s);
                ++n5;
            }
            ++n4;
            ++n;
        }
    }

    private void Transformation_to_Log_Area_Ratios(short[] sArray) throws IllegalArgumentException {
        int n = 0;
        while (n < 8) {
            short s = sArray[n];
            if ((s = Add.GSM_ABS(s)) < 0) {
                throw new IllegalArgumentException("Transformation_to_Log_Area_Ratios: temp = " + s + " should be >= 0 ");
            }
            if (s < 22118) {
                s = (short)(s >> 1);
            } else if (s < 31130) {
                if (s < 11059) {
                    throw new IllegalArgumentException("Transformation_to_Log_Area_Ratios: temp = " + s + " should be >= 11059 ");
                }
                s = (short)(s - 11059);
            } else {
                if (s < 26112) {
                    throw new IllegalArgumentException("Transformation_to_Log_Area_Ratios: temp = " + s + " should be >= 26112 ");
                }
                s = (short)(s - 26112);
                s = (short)(s << 2);
            }
            short s2 = sArray[n] = sArray[n] < 0 ? (short)(-s) : s;
            if (sArray[n] == Short.MIN_VALUE) {
                throw new IllegalArgumentException("Transformation_to_Log_Area_Ratios: r[" + n + "] = " + sArray[n] + " should not be = " + Short.MIN_VALUE);
            }
            ++n;
        }
    }

    private void Quantization_and_coding(short[] sArray) {
        int n = 0;
        this.STEP2(20480, 0, 31, -32, sArray, n++);
        this.STEP2(20480, 0, 31, -32, sArray, n++);
        this.STEP2(20480, 2048, 15, -16, sArray, n++);
        this.STEP2(20480, -2560, 15, -16, sArray, n++);
        this.STEP2(13964, 94, 7, -8, sArray, n++);
        this.STEP2(15360, -1792, 7, -8, sArray, n++);
        this.STEP2(8534, -341, 3, -4, sArray, n++);
        this.STEP2(9036, -1144, 3, -4, sArray, n++);
    }

    private void STEP2(int n, int n2, int n3, int n4, short[] sArray, int n5) {
        short s = 0;
        s = Add.GSM_MULT((short)n, sArray[n5]);
        s = Add.GSM_ADD(s, (short)n2);
        s = Add.GSM_ADD(s, (short)256);
        sArray[n5] = (s = Add.SASR(s, 9)) > n3 ? (short)(n3 - n4) : (s < n4 ? (short)0 : (short)(s - n4));
    }
}

