/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.lowlevel.gsm;

import org.tritonus.lowlevel.gsm.InvalidGSMFrameException;
import org.tritonus.share.sampled.TConversionTool;

public final class GSMDecoder {
    private static final byte GSM_MAGIC = 13;
    private static final int[] FAC = new int[]{18431, 20479, 22527, 24575, 26623, 28671, 30719, Short.MAX_VALUE};
    private static final int[] QLB = new int[]{3277, 11469, 21299, Short.MAX_VALUE};
    private static final int MIN_WORD = Short.MIN_VALUE;
    private static final int MAX_WORD = Short.MAX_VALUE;
    private int[] dp0 = new int[280];
    private int[] u = new int[8];
    private int[][] LARpp = new int[2][8];
    private int j;
    private int nrp;
    private int[] v = new int[9];
    private int msr;
    private byte[] m_abFrame;
    private int[] m_LARc = new int[8];
    private int[] m_Nc = new int[4];
    private int[] m_Mc = new int[4];
    private int[] m_bc = new int[4];
    private int[] m_xmaxc = new int[4];
    private int[] m_xmc = new int[52];
    private int[] m_erp = new int[40];
    private int[] m_wt = new int[160];
    private int[] m_xMp = new int[13];
    private int[] m_result = new int[2];
    private int[] m_LARp = new int[8];
    private int[] m_s = new int[160];

    public void GSM() {
        this.nrp = 40;
    }

    public void decode(byte[] byArray, int n, byte[] byArray2, int n2, boolean bl) throws InvalidGSMFrameException {
        if (this.m_abFrame == null) {
            this.m_abFrame = new byte[33];
        }
        System.arraycopy(byArray, n, this.m_abFrame, 0, 33);
        int[] nArray = this.decode(this.m_abFrame);
        int n3 = 0;
        while (n3 < 160) {
            TConversionTool.intToBytes16((int)nArray[n3], (byte[])byArray2, (int)(n3 * 2 + n2), (boolean)bl);
            ++n3;
        }
    }

    private final int[] decode(byte[] byArray) throws InvalidGSMFrameException {
        if (byArray.length != 33) {
            throw new InvalidGSMFrameException();
        }
        int n = 0;
        if ((byArray[n] >> 4 & 0xF) != 13) {
            throw new InvalidGSMFrameException();
        }
        this.m_LARc[0] = (byArray[n++] & 0xF) << 2;
        this.m_LARc[0] = this.m_LARc[0] | byArray[n] >> 6 & 3;
        this.m_LARc[1] = byArray[n++] & 0x3F;
        this.m_LARc[2] = byArray[n] >> 3 & 0x1F;
        this.m_LARc[3] = (byArray[n++] & 7) << 2;
        this.m_LARc[3] = this.m_LARc[3] | byArray[n] >> 6 & 3;
        this.m_LARc[4] = byArray[n] >> 2 & 0xF;
        this.m_LARc[5] = (byArray[n++] & 3) << 2;
        this.m_LARc[5] = this.m_LARc[5] | byArray[n] >> 6 & 3;
        this.m_LARc[6] = byArray[n] >> 3 & 7;
        this.m_LARc[7] = byArray[n++] & 7;
        this.m_Nc[0] = byArray[n] >> 1 & 0x7F;
        this.m_bc[0] = (byArray[n++] & 1) << 1;
        this.m_bc[0] = this.m_bc[0] | byArray[n] >> 7 & 1;
        this.m_Mc[0] = byArray[n] >> 5 & 3;
        this.m_xmaxc[0] = (byArray[n++] & 0x1F) << 1;
        this.m_xmaxc[0] = this.m_xmaxc[0] | byArray[n] >> 7 & 1;
        this.m_xmc[0] = byArray[n] >> 4 & 7;
        this.m_xmc[1] = byArray[n] >> 1 & 7;
        this.m_xmc[2] = (byArray[n++] & 1) << 2;
        this.m_xmc[2] = this.m_xmc[2] | byArray[n] >> 6 & 3;
        this.m_xmc[3] = byArray[n] >> 3 & 7;
        this.m_xmc[4] = byArray[n++] & 7;
        this.m_xmc[5] = byArray[n] >> 5 & 7;
        this.m_xmc[6] = byArray[n] >> 2 & 7;
        this.m_xmc[7] = (byArray[n++] & 3) << 1;
        this.m_xmc[7] = this.m_xmc[7] | byArray[n] >> 7 & 1;
        this.m_xmc[8] = byArray[n] >> 4 & 7;
        this.m_xmc[9] = byArray[n] >> 1 & 7;
        this.m_xmc[10] = (byArray[n++] & 1) << 2;
        this.m_xmc[10] = this.m_xmc[10] | byArray[n] >> 6 & 3;
        this.m_xmc[11] = byArray[n] >> 3 & 7;
        this.m_xmc[12] = byArray[n++] & 7;
        this.m_Nc[1] = byArray[n] >> 1 & 0x7F;
        this.m_bc[1] = (byArray[n++] & 1) << 1;
        this.m_bc[1] = this.m_bc[1] | byArray[n] >> 7 & 1;
        this.m_Mc[1] = byArray[n] >> 5 & 3;
        this.m_xmaxc[1] = (byArray[n++] & 0x1F) << 1;
        this.m_xmaxc[1] = this.m_xmaxc[1] | byArray[n] >> 7 & 1;
        this.m_xmc[13] = byArray[n] >> 4 & 7;
        this.m_xmc[14] = byArray[n] >> 1 & 7;
        this.m_xmc[15] = (byArray[n++] & 1) << 2;
        this.m_xmc[15] = this.m_xmc[15] | byArray[n] >> 6 & 3;
        this.m_xmc[16] = byArray[n] >> 3 & 7;
        this.m_xmc[17] = byArray[n++] & 7;
        this.m_xmc[18] = byArray[n] >> 5 & 7;
        this.m_xmc[19] = byArray[n] >> 2 & 7;
        this.m_xmc[20] = (byArray[n++] & 3) << 1;
        this.m_xmc[20] = this.m_xmc[20] | byArray[n] >> 7 & 1;
        this.m_xmc[21] = byArray[n] >> 4 & 7;
        this.m_xmc[22] = byArray[n] >> 1 & 7;
        this.m_xmc[23] = (byArray[n++] & 1) << 2;
        this.m_xmc[23] = this.m_xmc[23] | byArray[n] >> 6 & 3;
        this.m_xmc[24] = byArray[n] >> 3 & 7;
        this.m_xmc[25] = byArray[n++] & 7;
        this.m_Nc[2] = byArray[n] >> 1 & 0x7F;
        this.m_bc[2] = (byArray[n++] & 1) << 1;
        this.m_bc[2] = this.m_bc[2] | byArray[n] >> 7 & 1;
        this.m_Mc[2] = byArray[n] >> 5 & 3;
        this.m_xmaxc[2] = (byArray[n++] & 0x1F) << 1;
        this.m_xmaxc[2] = this.m_xmaxc[2] | byArray[n] >> 7 & 1;
        this.m_xmc[26] = byArray[n] >> 4 & 7;
        this.m_xmc[27] = byArray[n] >> 1 & 7;
        this.m_xmc[28] = (byArray[n++] & 1) << 2;
        this.m_xmc[28] = this.m_xmc[28] | byArray[n] >> 6 & 3;
        this.m_xmc[29] = byArray[n] >> 3 & 7;
        this.m_xmc[30] = byArray[n++] & 7;
        this.m_xmc[31] = byArray[n] >> 5 & 7;
        this.m_xmc[32] = byArray[n] >> 2 & 7;
        this.m_xmc[33] = (byArray[n++] & 3) << 1;
        this.m_xmc[33] = this.m_xmc[33] | byArray[n] >> 7 & 1;
        this.m_xmc[34] = byArray[n] >> 4 & 7;
        this.m_xmc[35] = byArray[n] >> 1 & 7;
        this.m_xmc[36] = (byArray[n++] & 1) << 2;
        this.m_xmc[36] = this.m_xmc[36] | byArray[n] >> 6 & 3;
        this.m_xmc[37] = byArray[n] >> 3 & 7;
        this.m_xmc[38] = byArray[n++] & 7;
        this.m_Nc[3] = byArray[n] >> 1 & 0x7F;
        this.m_bc[3] = (byArray[n++] & 1) << 1;
        this.m_bc[3] = this.m_bc[3] | byArray[n] >> 7 & 1;
        this.m_Mc[3] = byArray[n] >> 5 & 3;
        this.m_xmaxc[3] = (byArray[n++] & 0x1F) << 1;
        this.m_xmaxc[3] = this.m_xmaxc[3] | byArray[n] >> 7 & 1;
        this.m_xmc[39] = byArray[n] >> 4 & 7;
        this.m_xmc[40] = byArray[n] >> 1 & 7;
        this.m_xmc[41] = (byArray[n++] & 1) << 2;
        this.m_xmc[41] = this.m_xmc[41] | byArray[n] >> 6 & 3;
        this.m_xmc[42] = byArray[n] >> 3 & 7;
        this.m_xmc[43] = byArray[n++] & 7;
        this.m_xmc[44] = byArray[n] >> 5 & 7;
        this.m_xmc[45] = byArray[n] >> 2 & 7;
        this.m_xmc[46] = (byArray[n++] & 3) << 1;
        this.m_xmc[46] = this.m_xmc[46] | byArray[n] >> 7 & 1;
        this.m_xmc[47] = byArray[n] >> 4 & 7;
        this.m_xmc[48] = byArray[n] >> 1 & 7;
        this.m_xmc[49] = (byArray[n++] & 1) << 2;
        this.m_xmc[49] = this.m_xmc[49] | byArray[n] >> 6 & 3;
        this.m_xmc[50] = byArray[n] >> 3 & 7;
        this.m_xmc[51] = byArray[n] & 7;
        return this.decoder(this.m_LARc, this.m_Nc, this.m_bc, this.m_Mc, this.m_xmaxc, this.m_xmc);
    }

    public static final void print(String string, int[] nArray) {
        System.out.print("[" + string + ":");
        int n = 0;
        while (n < nArray.length) {
            System.out.print("" + nArray[n]);
            if (n < nArray.length - 1) {
                System.out.print(",");
            } else {
                System.out.println("]");
            }
            ++n;
        }
    }

    public static final void print(String string, int n) {
        System.out.println("[" + string + ":" + n + "]");
    }

    private final int[] decoder(int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4, int[] nArray5, int[] nArray6) {
        int n = 0;
        while (n < 4) {
            this.RPEDecoding(nArray5[n], nArray4[n], nArray6, n * 13, this.m_erp);
            this.longTermSynthesisFiltering(nArray2[n], nArray3[n], this.m_erp, this.dp0);
            int n2 = 0;
            while (n2 < 40) {
                this.m_wt[n * 40 + n2] = this.dp0[120 + n2];
                ++n2;
            }
            ++n;
        }
        int[] nArray7 = this.shortTermSynthesisFilter(nArray, this.m_wt);
        this.postprocessing(nArray7);
        return nArray7;
    }

    private final void RPEDecoding(int n, int n2, int[] nArray, int n3, int[] nArray2) {
        int[] nArray3 = this.xmaxcToExpAndMant(n);
        this.APCMInverseQuantization(nArray, n3, nArray3[0], nArray3[1], this.m_xMp);
        GSMDecoder.RPE_grid_positioning(n2, this.m_xMp, nArray2);
    }

    /*
     * Unable to fully structure code
     */
    private final int[] xmaxcToExpAndMant(int var1_1) {
        block2: {
            var2_2 = 0;
            if (var1_1 > 15) {
                var2_2 = (var1_1 >> 3) - 1;
            }
            if ((var3_3 = var1_1 - (var2_2 << 3)) != 0) ** GOTO lbl10
            var2_2 = -4;
            var3_3 = 7;
            break block2;
lbl-1000:
            // 1 sources

            {
                var3_3 = var3_3 << 1 | 1;
                --var2_2;
lbl10:
                // 2 sources

                ** while (var3_3 <= 7)
            }
lbl11:
            // 1 sources

            var3_3 -= 8;
        }
        this.m_result[0] = var2_2;
        this.m_result[1] = var3_3;
        return this.m_result;
    }

    private final void APCMInverseQuantization(int[] nArray, int n, int n2, int n3, int[] nArray2) {
        int n4 = FAC[n3];
        int n5 = GSMDecoder.sub(6, n2);
        int n6 = GSMDecoder.asl(1, GSMDecoder.sub(n5, 1));
        int n7 = 0;
        int n8 = 13;
        while (n8-- > 0) {
            int n9 = (nArray[n++] << 1) - 7;
            n9 <<= 12;
            n9 = GSMDecoder.mult_r(n4, n9);
            n9 = GSMDecoder.add(n9, n6);
            nArray2[n7++] = GSMDecoder.asr(n9, n5);
        }
    }

    private static final int saturate(int n) {
        return n < Short.MIN_VALUE ? Short.MIN_VALUE : (n > Short.MAX_VALUE ? Short.MAX_VALUE : n);
    }

    private static final int sub(int n, int n2) {
        int n3 = n - n2;
        return GSMDecoder.saturate(n3);
    }

    private static final int add(int n, int n2) {
        int n3 = n + n2;
        return GSMDecoder.saturate(n3);
    }

    private static final int asl(int n, int n2) {
        if (n2 >= 16) {
            return 0;
        }
        if (n2 <= -16) {
            return n < 0 ? -1 : 0;
        }
        if (n2 < 0) {
            return GSMDecoder.asr(n, -n2);
        }
        return n << n2;
    }

    private static final int asr(int n, int n2) {
        if (n2 >= 16) {
            return n < 0 ? -1 : 0;
        }
        if (n2 <= -16) {
            return 0;
        }
        if (n2 < 0) {
            return n << -n2;
        }
        return n >> n2;
    }

    private static final int mult_r(int n, int n2) {
        if (n2 == Short.MIN_VALUE && n == Short.MIN_VALUE) {
            return Short.MAX_VALUE;
        }
        int n3 = n * n2 + 16384;
        return GSMDecoder.saturate(n3 >> 15);
    }

    private final void longTermSynthesisFiltering(int n, int n2, int[] nArray, int[] nArray2) {
        int n3;
        this.nrp = n3 = n < 40 || n > 120 ? this.nrp : n;
        int n4 = QLB[n2];
        int n5 = 0;
        while (n5 <= 39) {
            int n6 = GSMDecoder.mult_r(n4, nArray2[120 + (n5 - n3)]);
            nArray2[120 + n5] = GSMDecoder.add(nArray[n5], n6);
            ++n5;
        }
        int n7 = 0;
        while (n7 <= 119) {
            nArray2[n7] = nArray2[40 + n7];
            ++n7;
        }
    }

    private final int[] shortTermSynthesisFilter(int[] nArray, int[] nArray2) {
        int[] nArray3 = this.LARpp[this.j];
        int[] nArray4 = this.LARpp[this.j ^= 1];
        GSMDecoder.decodingOfTheCodedLogAreaRatios(nArray, nArray3);
        GSMDecoder.Coefficients_0_12(nArray4, nArray3, this.m_LARp);
        GSMDecoder.LARp_to_rp(this.m_LARp);
        this.shortTermSynthesisFiltering(this.m_LARp, 13, nArray2, this.m_s, 0);
        GSMDecoder.Coefficients_13_26(nArray4, nArray3, this.m_LARp);
        GSMDecoder.LARp_to_rp(this.m_LARp);
        this.shortTermSynthesisFiltering(this.m_LARp, 14, nArray2, this.m_s, 13);
        GSMDecoder.Coefficients_27_39(nArray4, nArray3, this.m_LARp);
        GSMDecoder.LARp_to_rp(this.m_LARp);
        this.shortTermSynthesisFiltering(this.m_LARp, 13, nArray2, this.m_s, 27);
        GSMDecoder.Coefficients_40_159(nArray3, this.m_LARp);
        GSMDecoder.LARp_to_rp(this.m_LARp);
        this.shortTermSynthesisFiltering(this.m_LARp, 120, nArray2, this.m_s, 40);
        return this.m_s;
    }

    public static final void decodingOfTheCodedLogAreaRatios(int[] nArray, int[] nArray2) {
        int n = GSMDecoder.add(nArray[0], -32) << 10;
        n = GSMDecoder.mult_r(13107, n);
        nArray2[0] = GSMDecoder.add(n, n);
        n = GSMDecoder.add(nArray[1], -32) << 10;
        n = GSMDecoder.mult_r(13107, n);
        nArray2[1] = GSMDecoder.add(n, n);
        n = GSMDecoder.add(nArray[2], -16) << 10;
        n = GSMDecoder.sub(n, 4096);
        n = GSMDecoder.mult_r(13107, n);
        nArray2[2] = GSMDecoder.add(n, n);
        n = GSMDecoder.add(nArray[3], -16) << 10;
        n = GSMDecoder.sub(n, -5120);
        n = GSMDecoder.mult_r(13107, n);
        nArray2[3] = GSMDecoder.add(n, n);
        n = GSMDecoder.add(nArray[4], -8) << 10;
        n = GSMDecoder.sub(n, 188);
        n = GSMDecoder.mult_r(19223, n);
        nArray2[4] = GSMDecoder.add(n, n);
        n = GSMDecoder.add(nArray[5], -8) << 10;
        n = GSMDecoder.sub(n, -3584);
        n = GSMDecoder.mult_r(17476, n);
        nArray2[5] = GSMDecoder.add(n, n);
        n = GSMDecoder.add(nArray[6], -4) << 10;
        n = GSMDecoder.sub(n, -682);
        n = GSMDecoder.mult_r(31454, n);
        nArray2[6] = GSMDecoder.add(n, n);
        n = GSMDecoder.add(nArray[7], -4) << 10;
        n = GSMDecoder.sub(n, -2288);
        n = GSMDecoder.mult_r(29708, n);
        nArray2[7] = GSMDecoder.add(n, n);
    }

    private static final void Coefficients_0_12(int[] nArray, int[] nArray2, int[] nArray3) {
        int n = 0;
        while (n < 8) {
            nArray3[n] = GSMDecoder.add(nArray[n] >> 2, nArray2[n] >> 2);
            nArray3[n] = GSMDecoder.add(nArray3[n], nArray[n] >> 1);
            ++n;
        }
    }

    private static final void Coefficients_13_26(int[] nArray, int[] nArray2, int[] nArray3) {
        int n = 0;
        while (n < 8) {
            nArray3[n] = GSMDecoder.add(nArray[n] >> 1, nArray2[n] >> 1);
            ++n;
        }
    }

    private static final void Coefficients_27_39(int[] nArray, int[] nArray2, int[] nArray3) {
        int n = 0;
        while (n < 8) {
            nArray3[n] = GSMDecoder.add(nArray[n] >> 2, nArray2[n] >> 2);
            nArray3[n] = GSMDecoder.add(nArray3[n], nArray2[n] >> 1);
            ++n;
        }
    }

    private static final void Coefficients_40_159(int[] nArray, int[] nArray2) {
        int n = 0;
        while (n < 8) {
            nArray2[n] = nArray[n];
            ++n;
        }
    }

    private static final void LARp_to_rp(int[] nArray) {
        int n = 0;
        while (n < 8) {
            int n2;
            if (nArray[n] < 0) {
                int n3 = n2 = nArray[n] == Short.MIN_VALUE ? Short.MAX_VALUE : -nArray[n];
                nArray[n] = -(n2 < 11059 ? n2 << 1 : (n2 < 20070 ? n2 + 11059 : GSMDecoder.add(n2 >> 2, 26112)));
            } else {
                n2 = nArray[n];
                nArray[n] = n2 < 11059 ? n2 << 1 : (n2 < 20070 ? n2 + 11059 : GSMDecoder.add(n2 >> 2, 26112));
            }
            ++n;
        }
    }

    private final void shortTermSynthesisFiltering(int[] nArray, int n, int[] nArray2, int[] nArray3, int n2) {
        int n3 = n2;
        int n4 = n2;
        while (n-- > 0) {
            int n5 = nArray2[n3++];
            int n6 = 8;
            while (n6-- > 0) {
                int n7 = nArray[n6];
                int n8 = this.v[n6];
                n8 = n7 == Short.MIN_VALUE && n8 == Short.MIN_VALUE ? Short.MAX_VALUE : GSMDecoder.saturate(n7 * n8 + 16384 >> 15);
                n5 = GSMDecoder.sub(n5, n8);
                n7 = n7 == Short.MIN_VALUE && n5 == Short.MIN_VALUE ? Short.MAX_VALUE : GSMDecoder.saturate(n7 * n5 + 16384 >> 15);
                this.v[n6 + 1] = GSMDecoder.add(this.v[n6], n7);
            }
            nArray3[n4++] = this.v[0] = n5;
        }
    }

    private final void postprocessing(int[] nArray) {
        int n = 0;
        int n2 = 160;
        while (n2-- > 0) {
            int n3 = GSMDecoder.mult_r(this.msr, 28180);
            this.msr = GSMDecoder.add(nArray[n], n3);
            nArray[n] = GSMDecoder.saturate(GSMDecoder.add(this.msr, this.msr) & 0xFFFFFFF8);
            ++n;
        }
    }

    private static final void RPE_grid_positioning(int n, int[] nArray, int[] nArray2) {
        int n2 = 13;
        int n3 = 0;
        int n4 = 0;
        switch (n) {
            case 3: {
                nArray2[n3++] = 0;
            }
            case 2: {
                nArray2[n3++] = 0;
            }
            case 1: {
                nArray2[n3++] = 0;
            }
            case 0: {
                nArray2[n3++] = nArray[n4++];
                --n2;
            }
        }
        do {
            nArray2[n3++] = 0;
            nArray2[n3++] = 0;
            nArray2[n3++] = nArray[n4++];
        } while (--n2 > 0);
        while (++n < 4) {
            nArray2[n3++] = 0;
        }
    }
}

