/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.lowlevel.gsm;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.tritonus.lowlevel.gsm.Add;
import org.tritonus.lowlevel.gsm.Gsm_State;
import org.tritonus.lowlevel.gsm.Long_term;
import org.tritonus.lowlevel.gsm.Lpc;
import org.tritonus.lowlevel.gsm.Rpe;
import org.tritonus.lowlevel.gsm.Short_term;

public class Encoder {
    private Gsm_State g_s = new Gsm_State();
    private Long_term lg_term_Obj = new Long_term();
    private Lpc lpc_Obj = new Lpc();
    private Rpe rpe_Obj = new Rpe();
    private Short_term sh_term_Obj = new Short_term();
    private short[] LARc = new short[8];
    private short[] Nc = new short[4];
    private short[] Mc = new short[4];
    private short[] bc = new short[4];
    private short[] xmaxc = new short[4];
    private short[] xmc = new short[52];
    private int[] input_signal = new int[160];
    private byte[] frame = new byte[33];
    private static final int[] u2s = new int[]{33280, 34308, 35336, 36364, 37393, 38421, 39449, 40477, 41505, 42534, 43562, 44590, 45618, 46647, 47675, 48703, 49474, 49988, 50503, 51017, 51531, 52045, 52559, 53073, 53587, 54101, 54616, 55130, 55644, 56158, 56672, 57186, 57572, 57829, 58086, 58343, 58600, 58857, 59114, 59371, 59628, 59885, 60142, 60399, 60656, 60913, 61171, 61428, 61620, 61749, 61877, 62006, 62134, 62263, 62392, 62520, 62649, 62777, 62906, 63034, 63163, 63291, 63420, 63548, 63645, 63709, 63773, 63838, 63902, 63966, 64030, 64095, 64159, 64223, 64287, 64352, 64416, 64480, 64544, 64609, 64657, 64689, 64721, 64753, 64785, 64818, 64850, 64882, 64914, 64946, 64978, 65010, 65042, 65075, 65107, 65139, 65163, 65179, 65195, 65211, 65227, 65243, 65259, 65275, 65291, 65308, 65324, 65340, 65356, 65372, 65388, 65404, 65416, 65424, 65432, 65440, 65448, 65456, 65464, 65472, 65480, 65488, 65496, 65504, 65512, 65520, 65528, 0, 32256, 31228, 30200, 29172, 28143, 27115, 26087, 25059, 24031, 23002, 21974, 20946, 19918, 18889, 17861, 16833, 16062, 15548, 15033, 14519, 14005, 13491, 12977, 12463, 11949, 11435, 10920, 10406, 9892, 9378, 8864, 8350, 7964, 7707, 7450, 7193, 6936, 6679, 6422, 6165, 5908, 5651, 5394, 5137, 4880, 4623, 4365, 4108, 3916, 3787, 3659, 3530, 3402, 3273, 3144, 3016, 2887, 2759, 2630, 2502, 2373, 2245, 2116, 1988, 1891, 1827, 1763, 1698, 1634, 1570, 1506, 1441, 1377, 1313, 1249, 1184, 1120, 1056, 992, 927, 879, 847, 815, 783, 751, 718, 686, 654, 622, 590, 558, 526, 494, 461, 429, 397, 373, 357, 341, 325, 309, 293, 277, 261, 245, 228, 212, 196, 180, 164, 148, 132, 120, 112, 104, 96, 88, 80, 72, 64, 56, 48, 40, 32, 24, 16, 8, 0};

    public static void stripAUHeader(InputStream inputStream) throws Exception {
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        int n = dataInputStream.readInt();
        dataInputStream.readInt();
        dataInputStream.readInt();
        int n2 = dataInputStream.readInt();
        int n3 = dataInputStream.readInt();
        dataInputStream.readInt();
        dataInputStream.readChar();
        dataInputStream.readChar();
        dataInputStream.readChar();
        dataInputStream.readChar();
        if (n != 779316836 || n2 != 1 || n3 != 8000) {
            // empty if block
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void encode(String string, String string2) throws Exception {
        FileOutputStream fileOutputStream;
        block13: {
            File file = new File(string);
            if (!file.exists()) throw new IOException("File : " + string + "\ndoes not exist or cannot be read.");
            if (!file.isFile()) throw new IOException("File : " + string + "\ndoes not exist or cannot be read.");
            if (!file.canRead()) {
                throw new IOException("File : " + string + "\ndoes not exist or cannot be read.");
            }
            FileInputStream fileInputStream = null;
            fileOutputStream = null;
            try {
                try {
                    fileInputStream = new FileInputStream(string);
                    fileOutputStream = new FileOutputStream(string2);
                    Encoder.stripAUHeader(fileInputStream);
                    int n = 0;
                    while ((n = this.ulaw_input(fileInputStream)) > 0) {
                        this.gsm_encode();
                        this.ulaw_output(fileOutputStream);
                    }
                }
                catch (Exception exception) {
                    throw new Exception("Encoder: " + exception.getMessage());
                }
                Object var8_8 = null;
                if (fileInputStream == null) break block13;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                if (fileInputStream != null) {
                    try {
                        fileInputStream.close();
                    }
                    catch (IOException iOException) {
                        throw new IOException("Encoder: " + iOException.getMessage());
                    }
                }
                if (fileOutputStream == null) throw throwable;
                try {
                    fileOutputStream.close();
                    throw throwable;
                }
                catch (IOException iOException) {
                    throw new IOException("Encoder: " + iOException.getMessage());
                }
            }
            try {}
            catch (IOException iOException) {
                throw new IOException("Encoder: " + iOException.getMessage());
            }
            fileInputStream.close();
        }
        if (fileOutputStream == null) return;
        try {}
        catch (IOException iOException) {
            throw new IOException("Encoder: " + iOException.getMessage());
        }
        fileOutputStream.close();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void encode(InputStream inputStream, String string) throws IOException {
        FileOutputStream fileOutputStream = null;
        try {
            try {
                fileOutputStream = new FileOutputStream(string);
                int n = 0;
                while ((n = this.ulaw_input(inputStream)) > 0) {
                    this.gsm_encode();
                    this.ulaw_output(fileOutputStream);
                }
            }
            catch (IOException iOException) {
                throw new IOException("Encoder: " + iOException.getMessage());
            }
            Object var6_6 = null;
            if (fileOutputStream == null) return;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (fileOutputStream == null) throw throwable;
            try {
                fileOutputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                throw new IOException("Encoder: " + iOException.getMessage());
            }
        }
        try {}
        catch (IOException iOException) {
            throw new IOException("Encoder: " + iOException.getMessage());
        }
        fileOutputStream.close();
    }

    public void encode(short[] sArray, byte[] byArray) {
        int n = 0;
        while (n < 160) {
            this.input_signal[n] = sArray[n];
            ++n;
        }
        this.gsm_encode();
        System.arraycopy(this.frame, 0, byArray, 0, this.frame.length);
    }

    private int ulaw_input(InputStream inputStream) throws IOException {
        int n = 0;
        int n2 = 0;
        n2 = 0;
        while (n2 < this.input_signal.length && (n = inputStream.read()) != -1) {
            if (n < 0) {
                throw new IOException("Encoder ulaw_input: Corrupt InputStream.");
            }
            this.input_signal[n2] = u2s[n];
            ++n2;
        }
        return n2;
    }

    private void gsm_encode() {
        int n = 0;
        this.Gsm_Coder_java();
        this.frame[n++] = (byte)(0xD0 | this.LARc[0] >> 2 & 0xF);
        this.frame[n++] = (byte)((this.LARc[0] & 3) << 6 | this.LARc[1] & 0x3F);
        this.frame[n++] = (byte)((this.LARc[2] & 0x1F) << 3 | this.LARc[3] >> 2 & 7);
        this.frame[n++] = (byte)((this.LARc[3] & 3) << 6 | (this.LARc[4] & 0xF) << 2 | this.LARc[5] >> 2 & 3);
        this.frame[n++] = (byte)((this.LARc[5] & 3) << 6 | (this.LARc[6] & 7) << 3 | this.LARc[7] & 7);
        this.frame[n++] = (byte)((this.Nc[0] & 0x7F) << 1 | this.bc[0] >> 1 & 1);
        this.frame[n++] = (byte)((this.bc[0] & 1) << 7 | (this.Mc[0] & 3) << 5 | this.xmaxc[0] >> 1 & 0x1F);
        this.frame[n++] = (byte)((this.xmaxc[0] & 1) << 7 | (this.xmc[0] & 7) << 4 | (this.xmc[1] & 7) << 1 | this.xmc[2] >> 2 & 1);
        this.frame[n++] = (byte)((this.xmc[2] & 3) << 6 | (this.xmc[3] & 7) << 3 | this.xmc[4] & 7);
        this.frame[n++] = (byte)((this.xmc[5] & 7) << 5 | (this.xmc[6] & 7) << 2 | this.xmc[7] >> 1 & 3);
        this.frame[n++] = (byte)((this.xmc[7] & 1) << 7 | (this.xmc[8] & 7) << 4 | (this.xmc[9] & 7) << 1 | this.xmc[10] >> 2 & 1);
        this.frame[n++] = (byte)((this.xmc[10] & 3) << 6 | (this.xmc[11] & 7) << 3 | this.xmc[12] & 7);
        this.frame[n++] = (byte)((this.Nc[1] & 0x7F) << 1 | this.bc[1] >> 1 & 1);
        this.frame[n++] = (byte)((this.bc[1] & 1) << 7 | (this.Mc[1] & 3) << 5 | this.xmaxc[1] >> 1 & 0x1F);
        this.frame[n++] = (byte)((this.xmaxc[1] & 1) << 7 | (this.xmc[13] & 7) << 4 | (this.xmc[14] & 7) << 1 | this.xmc[15] >> 2 & 1);
        this.frame[n++] = (byte)((this.xmc[15] & 3) << 6 | (this.xmc[16] & 7) << 3 | this.xmc[17] & 7);
        this.frame[n++] = (byte)((this.xmc[18] & 7) << 5 | (this.xmc[19] & 7) << 2 | this.xmc[20] >> 1 & 3);
        this.frame[n++] = (byte)((this.xmc[20] & 1) << 7 | (this.xmc[21] & 7) << 4 | (this.xmc[22] & 7) << 1 | this.xmc[23] >> 2 & 1);
        this.frame[n++] = (byte)((this.xmc[23] & 3) << 6 | (this.xmc[24] & 7) << 3 | this.xmc[25] & 7);
        this.frame[n++] = (byte)((this.Nc[2] & 0x7F) << 1 | this.bc[2] >> 1 & 1);
        this.frame[n++] = (byte)((this.bc[2] & 1) << 7 | (this.Mc[2] & 3) << 5 | this.xmaxc[2] >> 1 & 0x1F);
        this.frame[n++] = (byte)((this.xmaxc[2] & 1) << 7 | (this.xmc[26] & 7) << 4 | (this.xmc[27] & 7) << 1 | this.xmc[28] >> 2 & 1);
        this.frame[n++] = (byte)((this.xmc[28] & 3) << 6 | (this.xmc[29] & 7) << 3 | this.xmc[30] & 7);
        this.frame[n++] = (byte)((this.xmc[31] & 7) << 5 | (this.xmc[32] & 7) << 2 | this.xmc[33] >> 1 & 3);
        this.frame[n++] = (byte)((this.xmc[33] & 1) << 7 | (this.xmc[34] & 7) << 4 | (this.xmc[35] & 7) << 1 | this.xmc[36] >> 2 & 1);
        this.frame[n++] = (byte)((this.xmc[36] & 3) << 6 | (this.xmc[37] & 7) << 3 | this.xmc[38] & 7);
        this.frame[n++] = (byte)((this.Nc[3] & 0x7F) << 1 | this.bc[3] >> 1 & 1);
        this.frame[n++] = (byte)((this.bc[3] & 1) << 7 | (this.Mc[3] & 3) << 5 | this.xmaxc[3] >> 1 & 0x1F);
        this.frame[n++] = (byte)((this.xmaxc[3] & 1) << 7 | (this.xmc[39] & 7) << 4 | (this.xmc[40] & 7) << 1 | this.xmc[41] >> 2 & 1);
        this.frame[n++] = (byte)((this.xmc[41] & 3) << 6 | (this.xmc[42] & 7) << 3 | this.xmc[43] & 7);
        this.frame[n++] = (byte)((this.xmc[44] & 7) << 5 | (this.xmc[45] & 7) << 2 | this.xmc[46] >> 1 & 3);
        this.frame[n++] = (byte)((this.xmc[46] & 1) << 7 | (this.xmc[47] & 7) << 4 | (this.xmc[48] & 7) << 1 | this.xmc[49] >> 2 & 1);
        this.frame[n++] = (byte)((this.xmc[49] & 3) << 6 | (this.xmc[50] & 7) << 3 | this.xmc[51] & 7);
    }

    private void Gsm_Coder_java() {
        int n;
        short[] sArray;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 120;
        short[] sArray2 = new short[40];
        short[] sArray3 = new short[50];
        short[] sArray4 = new short[160];
        this.Gsm_Preprocess(sArray4);
        this.lpc_Obj.Gsm_LPC_Analysis(sArray4, this.LARc);
        this.sh_term_Obj.Gsm_Short_Term_Analysis_Filter(this.g_s, this.LARc, sArray4);
        short[] sArray5 = sArray = this.g_s.getDp0();
        int n6 = 0;
        while (n6 <= 3) {
            this.lg_term_Obj.Gsm_Long_Term_Predictor(sArray4, n6 * 40, sArray3, sArray, sArray5, n5, this.Nc, this.bc, n3++);
            this.rpe_Obj.Gsm_RPE_Encoding(sArray3, this.xmaxc, this.Mc, n4++, this.xmc, n2);
            n = 0;
            while (n <= 39) {
                sArray[n + n5] = Add.GSM_ADD(sArray3[5 + n], sArray5[n + n5]);
                ++n;
            }
            this.g_s.setDp0(sArray);
            n5 += 40;
            ++n6;
            n2 += 13;
        }
        n = 0;
        while (n < 120) {
            this.g_s.setDp0Indexed(n, this.g_s.getDp0Indexed(160 + n));
            ++n;
        }
    }

    private void Gsm_Preprocess(short[] sArray) throws IllegalArgumentException {
        int n = 0;
        int n2 = 0;
        short s = this.g_s.getZ1();
        int n3 = this.g_s.getL_z2();
        int n4 = this.g_s.getMp();
        int n5 = 0;
        short s2 = 0;
        short s3 = 0;
        boolean bl = false;
        short s4 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 160;
        while (n8 != 0) {
            --n8;
            if ((s4 = (short)(Add.SASR((short)this.input_signal[n++], 3) << 2)) < -16384) {
                throw new IllegalArgumentException("Gsm_Preprocess: SO = " + s4 + " is out of range. Sould be >= -0x4000 ");
            }
            if (s4 > 16380) {
                throw new IllegalArgumentException("Gsm_Preprocess: SO = " + s4 + " is out of range. Sould be <= 0x3FFC ");
            }
            n5 = s4 - s;
            s = s4;
            if (n5 == Short.MIN_VALUE) {
                throw new IllegalArgumentException("Gsm_Preprocess: s1 = " + n5 + " is out of range. ");
            }
            n6 = n5;
            n6 <<= 15;
            s2 = Add.SASR(n3, 15);
            s3 = (short)(n3 - (s2 << 15));
            n7 = s2 * 32735;
            n3 = Add.GSM_L_ADD(n7, n6 += Add.GSM_MULT_R(s3, (short)32735));
            n7 = Add.GSM_L_ADD(n3, 16384);
            s2 = Add.GSM_MULT_R((short)n4, (short)-28180);
            n4 = Add.SASR(n7, 15);
            sArray[n2++] = Add.GSM_ADD((short)n4, s2);
        }
        this.g_s.setZ1(s);
        this.g_s.setL_z2(n3);
        this.g_s.setMp(n4);
    }

    private void ulaw_output(FileOutputStream fileOutputStream) throws IOException {
        int n = 0;
        boolean bl = false;
        n = 0;
        while (n < this.frame.length) {
            fileOutputStream.write(this.frame[n]);
            ++n;
        }
    }

    private void dump_Gsm_State(Gsm_State gsm_State) {
        gsm_State.dump_Gsm_State();
    }
}

