/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.lowlevel.gsm;

public class Add {
    private static final short[] bitoff = new short[]{8, 7, 6, 6, 5, 5, 5, 5, 4, 4, 4, 4, 4, 4, 4, 4, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

    public static short saturate(int n) {
        return (short)(n < Short.MIN_VALUE ? Short.MIN_VALUE : (short)(n > Short.MAX_VALUE ? Short.MAX_VALUE : (short)n));
    }

    public static short saturate(long l) {
        return (short)(l < -32768L ? Short.MIN_VALUE : (short)(l > 32767L ? Short.MAX_VALUE : (short)l));
    }

    public static short SASR(int n, int n2) {
        return (short)(n >> n2);
    }

    public static short GSM_ADD(short s, short s2) {
        int n = s + s2;
        return Add.saturate(n);
    }

    public static short GSM_SUB(short s, short s2) {
        int n = s - s2;
        return Add.saturate(n);
    }

    public static short GSM_MULT(short s, short s2) {
        if (s == Short.MIN_VALUE && s2 == Short.MIN_VALUE) {
            return Short.MAX_VALUE;
        }
        return Add.SASR(s * s2, 15);
    }

    public static short GSM_MULT_R(short s, short s2) {
        if (s == Short.MIN_VALUE && s2 == Short.MIN_VALUE) {
            return Short.MAX_VALUE;
        }
        int n = s * s2 + 16384;
        return (short)((n >>= 15) & 0xFFFF);
    }

    public static short GSM_ABS(short n) {
        int n2 = n < 0 ? (n == Short.MIN_VALUE ? Short.MAX_VALUE : -n) : n;
        return (short)n2;
    }

    public static int GSM_L_MULT(short s, short s2) throws IllegalArgumentException {
        if (s != Short.MIN_VALUE || s2 != Short.MIN_VALUE) {
            throw new IllegalArgumentException("One of the aruments must equal -32768");
        }
        return s * s2 << 1;
    }

    public static int GSM_L_ADD(int n, int n2) {
        if (n <= 0) {
            if (n2 >= 0) {
                return n + n2;
            }
            long l = (long)(-(n + 1)) + (long)(-(n2 + 1));
            return l >= Integer.MAX_VALUE ? Integer.MIN_VALUE : -((int)l) - 2;
        }
        if (n2 <= 0) {
            return n + n2;
        }
        long l = (long)n + (long)n2;
        return l > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)l;
    }

    public static short gsm_norm(int n) throws IllegalArgumentException {
        if (n == 0) {
            throw new IllegalArgumentException("gsm_norm: a cannot = 0.");
        }
        if (n < 0) {
            if (n <= -1073741824) {
                return 0;
            }
            n ^= 0xFFFFFFFF;
        }
        return (n & 0xFFFF0000) != 0 ? ((n & 0xFF000000) != 0 ? (short)(-1 + bitoff[0xFF & n >> 24]) : (short)(7 + bitoff[0xFF & n >> 16])) : ((n & 0xFF00) != 0 ? (short)(15 + bitoff[0xFF & n >> 8]) : (short)(23 + bitoff[0xFF & n]));
    }

    public static short gsm_asl(short s, int n) {
        if (n >= 16) {
            return 0;
        }
        if (n <= -16) {
            if (s < 0) {
                return -1;
            }
            return 0;
        }
        if (n < 0) {
            return Add.gsm_asr(s, -n);
        }
        return (short)(s << n);
    }

    public static short gsm_asr(short s, int n) {
        if (n >= 16) {
            if (s < 0) {
                return -1;
            }
            return 0;
        }
        if (n <= -16) {
            return 0;
        }
        if (n < 0) {
            return (short)(s << -n);
        }
        return (short)(s >> n);
    }

    /*
     * Unable to fully structure code
     */
    public static short gsm_div(short var0, short var1_1) throws IllegalArgumentException {
        var2_2 = var0;
        var3_3 = var1_1;
        var4_4 = 0;
        var5_5 = 15;
        if (var0 < 0 || var1_1 < var0) {
            throw new IllegalArgumentException("gsm_div: num >= 0 && denum >= num");
        }
        if (var0 != 0) ** GOTO lbl14
        return 0;
lbl-1000:
        // 1 sources

        {
            --var5_5;
            var4_4 = (short)(var4_4 << 1);
            if ((var2_2 <<= 1) < var3_3) continue;
            var2_2 -= var3_3;
            var4_4 = (short)(var4_4 + 1);
lbl14:
            // 3 sources

            ** while (var5_5 != 0)
        }
lbl15:
        // 1 sources

        return var4_4;
    }
}

