/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.sampled.convert.vorbis;

import com.jcraft.jogg.Packet;
import com.jcraft.jogg.Page;
import com.jcraft.jogg.StreamState;
import com.jcraft.jogg.SyncState;
import com.jcraft.jorbis.Block;
import com.jcraft.jorbis.Comment;
import com.jcraft.jorbis.DspState;
import com.jcraft.jorbis.Info;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import org.tritonus.share.TDebug;
import org.tritonus.share.sampled.AudioFormats;
import org.tritonus.share.sampled.Encodings;
import org.tritonus.share.sampled.convert.TAsynchronousFilteredAudioInputStream;
import org.tritonus.share.sampled.convert.TEncodingFormatConversionProvider;

public class JorbisFormatConversionProvider
extends TEncodingFormatConversionProvider {
    private static final AudioFormat.Encoding VORBIS = Encodings.getEncoding((String)"VORBIS");
    private static final AudioFormat.Encoding PCM_SIGNED = Encodings.getEncoding((String)"PCM_SIGNED");
    private static final AudioFormat[] INPUT_FORMATS = new AudioFormat[]{new AudioFormat(VORBIS, -1.0f, -1, 1, -1, -1.0f, false), new AudioFormat(VORBIS, -1.0f, -1, 1, -1, -1.0f, true), new AudioFormat(VORBIS, -1.0f, -1, 2, -1, -1.0f, false), new AudioFormat(VORBIS, -1.0f, -1, 2, -1, -1.0f, true)};
    private static final AudioFormat[] OUTPUT_FORMATS = new AudioFormat[]{new AudioFormat(PCM_SIGNED, -1.0f, 16, 1, 2, -1.0f, false), new AudioFormat(PCM_SIGNED, -1.0f, 16, 1, 2, -1.0f, true), new AudioFormat(PCM_SIGNED, -1.0f, 16, 2, 4, -1.0f, false), new AudioFormat(PCM_SIGNED, -1.0f, 16, 2, 4, -1.0f, true)};

    public AudioInputStream getAudioInputStream(AudioFormat audioFormat, AudioInputStream audioInputStream) {
        DecodedJorbisAudioInputStream decodedJorbisAudioInputStream = null;
        if (TDebug.TraceAudioConverter) {
            TDebug.out((String)"JorbisFormatConversionProvider.getAudioInputStream():");
            TDebug.out((String)"checking if conversion supported");
            TDebug.out((String)("from: " + audioInputStream.getFormat()));
            TDebug.out((String)("to: " + audioFormat));
        }
        if (this.isConversionSupported(audioFormat = this.getDefaultTargetFormat(audioFormat, audioInputStream.getFormat()), audioInputStream.getFormat())) {
            if (TDebug.TraceAudioConverter) {
                TDebug.out((String)"JorbisFormatConversionProvider.getAudioInputStream():");
                TDebug.out((String)"conversion supported; trying to create DecodedJorbisAudioInputStream");
            }
        } else {
            if (TDebug.TraceAudioConverter) {
                TDebug.out((String)"JorbisFormatConversionProvider.getAudioInputStream():");
                TDebug.out((String)"conversion not supported; throwing IllegalArgumentException");
            }
            throw new IllegalArgumentException("conversion not supported");
        }
        decodedJorbisAudioInputStream = new DecodedJorbisAudioInputStream(audioFormat, audioInputStream);
        return decodedJorbisAudioInputStream;
    }

    protected AudioFormat getDefaultTargetFormat(AudioFormat audioFormat, AudioFormat audioFormat2) {
        if (TDebug.TraceAudioConverter) {
            TDebug.out((String)("JorbisFormatConversionProvider.getDefaultTargetFormat(): target format: " + audioFormat));
        }
        if (TDebug.TraceAudioConverter) {
            TDebug.out((String)("JorbisFormatConversionProvider.getDefaultTargetFormat(): source format: " + audioFormat2));
        }
        AudioFormat audioFormat3 = null;
        Iterator iterator = this.getCollectionTargetFormats().iterator();
        while (iterator.hasNext()) {
            AudioFormat audioFormat4 = (AudioFormat)iterator.next();
            if (!AudioFormats.matches((AudioFormat)audioFormat, (AudioFormat)audioFormat4)) continue;
            audioFormat3 = audioFormat4;
        }
        if (audioFormat3 == null) {
            throw new IllegalArgumentException("conversion not supported");
        }
        if (TDebug.TraceAudioConverter) {
            TDebug.out((String)("JorbisFormatConversionProvider.getDefaultTargetFormat(): new target format: " + audioFormat3));
        }
        audioFormat3 = new AudioFormat(audioFormat.getEncoding(), audioFormat2.getSampleRate(), audioFormat3.getSampleSizeInBits(), audioFormat3.getChannels(), audioFormat3.getFrameSize(), audioFormat2.getSampleRate(), audioFormat3.isBigEndian());
        if (TDebug.TraceAudioConverter) {
            TDebug.out((String)("JorbisFormatConversionProvider.getDefaultTargetFormat(): really new target format: " + audioFormat3));
        }
        return audioFormat3;
    }

    public JorbisFormatConversionProvider() {
        super(Arrays.asList(INPUT_FORMATS), Arrays.asList(OUTPUT_FORMATS));
    }

    public static class DecodedJorbisAudioInputStream
    extends TAsynchronousFilteredAudioInputStream {
        public static boolean DEBUG = false;
        private static final int BUFFER_MULTIPLE = 4;
        private static final int BUFFER_SIZE = 2048;
        private static final int CONVSIZE = 4096;
        private InputStream m_oggBitStream = null;
        private SyncState m_oggSyncState = null;
        private StreamState m_oggStreamState = null;
        private Page m_oggPage = null;
        private Packet m_oggPacket = null;
        private Info m_vorbisInfo = null;
        private Comment m_vorbisComment = null;
        private DspState m_vorbisDspState = null;
        private Block m_vorbisBlock = null;
        private List m_songComments = new ArrayList();
        private int convsize = -1;
        private byte[] convbuffer = new byte[4096];
        private float[][][] _pcmf = null;
        private int[] _index = null;
        private int loopid = 1;
        private int eos = 0;
        private boolean streamStillHasData = true;

        private final void init_jorbis() {
            this.m_oggSyncState = new SyncState();
            this.m_oggStreamState = new StreamState();
            this.m_oggPage = new Page();
            this.m_oggPacket = new Packet();
            this.m_vorbisInfo = new Info();
            this.m_vorbisComment = new Comment();
            this.m_vorbisDspState = new DspState();
            this.m_vorbisBlock = new Block(this.m_vorbisDspState);
            this.m_oggSyncState.init();
        }

        public void execute() {
            block33: {
                int n = 0;
                if (this.streamStillHasData) {
                    if (this.loopid == 1) {
                        if (DEBUG) {
                            System.err.println("loop1");
                        }
                        this.eos = 0;
                        try {
                            this.readHeaders();
                        }
                        catch (IOException iOException) {
                            this.streamStillHasData = false;
                            return;
                        }
                        this.loopid = 2;
                    }
                    switch (this.eos) {
                        case 0: {
                            int n2;
                            if (DEBUG) {
                                System.err.println("loop2");
                            }
                            switch (this.eos) {
                                case 0: {
                                    n2 = this.m_oggSyncState.pageout(this.m_oggPage);
                                    if (DEBUG) {
                                        System.err.println("loop3:" + n2);
                                    }
                                    if (n2 == 0) {
                                        this.loopid = 2;
                                        break;
                                    }
                                    if (n2 == -1) {
                                        if (DEBUG) {
                                            System.err.println("Corrupt or missing data in bitstream; continuing...");
                                        }
                                    } else {
                                        this.m_oggStreamState.pagein(this.m_oggPage);
                                        if (DEBUG) {
                                            System.err.println("Decoding");
                                        }
                                        while ((n2 = this.m_oggStreamState.packetout(this.m_oggPacket)) != 0) {
                                            if (n2 == -1) continue;
                                            this.decodeDataPacket();
                                        }
                                        if (this.m_oggPage.eos() != 0) {
                                            this.eos = 1;
                                        }
                                    }
                                    this.loopid = 3;
                                    break;
                                }
                                default: {
                                    this.loopid = 2;
                                    break;
                                }
                            }
                            if (this.loopid == 3) {
                                return;
                            }
                            if (this.eos == 0) {
                                n2 = this.m_oggSyncState.buffer(2048);
                                n = this.readFromStream(this.m_oggSyncState.data, n2, 2048);
                                if (DEBUG) {
                                    System.err.println("More data : " + n);
                                }
                                if (n == -1) {
                                    if (DEBUG) {
                                        System.err.println("Ogg Stream empty.");
                                    }
                                    this.streamStillHasData = false;
                                    this.eos = 1;
                                } else {
                                    this.m_oggSyncState.wrote(n);
                                    if (n == 0) {
                                        this.eos = 1;
                                    }
                                }
                            }
                            this.loopid = 2;
                            break;
                        }
                        default: {
                            this.loopid = 1;
                            break;
                        }
                    }
                    if (this.loopid == 2) {
                        return;
                    }
                    this.m_oggStreamState.clear();
                    this.m_vorbisBlock.clear();
                    this.m_vorbisDspState.clear();
                    this.m_vorbisInfo.clear();
                } else {
                    this.m_oggSyncState.clear();
                    if (DEBUG) {
                        System.out.println("Done Song.");
                    }
                    try {
                        if (this.m_oggBitStream != null) {
                            this.m_oggBitStream.close();
                        }
                        this.m_circularBuffer.close();
                    }
                    catch (Exception exception) {
                        if (!DEBUG) break block33;
                        exception.printStackTrace();
                    }
                }
            }
        }

        private final void readHeaders() throws IOException {
            this.readIdentificationHeader();
            this.readCommentAndCodebookHeaders();
            this.processComments();
            this.setupVorbisStructures();
        }

        private final void readIdentificationHeader() throws IOException {
            int n = this.m_oggSyncState.buffer(2048);
            int n2 = this.readFromStream(this.m_oggSyncState.data, n, 2048);
            if (n2 == -1) {
                throw new IOException("Cannot get any data from selected Ogg bitstream.");
            }
            this.m_oggSyncState.wrote(n2);
            if (this.m_oggSyncState.pageout(this.m_oggPage) != 1) {
                if (n2 < 2048) {
                    throw new IOException("EOF");
                }
                throw new IOException("Input does not appear to be an Ogg bitstream.");
            }
            this.m_oggStreamState.init(this.m_oggPage.serialno());
            this.m_vorbisInfo.init();
            this.m_vorbisComment.init();
            if (this.m_oggStreamState.pagein(this.m_oggPage) < 0) {
                throw new IOException("Error reading first page of Ogg bitstream data.");
            }
            if (this.m_oggStreamState.packetout(this.m_oggPacket) != 1) {
                throw new IOException("Error reading initial header packet.");
            }
            if (this.m_vorbisInfo.synthesis_headerin(this.m_vorbisComment, this.m_oggPacket) < 0) {
                throw new IOException("This Ogg bitstream does not contain Vorbis audio data.");
            }
        }

        private final void readCommentAndCodebookHeaders() throws IOException {
            int n = 0;
            while (n < 2) {
                this.readOggPacket();
                this.m_vorbisInfo.synthesis_headerin(this.m_vorbisComment, this.m_oggPacket);
                ++n;
            }
        }

        private final void processComments() {
            byte[][] byArray = this.m_vorbisComment.user_comments;
            String string = "";
            this.m_songComments.clear();
            int n = 0;
            while (n < byArray.length) {
                String string2;
                if (byArray[n] == null) break;
                string = new String(byArray[n], 0, byArray[n].length - 1).trim();
                this.m_songComments.add(string);
                if (string.toUpperCase().startsWith("ARTIST")) {
                    string2 = string.substring(7);
                } else if (string.toUpperCase().startsWith("TITLE")) {
                    string2 = string.substring(6);
                    String string3 = string.substring(6);
                }
                if (DEBUG) {
                    System.err.println("Comment: " + string);
                }
                ++n;
            }
            string = "Bitstream: " + this.m_vorbisInfo.channels + " channel," + this.m_vorbisInfo.rate + "Hz";
            this.m_songComments.add(string);
            if (DEBUG) {
                System.err.println(string);
            }
            if (DEBUG) {
                string = "Encoded by: " + new String(this.m_vorbisComment.vendor, 0, this.m_vorbisComment.vendor.length - 1);
            }
            this.m_songComments.add(string);
            if (DEBUG) {
                System.err.println(string);
            }
        }

        private final void setupVorbisStructures() {
            this.convsize = 2048 / this.m_vorbisInfo.channels;
            this.m_vorbisDspState.synthesis_init(this.m_vorbisInfo);
            this.m_vorbisBlock.init(this.m_vorbisDspState);
            this._pcmf = new float[1][][];
            this._index = new int[this.m_vorbisInfo.channels];
        }

        private final void decodeDataPacket() {
            int n;
            if (this.m_vorbisBlock.synthesis(this.m_oggPacket) == 0) {
                this.m_vorbisDspState.synthesis_blockin(this.m_vorbisBlock);
            }
            while ((n = this.m_vorbisDspState.synthesis_pcmout(this._pcmf, this._index)) > 0) {
                float[][] fArray = this._pcmf[0];
                int n2 = n < this.convsize ? n : this.convsize;
                int n3 = 0;
                while (n3 < this.m_vorbisInfo.channels) {
                    int n4 = n3 * this.getSampleSizeInBytes();
                    int n5 = this._index[n3];
                    int n6 = 0;
                    while (n6 < n2) {
                        float f = fArray[n3][n5 + n6];
                        this.clipAndWriteSample(f, n4);
                        n4 += this.getFrameSize();
                        ++n6;
                    }
                    ++n3;
                }
                this.m_circularBuffer.write(this.convbuffer, 0, this.getFrameSize() * n2);
                this.m_vorbisDspState.synthesis_read(n2);
            }
        }

        private final void clipAndWriteSample(float f, int n) {
            if (f > 1.0f) {
                f = 1.0f;
            }
            if (f < -1.0f) {
                f = -1.0f;
            }
            switch (((AudioInputStream)((Object)this)).getFormat().getSampleSizeInBits()) {
                case 16: {
                    int n2 = (int)(f * 32767.0f);
                    if (this.isBigEndian()) {
                        this.convbuffer[n++] = (byte)(n2 >> 8);
                        this.convbuffer[n] = (byte)(n2 & 0xFF);
                        break;
                    }
                    this.convbuffer[n++] = (byte)(n2 & 0xFF);
                    this.convbuffer[n] = (byte)(n2 >> 8);
                    break;
                }
                case 24: {
                    int n3 = (int)(f * 8388607.0f);
                    if (this.isBigEndian()) {
                        this.convbuffer[n++] = (byte)(n3 >> 16);
                        this.convbuffer[n++] = (byte)(n3 >>> 8 & 0xFF);
                        this.convbuffer[n] = (byte)(n3 & 0xFF);
                        break;
                    }
                    this.convbuffer[n++] = (byte)(n3 & 0xFF);
                    this.convbuffer[n++] = (byte)(n3 >>> 8 & 0xFF);
                    this.convbuffer[n] = (byte)(n3 >> 16);
                    break;
                }
                case 32: {
                    int n4 = (int)(f * 2.1474836E9f);
                    if (this.isBigEndian()) {
                        this.convbuffer[n++] = (byte)(n4 >> 24);
                        this.convbuffer[n++] = (byte)(n4 >>> 16 & 0xFF);
                        this.convbuffer[n++] = (byte)(n4 >>> 8 & 0xFF);
                        this.convbuffer[n] = (byte)(n4 & 0xFF);
                        break;
                    }
                    this.convbuffer[n++] = (byte)(n4 & 0xFF);
                    this.convbuffer[n++] = (byte)(n4 >>> 8 & 0xFF);
                    this.convbuffer[n++] = (byte)(n4 >>> 16 & 0xFF);
                    this.convbuffer[n] = (byte)(n4 >> 24);
                    break;
                }
            }
        }

        private final void readOggPacket() throws IOException {
            int n;
            while ((n = this.m_oggStreamState.packetout(this.m_oggPacket)) != 1) {
                if (n == -1) {
                    throw new IOException("Corrupt secondary header.  Exiting.");
                }
                this.readOggPage();
                this.m_oggStreamState.pagein(this.m_oggPage);
            }
            return;
        }

        private final void readOggPage() throws IOException {
            int n;
            while ((n = this.m_oggSyncState.pageout(this.m_oggPage)) != 1) {
                int n2 = this.m_oggSyncState.buffer(2048);
                int n3 = this.readFromStream(this.m_oggSyncState.data, n2, 2048);
                if (n3 == -1) {
                    throw new EOFException();
                }
                this.m_oggSyncState.wrote(n3);
            }
            return;
        }

        private final int readFromStream(byte[] byArray, int n, int n2) {
            int n3 = 0;
            try {
                n3 = this.m_oggBitStream.read(byArray, n, n2);
            }
            catch (Exception exception) {
                if (DEBUG) {
                    System.out.println("Cannot Read Selected Song");
                }
                n3 = -1;
            }
            return n3;
        }

        private final int getSampleSizeInBytes() {
            return ((AudioInputStream)((Object)this)).getFormat().getFrameSize() / ((AudioInputStream)((Object)this)).getFormat().getChannels();
        }

        private final int getFrameSize() {
            return ((AudioInputStream)((Object)this)).getFormat().getFrameSize();
        }

        private final boolean isBigEndian() {
            return ((AudioInputStream)((Object)this)).getFormat().isBigEndian();
        }

        public void close() throws IOException {
            super.close();
            this.m_oggBitStream.close();
        }

        public DecodedJorbisAudioInputStream(AudioFormat audioFormat, AudioInputStream audioInputStream) {
            super(audioFormat, -1L);
            this.m_oggBitStream = audioInputStream;
            this.loopid = 1;
            this.init_jorbis();
        }
    }
}

