<?php
    class DownloadFile 
    {
        private $path = "";
        private $contenttype = "";
        private $contentdisposition = "";
        private $filename = "";

        function __construct($path, $contenttype = "application/octet-stream", $contentdisposition = "attachment", $filename = "") 
        {
            $this->path = $path;
            $this->contenttype = $contenttype;
            $this->contentdisposition = $contentdisposition . "filename=$this->filename";
            $this->filename = $filename ? $filename : basename($path);
        }

        // check is specified file exists?

        function exists() 
        {
            $ex = file_exists($this->path);

            return $ex;
        }

        // get file size

        function size() 
        {
            $fs = filesize($this->path);

            return $fs;
        }

        // return permission number for user 'other'

        function permitother() 
        {
            $perm = substr(decoct(fileperms($this->path)), -1);

            return $perm;
        }

        // download file

        function download() 
        {
            if  ($this->exists() && $this->permitother() >= 4) 
            {
                header("Content-type: " . $this->contenttype);
                header("Content-Disposition: " . $this->contentdisposition . "; filename=\"" . $this->filename . "\"");
                header("Content-Length: " . $this->size());

                $fp = readfile($this->path, "r");
                return $fp;
            }

            return false;
        }
    }
?>
