/*
 * Decompiled with CFR 0.152.
 */
package org.sourceforge.jbinstall.page;

import de.monoped.wizard.Page;
import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import org.sourceforge.jbinstall.Data;
import org.sourceforge.jbinstall.Jbutils;

public class Start
extends Page<Data>
implements ActionListener {
    private ButtonGroup progApplGroup = new ButtonGroup();
    private ButtonGroup localRemoteGroup = new ButtonGroup();
    private ButtonGroup expertGroup = new ButtonGroup();
    private JRadioButton progButton;
    private JRadioButton remoteButton;
    private JRadioButton simpleButton;
    private boolean versionTested;

    public Start() {
        double[][] dArrayArray = new double[][]{{-1.0, -2.0, 10.0, -2.0, -1.0}, {10.0, -2.0, 30.0, -2.0, 10.0, -2.0, 10.0, -2.0}};
        this.setLayout(new TableLayout(dArrayArray));
        this.add((Component)new JLabel("<html><font color=\"blue\">" + Jbutils.getString("location"), 0), "1, 1, 3, 1");
        this.progButton = this.createRadioButton("program", this.progApplGroup);
        this.add((Component)this.progButton, "1, 3");
        this.add((Component)this.createRadioButton("applet", this.progApplGroup), "3, 3");
        this.remoteButton = this.createRadioButton("remote", this.localRemoteGroup);
        this.add((Component)this.remoteButton, "1, 5");
        this.add((Component)this.createRadioButton("local", this.localRemoteGroup), "3, 5");
        this.simpleButton = this.createRadioButton("simple", this.expertGroup);
        this.add((Component)this.simpleButton, "1, 7");
        this.add((Component)this.createRadioButton("expert", this.expertGroup), "3, 7");
        this.simpleButton.setSelected(true);
    }

    @Override
    public boolean isPageComplete() {
        return this.progApplGroup.getSelection() != null && this.localRemoteGroup.getSelection() != null;
    }

    private JRadioButton createRadioButton(String string, ButtonGroup buttonGroup) {
        JRadioButton jRadioButton = new JRadioButton();
        Jbutils.nameButton(jRadioButton, string);
        jRadioButton.addActionListener(this);
        buttonGroup.add(jRadioButton);
        return jRadioButton;
    }

    @Override
    public String getHelpName() {
        return "Start";
    }

    @Override
    public String getNext() {
        if (this.progButton.isSelected()) {
            return this.remoteButton.isSelected() ? "org.sourceforge.jbinstall.page.RemoteProgram" : "org.sourceforge.jbinstall.page.LocalProgram";
        }
        return this.remoteButton.isSelected() ? "org.sourceforge.jbinstall.page.RemoteApplet" : "org.sourceforge.jbinstall.page.LocalApplet";
    }

    @Override
    public void start() {
        String string = System.getProperty("java.specification.version");
        if (!this.versionTested) {
            if (string.charAt(2) < '6' && JOptionPane.showConfirmDialog(this, Jbutils.getString("javaversion", string), Jbutils.getString("warning"), 0, 2) != 0) {
                this.getWizard().dispose();
                System.exit(0);
            }
            this.versionTested = true;
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Data data = (Data)this.getWizard().getData();
        data.modus = this.progButton.isSelected() ? Data.Modus.PROGRAM : Data.Modus.APPLET;
        data.location = this.remoteButton.isSelected() ? Data.Location.REMOTE : Data.Location.LOCAL;
        boolean bl = data.expert = !this.simpleButton.isSelected();
        if (this.simpleButton.isSelected()) {
            data.config = Data.Config.STD;
        }
        this.checkStatus();
    }
}

