/*
 * Decompiled with CFR 0.152.
 */
package org.sourceforge.jbinstall.page;

import de.monoped.wizard.Page;
import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.net.URL;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import org.sourceforge.jbinstall.Data;
import org.sourceforge.jbinstall.Jbutils;

abstract class RemotePaths
extends Page<Data> {
    private JTextField dirField;
    private JTextField dirURLField;
    private TableLayout layout;
    protected boolean first = true;
    protected static final double HGAP = 5.0;
    protected static final double VGAP = 5.0;

    RemotePaths() {
        double[][] dArrayArray = new double[][]{{5.0, -2.0, 5.0, -1.0, 5.0}, {10.0, -2.0, 10.0, -2.0, 5.0, -2.0, 5.0, -2.0, 5.0, -2.0}};
        this.layout = new TableLayout(dArrayArray);
        this.setLayout(this.layout);
        this.dirField = new JTextField("jboom");
        this.dirURLField = new JTextField();
        this.add((Component)new JLabel("<html><font color=\"blue\">" + Jbutils.getString("remoteProgFilesHeader"), 0), "1, 1, 3, 1");
        this.addInputLine("installdir", this.dirField, 3);
        this.addInputLine("dirURL", this.dirURLField, 5);
    }

    protected void addInputLine(String string, JTextField jTextField, int n) {
        this.add((Component)Jbutils.createLabel(string, jTextField), "1," + n);
        this.add((Component)jTextField, "3," + n);
        jTextField.getDocument().addDocumentListener(this);
    }

    @Override
    public boolean exit() {
        try {
            String string = this.getDirURL();
            if (string.length() == 0) {
                return true;
            }
            URL uRL = new URL(string);
            if (!uRL.getProtocol().equals("http")) {
                JOptionPane.showMessageDialog(this, Jbutils.getString("wrongprot"), Jbutils.getString("error"), 0);
                return false;
            }
        }
        catch (Exception exception) {
            Jbutils.showException(exception);
            return false;
        }
        return true;
    }

    protected String getDir() {
        return this.dirField.getText().trim();
    }

    protected String getDirURL() {
        return this.dirURLField.getText().trim();
    }

    protected TableLayout getTableLayout() {
        return this.layout;
    }

    @Override
    public boolean isPageComplete() {
        String string = this.getDirURL().trim();
        if (string.length() == 0) {
            return false;
        }
        return this.getDir().length() > 0 && string.length() > 0;
    }

    @Override
    public void start() {
        if (this.first) {
            this.dirURLField.setText("http://" + ((Data)this.getWizard().getData()).host + "/jboom");
            this.first = false;
        }
    }
}

