/*
 * Decompiled with CFR 0.152.
 */
package org.sourceforge.jbinstall.page;

import de.monoped.wizard.Page;
import info.clearthought.layout.TableLayout;
import java.awt.Component;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import org.sourceforge.jbinstall.Data;
import org.sourceforge.jbinstall.Jbutils;

public class RemoteConfigSimple
extends Page<Data> {
    static final int HGAP = 5;
    static final int VGAP = 5;
    private JRadioButton localButton;
    private JRadioButton remoteButton;
    private ButtonGroup group;

    public RemoteConfigSimple() {
        double[][] dArrayArray = new double[][]{{5.0, 0.5, 5.0, 0.5, 5.0}, {10.0, -2.0, 10.0, -2.0, 5.0}};
        this.setLayout(new TableLayout(dArrayArray));
        this.group = new ButtonGroup();
        this.localButton = this.createRadioButton("local");
        this.localButton.setSelected(true);
        this.remoteButton = this.createRadioButton("remote");
        this.add((Component)new JLabel("<html><font color=\"blue\">" + Jbutils.getString("confHeader"), 0), "1, 1, 3, 1");
        this.add((Component)this.localButton, "1, 3, c, c");
        this.add((Component)this.remoteButton, "3, 3, c, c");
    }

    @Override
    public boolean exit() {
        Data data = (Data)this.getWizard().getData();
        if (this.remoteButton.isSelected()) {
            data.config = Data.Config.REMOTE;
            data.confProtocol = data.protocol;
            data.confHost = data.host;
            data.confUser = data.user;
            data.confPassword = data.password;
            data.confPath = data.path;
            data.confAuth = data.auth;
            data.confKey = data.key;
            data.confPath = data.installDir + "/jboomrc.xml";
        } else {
            data.config = Data.Config.STD;
        }
        return true;
    }

    private JRadioButton createRadioButton(String string) {
        JRadioButton jRadioButton = new JRadioButton();
        Jbutils.nameButton(jRadioButton, string);
        this.group.add(jRadioButton);
        return jRadioButton;
    }

    @Override
    public String getHelpName() {
        return "RemoteConfigSimple";
    }

    @Override
    public String getNext() {
        return null;
    }

    @Override
    public boolean isPageComplete() {
        return true;
    }
}

