/*
 * Decompiled with CFR 0.152.
 */
package org.sourceforge.jbinstall.page;

import info.clearthought.layout.TableLayout;
import java.awt.Component;
import javax.swing.JCheckBox;
import javax.swing.JTextField;
import org.sourceforge.jbinstall.Data;
import org.sourceforge.jbinstall.Jbutils;
import org.sourceforge.jbinstall.page.RemotePaths;

public class RemoteAppletPaths
extends RemotePaths {
    private JCheckBox withJSBox = new JCheckBox();
    private JTextField htmlField;

    public RemoteAppletPaths() {
        this.withJSBox.setSelected(true);
        Jbutils.nameButton(this.withJSBox, "withJS");
        this.add((Component)this.withJSBox, "1, 7, 3, 7");
        this.htmlField = new JTextField();
        this.htmlField.setText("jbapplet.html");
        this.addInputLine("html", this.htmlField, 9);
    }

    @Override
    public boolean exit() {
        if (!super.exit()) {
            return false;
        }
        Data data = (Data)this.getWizard().getData();
        data.installDir = this.getDir();
        data.dirURL = this.getDirURL();
        data.javascript = this.withJSBox.isSelected();
        if (data.expert) {
            String string;
            data.html1 = string = this.getHtml();
            int n = string.lastIndexOf(".");
            data.html2 = string.substring(0, n) + "_" + string.substring(n);
        } else {
            data.html1 = "jbapplet.html";
            data.html2 = "jbapplet_.html";
        }
        return true;
    }

    private String getHtml() {
        String string = this.htmlField.getText().trim();
        if (!(string.length() <= 0 || string.endsWith(".html") || string.endsWith(".HTML") || string.endsWith(".htm") || string.endsWith(".HTM"))) {
            string = string + ".html";
        }
        return string;
    }

    @Override
    public String getNext() {
        if (((Data)this.getWizard().getData()).expert) {
            return "org.sourceforge.jbinstall.page.RemoteConfig";
        }
        return null;
    }

    @Override
    public String getHelpName() {
        return ((Data)this.getWizard().getData()).expert ? "RemoteAppletPathsExpert" : "RemoteAppletPaths";
    }

    @Override
    public boolean isPageComplete() {
        return super.isPageComplete() && this.getHtml().length() > 0;
    }

    @Override
    public void start() {
        super.start();
        TableLayout tableLayout = this.getTableLayout();
        if (((Data)this.getWizard().getData()).expert) {
            tableLayout.setRow(8, 5.0);
            tableLayout.setRow(9, -2.0);
        } else {
            tableLayout.setRow(8, 0.0);
            tableLayout.setRow(9, 0.0);
        }
    }
}

