/*
 * Decompiled with CFR 0.152.
 */
package org.sourceforge.jbinstall.page;

import de.monoped.wizard.Page;
import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.sourceforge.jbinstall.Data;
import org.sourceforge.jbinstall.Jbutils;

abstract class Remote
extends Page<Data>
implements ActionListener {
    private static final int HGAP = 5;
    private static final int VGAP = 5;
    private ButtonGroup protocolGroup;
    private ButtonGroup authGroup;
    private JRadioButton ftpButton;
    private JRadioButton sshButton;
    private JRadioButton passwordButton;
    private JRadioButton keyButton;
    private JLabel passwordLabel;
    private JTextField hostField;
    private JTextField userField;
    private JTextField passwordField;
    private JTextField keyField;
    private JButton searchButton;
    private TableLayout layout;
    private JFileChooser chooser;

    Remote(String string) {
        double[][] dArrayArray = new double[][]{{5.0, -2.0, 5.0, -2.0, 5.0, -1.0, 5.0, -2.0, 5.0}, {10.0, -2.0, 10.0, -2.0, 5.0, -2.0, 5.0, -2.0, 5.0, -2.0, 5.0, 0.0, 5.0, -2.0, 20.0}};
        this.layout = new TableLayout(dArrayArray);
        this.setLayout(this.layout);
        this.chooser = new JFileChooser();
        this.protocolGroup = new ButtonGroup();
        this.ftpButton = this.createRadioButton("ftp", this.protocolGroup);
        this.sshButton = this.createRadioButton("ssh", this.protocolGroup);
        this.ftpButton.setSelected(true);
        this.hostField = new JTextField();
        this.hostField.getDocument().addDocumentListener(this);
        this.userField = new JTextField();
        this.userField.getDocument().addDocumentListener(this);
        this.passwordField = new JPasswordField();
        this.keyField = new JTextField();
        this.keyField.setText(new File(System.getProperty("user.home"), ".ssh").getAbsolutePath());
        this.keyField.setEnabled(false);
        this.keyField.getDocument().addDocumentListener(this);
        this.add((Component)new JLabel("<html><font color=\"blue\">" + Jbutils.getString(string), 0), "1, 1, 7, 1");
        this.add((Component)new JLabel(Jbutils.getString("protocol")), "1, 3");
        this.add((Component)this.ftpButton, "3, 3");
        this.add((Component)this.sshButton, "5, 3");
        this.addInputLine("hostname", this.hostField, 5, 3, 7);
        this.addInputLine("username", this.userField, 7, 3, 7);
        this.authGroup = new ButtonGroup();
        this.passwordButton = (JRadioButton)Jbutils.nameButton(new JRadioButton(), "password");
        this.add((Component)this.passwordField, "3, 9, 7, 9");
        this.passwordField.getDocument().addDocumentListener(this);
        this.authGroup.add(this.passwordButton);
        this.passwordButton.addActionListener(this);
        this.passwordButton.setSelected(true);
        this.passwordLabel = Jbutils.createLabel("password", this.passwordField);
        this.add((Component)this.passwordLabel, "1, 9");
        this.searchButton = (JButton)Jbutils.nameButton(new JButton(), "choose");
        this.searchButton.addActionListener(this);
        this.keyButton = (JRadioButton)Jbutils.nameButton(new JRadioButton(), "privatekey");
        this.authGroup.add(this.keyButton);
        this.keyButton.addActionListener(this);
        this.add((Component)this.keyButton, "1, 11");
        this.add((Component)this.keyField, "3, 11, 5, 11");
        this.add((Component)this.searchButton, "7, 11");
    }

    private JRadioButton addButtonInput(String string, JTextField jTextField, int n, int n2, int n3) {
        JRadioButton jRadioButton = (JRadioButton)Jbutils.nameButton(new JRadioButton(), string);
        this.add((Component)jRadioButton, "1," + n);
        this.add((Component)jTextField, n2 + "," + n + "," + n3 + "," + n);
        jTextField.getDocument().addDocumentListener(this);
        this.authGroup.add(jRadioButton);
        jRadioButton.addActionListener(this);
        return jRadioButton;
    }

    protected void addInputLine(String string, JTextField jTextField, int n, int n2, int n3) {
        this.add((Component)Jbutils.createLabel(string, jTextField), "1," + n);
        this.add((Component)jTextField, n2 + "," + n + "," + n3 + "," + n);
        jTextField.getDocument().addDocumentListener(this);
    }

    private JRadioButton createRadioButton(String string, ButtonGroup buttonGroup) {
        JRadioButton jRadioButton = new JRadioButton();
        Jbutils.nameButton(jRadioButton, string);
        jRadioButton.addActionListener(this);
        buttonGroup.add(jRadioButton);
        return jRadioButton;
    }

    @Override
    public String getHelpName() {
        return "Remote";
    }

    protected String getHost() {
        return this.hostField.getText().trim();
    }

    protected String getKey() {
        return this.keyField.getText().trim();
    }

    protected String getPassword() {
        return this.passwordField.getText().trim();
    }

    protected Data.Protocol getProtocol() {
        return this.ftpButton.isSelected() ? Data.Protocol.FTP : Data.Protocol.SSH;
    }

    public Data.Auth getSshAuth() {
        return this.keyButton.isSelected() ? Data.Auth.KEY : Data.Auth.PASSWD;
    }

    protected String getUser() {
        return this.userField.getText().trim();
    }

    @Override
    public boolean isPageComplete() {
        return this.protocolGroup.getSelection() != null && this.getHost().length() > 0 && this.getUser().length() > 0 && (this.passwordButton.isSelected() && this.getPassword().length() > 0 || this.keyButton.isSelected() && this.getKey().length() > 0);
    }

    protected void setFields(Data.Protocol protocol, String string, String string2, Data.Auth auth, String string3, String string4) {
        if (protocol == Data.Protocol.FTP) {
            this.layout.setRow(11, 0.0);
            this.layout.setRow(12, 0.0);
            this.remove(this.passwordButton);
            this.add((Component)this.passwordLabel, "1, 9");
            this.ftpButton.setSelected(true);
        } else if (protocol == Data.Protocol.SSH) {
            this.layout.setRow(11, -2.0);
            this.layout.setRow(12, 5.0);
            this.remove(this.passwordLabel);
            this.add((Component)this.passwordButton, "1, 9");
            this.sshButton.setSelected(true);
            if (auth == Data.Auth.PASSWD) {
                this.passwordButton.setSelected(true);
                this.passwordField.setEnabled(true);
                this.keyField.setEnabled(false);
                this.searchButton.setEnabled(false);
            } else {
                this.keyButton.setSelected(true);
                this.passwordField.setEnabled(false);
                this.keyField.setEnabled(true);
                this.searchButton.setEnabled(true);
            }
        }
        this.revalidate();
        this.getWizard().repaint();
        this.hostField.setText(string);
        this.userField.setText(string2);
        this.passwordField.setText(string3);
        this.keyField.setText(string4);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.sshButton) {
            this.layout.setRow(11, -2.0);
            this.layout.setRow(12, 5.0);
            this.remove(this.passwordLabel);
            this.add((Component)this.passwordButton, "1, 9");
            this.revalidate();
        } else if (object == this.ftpButton) {
            this.layout.setRow(11, 0.0);
            this.layout.setRow(12, 0.0);
            this.remove(this.passwordButton);
            this.add((Component)this.passwordLabel, "1, 9");
            this.revalidate();
        } else if (object == this.passwordButton) {
            this.passwordField.requestFocus();
        } else if (object == this.keyButton) {
            this.keyField.requestFocus();
        } else if (object == this.searchButton) {
            this.chooser.setCurrentDirectory(new File(this.keyField.getText()));
            int n = this.chooser.showOpenDialog(this);
            if (n == 0) {
                this.keyField.setText(this.chooser.getSelectedFile().toString());
            }
        }
        this.passwordField.setEnabled(this.passwordButton.isSelected());
        this.keyField.setEnabled(this.keyButton.isSelected());
        this.searchButton.setEnabled(this.keyButton.isSelected());
        this.checkStatus();
    }
}

