/*
 * Decompiled with CFR 0.152.
 */
package org.sourceforge.jbinstall.page;

import de.monoped.wizard.Page;
import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.sourceforge.jbinstall.Data;
import org.sourceforge.jbinstall.Jbutils;

public class LocalApplet
extends Page<Data>
implements ActionListener {
    private static final int HGAP = 5;
    private static final int VGAP = 5;
    private JCheckBox withJSBox;
    private JButton searchButton;
    private JTextField htmlField;
    private JTextField pathField;
    private JFileChooser chooser;
    private boolean expert;
    private TableLayout layout;

    public LocalApplet() {
        double[][] dArrayArray = new double[][]{{5.0, -2.0, 5.0, -1.0, 5.0, -2.0, 5.0}, {10.0, -2.0, 10.0, -2.0, 5.0, -2.0, 5.0, -2.0, 5.0}};
        this.layout = new TableLayout(dArrayArray);
        this.setLayout(this.layout);
        this.chooser = new JFileChooser();
        this.chooser.setFileSelectionMode(1);
        this.withJSBox = new JCheckBox();
        Jbutils.nameButton(this.withJSBox, "withJS");
        this.withJSBox.addActionListener(this);
        this.pathField = new JTextField();
        this.pathField.getDocument().addDocumentListener(this);
        this.htmlField = new JTextField();
        this.htmlField.getDocument().addDocumentListener(this);
        this.htmlField.setText("jboom.html");
        this.htmlField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                String string = LocalApplet.this.getHtml();
                int n = string.lastIndexOf(".");
                ((Data)((LocalApplet)LocalApplet.this).wizard.getData()).html1 = string;
                ((Data)((LocalApplet)LocalApplet.this).wizard.getData()).html2 = string.substring(0, n) + "_" + string.substring(n);
            }
        });
        JLabel jLabel = Jbutils.createLabel("dirpath", this.pathField);
        JLabel jLabel2 = Jbutils.createLabel("html", this.htmlField);
        this.searchButton = (JButton)Jbutils.nameButton(new JButton(), "choose");
        this.searchButton.addActionListener(this);
        this.add((Component)new JLabel("<html><font color=\"blue\">" + Jbutils.getString("localAppletHeader"), 0), "1, 1, 3, 1");
        this.add((Component)jLabel, "1, 3");
        this.add((Component)this.pathField, "3, 3");
        this.add((Component)this.searchButton, "5, 3");
        this.add((Component)this.withJSBox, "1, 5, 3, 5");
        this.add((Component)jLabel2, "1, 7");
        this.add((Component)this.htmlField, "3, 7");
    }

    @Override
    public boolean exit() {
        if (this.expert) {
            String string = this.getHtml();
            int n = string.lastIndexOf(".");
            ((Data)this.wizard.getData()).html1 = string;
            ((Data)this.wizard.getData()).html2 = string.substring(0, n) + "_" + string.substring(n);
        }
        ((Data)this.wizard.getData()).installDir = this.getPath();
        return true;
    }

    @Override
    public String getHelpName() {
        return this.expert ? "LocalAppletExpert" : "LocalApplet";
    }

    private String getHtml() {
        String string = this.htmlField.getText().trim();
        if (string.length() == 0) {
            return string;
        }
        if (string.endsWith(".html") || string.endsWith(".HTML") || string.endsWith(".htm") || string.endsWith(".HTM")) {
            return string;
        }
        return string + ".html";
    }

    @Override
    public String getNext() {
        if (this.expert) {
            return "org.sourceforge.jbinstall.page.LocalConfig";
        }
        return null;
    }

    private String getPath() {
        String string = this.pathField.getText().trim();
        if (string.length() > 0) {
            return Jbutils.absolutePath(string);
        }
        return string;
    }

    @Override
    public boolean isPageComplete() {
        return this.pathField.getText().trim().length() > 0 && (!this.expert || this.getHtml().length() > 0);
    }

    @Override
    public void start() {
        Data data = (Data)this.getWizard().getData();
        this.withJSBox.setSelected(data.javascript);
        this.expert = data.expert;
        if (data.expert) {
            this.layout.setRow(6, 5.0);
            this.layout.setRow(7, -2.0);
        } else {
            this.layout.setRow(6, 0.0);
            this.layout.setRow(7, 0.0);
            ((Data)this.wizard.getData()).html1 = "jbapplet.html";
            ((Data)this.wizard.getData()).html2 = "jbapplet_.html";
        }
        this.checkStatus();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.searchButton) {
            this.chooser.setSelectedFile(new File(this.pathField.getText()));
            int n = this.chooser.showOpenDialog(this);
            if (n == 0) {
                this.pathField.setText(this.chooser.getSelectedFile().toString());
            }
        } else if (object == this.withJSBox) {
            ((Data)this.wizard.getData()).javascript = this.withJSBox.isSelected();
        }
        this.checkStatus();
    }
}

