/*
 * Decompiled with CFR 0.152.
 */
package org.sourceforge.jbinstall.page;

import de.monoped.wizard.Page;
import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.sourceforge.jbinstall.Data;
import org.sourceforge.jbinstall.Jbutils;

abstract class Config
extends Page<Data>
implements ActionListener {
    static final int HGAP = 5;
    static final int VGAP = 5;
    private JRadioButton noButton;
    private JRadioButton localStdButton;
    private JRadioButton localPathButton;
    private JButton searchButton;
    private JTextField pathField;
    private JFileChooser chooser;
    private ButtonGroup group;
    protected TableLayout layout;

    Config(String string) {
        double[][] dArrayArray = new double[][]{{5.0, -2.0, 5.0, -1.0, 5.0, -2.0, 5.0}, {10.0, -2.0, 10.0, -2.0, 5.0, -2.0, 5.0, -2.0, 5.0}};
        this.layout = new TableLayout(dArrayArray);
        this.setLayout(this.layout);
        this.group = new ButtonGroup();
        this.chooser = new JFileChooser();
        this.noButton = this.createRadioButton("noConf");
        this.noButton.addActionListener(this);
        this.localStdButton = this.createRadioButton("localStd");
        this.localStdButton.addActionListener(this);
        this.localStdButton.setSelected(true);
        this.localPathButton = this.createRadioButton("localPath");
        this.localPathButton.addActionListener(this);
        this.pathField = new JTextField();
        this.pathField.setEnabled(false);
        this.pathField.getDocument().addDocumentListener(this);
        this.searchButton = (JButton)Jbutils.nameButton(new JButton(), "choose");
        this.searchButton.addActionListener(this);
        this.searchButton.setEnabled(false);
        this.add((Component)new JLabel(string, 0), "1, 1, 5, 1");
        this.add((Component)this.noButton, "1, 3");
        this.add((Component)this.localStdButton, "1, 5, 3, 5");
        this.add((Component)this.localPathButton, "1, 7");
        this.add((Component)this.pathField, "3, 7");
        this.add((Component)this.searchButton, "5, 7");
    }

    @Override
    public boolean exit() {
        Data data = (Data)this.getWizard().getData();
        data.config = this.noButton.isSelected() ? Data.Config.NO : (this.localStdButton.isSelected() ? Data.Config.STD : Data.Config.LOCAL);
        data.confPath = this.getPath();
        return true;
    }

    @Override
    public boolean isPageComplete() {
        if (this.localPathButton.isSelected()) {
            return this.getPath().length() > 0;
        }
        return this.group.getSelection() != null;
    }

    protected JRadioButton createRadioButton(String string) {
        JRadioButton jRadioButton = new JRadioButton();
        Jbutils.nameButton(jRadioButton, string);
        jRadioButton.addActionListener(this);
        this.group.add(jRadioButton);
        return jRadioButton;
    }

    protected String getPath() {
        return this.pathField.getText().trim();
    }

    protected void setPath(String string) {
        this.pathField.setText(string);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.searchButton) {
            this.chooser.setSelectedFile(new File(this.pathField.getText()));
            int n = this.chooser.showOpenDialog(this);
            if (n == 0) {
                this.pathField.setText(this.chooser.getSelectedFile().toString());
            }
        } else if (object == this.localPathButton) {
            this.pathField.setEnabled(true);
            this.searchButton.setEnabled(true);
            this.pathField.requestFocus();
        } else {
            this.pathField.setEnabled(false);
            this.searchButton.setEnabled(false);
        }
        this.checkStatus();
    }
}

