/*
 * Decompiled with CFR 0.152.
 */
package org.sourceforge.jbinstall;

import de.monoped.efile.EFile;
import de.monoped.efile.FtpFile;
import de.monoped.efile.SshFile;
import de.monoped.wizard.Wizard;
import java.io.File;
import org.sourceforge.jbinstall.Data;
import org.sourceforge.jbinstall.Jbinstall;
import org.sourceforge.jbinstall.Jbutils;
import org.sourceforge.jbinstall.RemoteInstaller;

class RemoteProgramInstaller
extends RemoteInstaller {
    private Wizard<Data> wizard;
    Data data;
    private EFile target;

    RemoteProgramInstaller(Wizard<Data> wizard) {
        super(wizard);
        this.wizard = wizard;
        this.data = wizard.getData();
        this.data.call = "javaws " + this.data.dirURL + "/" + this.data.jnlp;
    }

    private String createJnlp() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<jnlp\n").append("\tcodebase=\"").append(this.data.dirURL).append("\"\n").append("\thref=\"" + this.data.jnlp + "\">\n\n").append("\t<information>\n\t\t<title>jBoom</title>\n").append("\t\t<offline-allowed/>\n\t\t<vendor>Bernd Eggink</vendor>\n").append("\t\t<homepage>http://jboom.sourceforge.net/</homepage>\n").append("\t\t<description>Remote bookmark administration</description>\n").append("\t\t<icon kind=\"splash\" href=\"").append(this.data.dirURL).append("/splash.png\"/>\n").append("\t</information>\n").append("\t<resources>\n\t\t<jar href=\"jboom.jar\" main=\"true\" download=\"eager\"/>\n").append("\t<j2se version=\"1.5+\"\n\t\t\thref=\"http://java.sun.com/products/autodl/j2se\"/>\n").append("\t</resources>\n").append("\t<application-desc main-class=\"org.sourceforge.jboom.JBoomProgram\">\n");
        if (this.data.config == Data.Config.NO) {
            stringBuilder.append("\t\t<argument>-c-</argument>\n");
        } else if (this.data.config == Data.Config.LOCAL) {
            stringBuilder.append("\t\t<argument>-c" + this.data.confPath + "</argument>\n");
        } else if (this.data.config == Data.Config.REMOTE) {
            stringBuilder.append("\t\t<argument>-c" + (this.data.confProtocol == Data.Protocol.SSH ? "ssh" : "ftp") + "://" + this.data.confUser + ":" + this.data.confPassword + "@" + this.data.confHost + "/" + this.data.confPath + "</argument>\n");
        }
        stringBuilder.append("\t</application-desc>\n\n\t<security><all-permissions/></security>\n").append("</jnlp>\n");
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Jbutils.Check install() {
        try {
            this.target = this.data.protocol == Data.Protocol.FTP ? new FtpFile(this.data.host, this.data.user, this.data.password, this.data.installDir) : (this.data.auth == Data.Auth.PASSWD ? new SshFile(this.data.host, this.data.user, this.data.password, this.data.installDir) : new SshFile(this.data.host, this.data.user, new File(this.data.key), this.data.installDir));
            if (!Jbutils.checkTargetDirectory(this.target)) {
                Jbutils.Check check = Jbutils.Check.ERR;
                return check;
            }
            this.label2.setText(this.data.jnlp);
            this.target.addPath(this.data.jnlp);
            this.target.putBytes(this.createJnlp().getBytes());
            if (this.isCancelled()) {
                Jbutils.Check check = Jbutils.Check.ERR;
                return check;
            }
            Jbutils.Check check = Jbutils.checkDirURL(this.data, this.data.jnlp);
            if (check == Jbutils.Check.ERR) {
                Jbutils.Check check2 = check;
                return check2;
            }
            this.label2.setText("jboom.jar");
            this.target.setName("jboom.jar");
            this.target.copyFrom(this.getClass().getClassLoader().getResourceAsStream("bin/jboom.jar"));
            if (this.isCancelled()) {
                Jbutils.Check check3 = Jbutils.Check.ERR;
                return check3;
            }
            this.label2.setText("splash.png");
            this.target.setName("splash.png");
            this.target.putBytes(Jbutils.resourceToBytes("splash.png"));
            if (this.isCancelled()) {
                Jbutils.Check check4 = Jbutils.Check.ERR;
                return check4;
            }
            if (this.data.config == Data.Config.REMOTE) {
                this.target.close();
                this.target = null;
                this.target = this.data.confProtocol == Data.Protocol.FTP ? new FtpFile(this.data.confHost, this.data.confUser, this.data.confPassword, this.data.confPath) : (this.data.auth == Data.Auth.PASSWD ? new SshFile(this.data.confHost, this.data.confUser, this.data.confPassword, this.data.confPath) : new SshFile(this.data.confHost, this.data.confUser, new File(this.data.confKey), this.data.confPath));
                this.installConfig(this.target);
            }
        }
        catch (Exception exception) {
            if (Jbinstall.isDebug()) {
                exception.printStackTrace();
            }
            Jbutils.showException(exception);
            Jbutils.Check check = Jbutils.Check.ERR;
            return check;
        }
        finally {
            try {
                if (this.target != null) {
                    this.target.close();
                }
            }
            catch (Exception exception) {}
            this.removeDialog();
        }
        return Jbutils.Check.OK;
    }
}

