/*
 * Decompiled with CFR 0.152.
 */
package org.sourceforge.jbinstall;

import de.monoped.efile.EFile;
import de.monoped.efile.LocalFile;
import de.monoped.swing.RunWait;
import de.monoped.wizard.Wizard;
import java.awt.GridLayout;
import java.io.IOException;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.sourceforge.jbinstall.Data;
import org.sourceforge.jbinstall.Jbutils;

abstract class RemoteInstaller
extends RunWait<Jbutils.Check> {
    private Jbutils.Check result;
    protected JLabel label2;
    protected Data data;

    RemoteInstaller(Wizard<Data> wizard) {
        super(null, Jbutils.getString("wait"), Jbutils.getString("cancel"));
        JPanel jPanel = new JPanel();
        this.data = wizard.getData();
        jPanel.setLayout(new GridLayout(2, 1));
        jPanel.add(new JLabel(Jbutils.getString("transferring"), 0));
        this.label2 = new JLabel("", 0);
        jPanel.add(this.label2);
        this.setComponent(jPanel);
        if (this.data.config == Data.Config.LOCAL && this.data.confPath != null) {
            try {
                LocalFile localFile = new LocalFile(this.data.confPath);
                if (Jbutils.checkTargetFile(localFile)) {
                    localFile.putBytes("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<jboom>\n<connections></connections>\n<sort recursive=\"true\" folderFirst=\"true\"/>\n<find case=\"false\" name=\"true\" url=\"true\"></find>\n<option extract=\"true\"/>\n<localFile>bookmarks.xml</localFile>\n</jboom>\n".getBytes());
                }
            }
            catch (IOException iOException) {
                Jbutils.showException(iOException);
            }
        }
    }

    protected boolean installConfig(EFile eFile) throws IOException {
        String string = eFile.getParent();
        String string2 = eFile.getName();
        this.label2.setText(string2);
        if (!Jbutils.checkTargetFile(eFile)) {
            return false;
        }
        eFile.putBytes("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<jboom>\n<connections></connections>\n<sort recursive=\"true\" folderFirst=\"true\"/>\n<find case=\"false\" name=\"true\" url=\"true\"></find>\n<option extract=\"true\"/>\n<localFile>bookmarks.xml</localFile>\n</jboom>\n".getBytes("UTF-8"));
        return true;
    }

    abstract Jbutils.Check install();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Jbutils.Check result() {
        this.result = Jbutils.Check.OK;
        try {
            this.result = this.install();
        }
        catch (Exception exception) {
            Jbutils.showException(exception);
            this.result = Jbutils.Check.ERR;
        }
        finally {
            this.removeDialog();
        }
        if (this.isCancelled()) {
            this.result = Jbutils.Check.ERR;
        }
        return this.result;
    }
}

