/*
 * Decompiled with CFR 0.152.
 */
package org.sourceforge.jbinstall;

import de.monoped.efile.EFile;
import de.monoped.efile.FtpFile;
import de.monoped.efile.SshFile;
import de.monoped.wizard.Wizard;
import java.io.File;
import org.sourceforge.jbinstall.Data;
import org.sourceforge.jbinstall.Jbinstall;
import org.sourceforge.jbinstall.Jbutils;
import org.sourceforge.jbinstall.RemoteInstaller;

class RemoteAppletInstaller
extends RemoteInstaller {
    private Wizard<Data> wizard;
    private EFile target;

    RemoteAppletInstaller(Wizard<Data> wizard) {
        super(wizard);
        this.wizard = wizard;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Jbutils.Check install() {
        try {
            this.target = this.data.protocol == Data.Protocol.FTP ? new FtpFile(this.data.host, this.data.user, this.data.password, this.data.installDir) : (this.data.auth == Data.Auth.PASSWD ? new SshFile(this.data.host, this.data.user, this.data.password, this.data.installDir) : new SshFile(this.data.host, this.data.user, new File(this.data.key), this.data.installDir));
            if (!Jbutils.checkTargetDirectory(this.target)) {
                Jbutils.Check check = Jbutils.Check.ERR;
                return check;
            }
            this.label2.setText(this.data.html1);
            this.target.addPath(this.data.html1);
            if (this.data.javascript) {
                this.target.putBytes(Jbutils.createHtml1(this.data.html2).getBytes("UTF-8"));
                if (this.isCancelled()) {
                    Jbutils.Check check = Jbutils.Check.ERR;
                    return check;
                }
                this.label2.setText(this.data.html2);
                this.target.setName(this.data.html2);
                this.target.putBytes(Jbutils.createHtml2(this.data).getBytes("UTF-8"));
            } else {
                this.target.putBytes(Jbutils.resourceToBytes("html/jboombrw.html"));
            }
            this.wizard.getData().call = this.wizard.getData().dirURL + "/" + this.data.html1;
            if (this.isCancelled()) {
                Jbutils.Check check = Jbutils.Check.ERR;
                return check;
            }
            Jbutils.Check check = Jbutils.checkDirURL(this.data, this.data.html1);
            if (check == Jbutils.Check.ERR) {
                Jbutils.Check check2 = check;
                return check2;
            }
            this.label2.setText("jboom.jar");
            this.target.setName("jboom.jar");
            this.target.copyFrom(this.getClass().getClassLoader().getResourceAsStream("bin/jboom.jar"));
            if (this.isCancelled()) {
                Jbutils.Check check3 = Jbutils.Check.ERR;
                return check3;
            }
            if (this.data.config == Data.Config.REMOTE) {
                this.target.setPath(this.data.confPath);
                this.installConfig(this.target);
            }
        }
        catch (Exception exception) {
            if (Jbinstall.isDebug()) {
                exception.printStackTrace();
            }
            Jbutils.showException(exception);
            Jbutils.Check check = Jbutils.Check.ERR;
            return check;
        }
        finally {
            try {
                if (this.target != null) {
                    this.target.close();
                }
            }
            catch (Exception exception) {}
            this.removeDialog();
        }
        return Jbutils.Check.OK;
    }
}

