/*
 * Decompiled with CFR 0.152.
 */
package org.sourceforge.jbinstall;

import de.monoped.efile.EFile;
import de.monoped.utils.Resource;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import javax.swing.AbstractButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.sourceforge.jbinstall.Data;
import org.sourceforge.jbinstall.Jbinstall;

public class Jbutils {
    static Resource resource = new Resource("org.sourceforge.jbinstall.Resources");
    static final String MARK = "~";

    public static String absolutePath(String string) {
        if (new File(string).isAbsolute()) {
            return string;
        }
        return new File(System.getProperty("user.home"), string).getAbsolutePath();
    }

    public static Check checkDirURL(Data data, String string) {
        Check check = Check.OK;
        try {
            URLConnection uRLConnection = new URL(data.dirURL + "/" + string).openConnection();
            if (System.getProperty("java.specification.version").charAt(2) > '4') {
                uRLConnection.setConnectTimeout(5000);
            }
            uRLConnection.getContent();
        }
        catch (IOException iOException) {
            if (Jbinstall.isDebug()) {
                iOException.printStackTrace();
            }
            JTextArea jTextArea = new JTextArea(Jbutils.getString("urlerror", string));
            jTextArea.setEditable(false);
            check = JOptionPane.showConfirmDialog(null, jTextArea, Jbutils.getString("warning"), 0, 2) == 0 ? Check.WARN : Check.ERR;
        }
        return check;
    }

    public static boolean checkTargetDirectory(EFile eFile) throws IOException {
        if (eFile.isDirectory()) {
            return true;
        }
        int n = JOptionPane.showConfirmDialog(null, Jbutils.getString("noDir", eFile.getPath()), Jbutils.getString("confirm"), 0, 3);
        if (n != 0) {
            return false;
        }
        return eFile.mkdirs();
    }

    public static boolean checkTargetFile(EFile eFile) throws IOException {
        int n;
        if (eFile.exists()) {
            int n2 = JOptionPane.showConfirmDialog(null, Jbutils.getString("fileExists", eFile.getPath()), Jbutils.getString("confirm"), 0, 3);
            return n2 == 0;
        }
        String string = eFile.getName();
        eFile.addPath("..");
        if (!eFile.exists() && (n = JOptionPane.showConfirmDialog(null, Jbutils.getString("noDir", eFile.getPath()), Jbutils.getString("confirm"), 0, 3)) != 0) {
            return false;
        }
        if (eFile.mkdirs()) {
            eFile.addPath(string);
            return true;
        }
        return false;
    }

    public static void copyFile(InputStream inputStream, File file) throws IOException {
        int n;
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        byte[] byArray = new byte[2048];
        while ((n = inputStream.read(byArray)) >= 0) {
            fileOutputStream.write(byArray, 0, n);
        }
        inputStream.close();
        fileOutputStream.close();
    }

    public static void copyJar(OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[2048];
        InputStream inputStream = Jbutils.class.getClassLoader().getResourceAsStream("bin/jboom.jar");
        while ((n = inputStream.read(byArray)) >= 0) {
            outputStream.write(byArray, 0, n);
        }
        inputStream.close();
        outputStream.close();
    }

    public static String createHtml1(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">\n").append("<HTML><HEAD><SCRIPT type=\"text/javascript\">").append("neu=window.open('").append(string).append("','_blank','menubar=no,toolbar=no,resizable=no,width=345,height=440');").append("history.back();neu.focus();").append("</SCRIPT></HEAD><BODY></BODY></HTML>\n");
        return stringBuilder.toString();
    }

    public static String createHtml2(Data data) {
        StringBuilder stringBuilder = new StringBuilder();
        Data.Config config = data.config;
        stringBuilder.append("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">\n").append("<HTML><HEAD><TITLE>Bookmarks</TITLE></HEAD>\n").append("<BODY>\n").append("<APPLET code=\"org.sourceforge.jboom.JBoomApplet.class\" archive=\"jboom.jar\"").append(" width=\"330\" height=\"420\" >");
        if (config == Data.Config.NO) {
            stringBuilder.append("<param name=\"config\" value=\"-\">");
        } else if (config == Data.Config.REMOTE) {
            stringBuilder.append("<param name=\"config\" value=\"").append(data.protocol == Data.Protocol.FTP ? "ftp" : "ssh").append("://").append(data.confUser).append(":").append(data.confPassword).append("@").append(data.confHost).append("/").append(data.confPath).append("\">");
        } else if (config == Data.Config.LOCAL) {
            stringBuilder.append("<param name=\"config\" value=\"").append(data.confPath).append("\">");
        }
        stringBuilder.append("\n</APPLET>\n</BODY>\n</HTML>\n");
        return stringBuilder.toString();
    }

    public static String getString(String string) {
        return resource.getString(string);
    }

    public static String getString(String string, String string2) {
        return resource.getString(string, string2);
    }

    public static AbstractButton nameButton(AbstractButton abstractButton, String string) {
        return resource.nameButton(abstractButton, string);
    }

    public static JLabel createLabel(String string) {
        return resource.createLabel(string);
    }

    public static JLabel createLabel(String string, JTextField jTextField) {
        return resource.createLabel(string, jTextField);
    }

    public static byte[] resourceToBytes(String string) throws IOException {
        int n;
        byte[] byArray = new byte[2048];
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        InputStream inputStream = Jbutils.class.getClassLoader().getResourceAsStream(string);
        if (inputStream == null) {
            throw new IOException("Resource " + string + " not found");
        }
        while ((n = inputStream.read(byArray)) >= 0) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        inputStream.close();
        byteArrayOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    public static void showException(final Exception exception) {
        if (Jbinstall.isDebug()) {
            exception.printStackTrace();
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                JOptionPane.showMessageDialog(null, "<html><font color=\"red\">" + exception + "</font><p><p>" + Jbutils.getString("changeParm"), Jbutils.getString("error"), 0);
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    static enum Check {
        OK,
        ERR,
        WARN;

    }
}

