/*
 * Decompiled with CFR 0.152.
 */
package org.sourceforge.jbinstall;

import de.monoped.efile.EFile;
import de.monoped.efile.LocalFile;
import de.monoped.wizard.Wizard;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.sourceforge.jbinstall.Data;
import org.sourceforge.jbinstall.Jbutils;
import org.sourceforge.jbinstall.RemoteAppletInstaller;
import org.sourceforge.jbinstall.RemoteProgramInstaller;
import org.sourceforge.jbinstall.page.LocalApplet;
import org.sourceforge.jbinstall.page.LocalConfig;
import org.sourceforge.jbinstall.page.LocalProgram;
import org.sourceforge.jbinstall.page.RemoteApplet;
import org.sourceforge.jbinstall.page.RemoteAppletPaths;
import org.sourceforge.jbinstall.page.RemoteConfig;
import org.sourceforge.jbinstall.page.RemoteConfigRemote;
import org.sourceforge.jbinstall.page.RemoteConfigSimple;
import org.sourceforge.jbinstall.page.RemoteProgram;
import org.sourceforge.jbinstall.page.RemoteProgramPaths;
import org.sourceforge.jbinstall.page.Start;

class JbinstallWizard
extends Wizard<Data> {
    private String modus;
    private String location;
    private String jarPath;
    private File jarFile;

    JbinstallWizard() {
        super(Jbutils.getString("installer"), "help", new Data(), Wizard.FinishMode.VISITED);
        this.setInfo("jBoom-Installer 2.0");
        this.setBounds(100, 100, 600, 300);
        this.addPage(new Start());
        this.addPage(new RemoteProgram());
        this.addPage(new RemoteProgramPaths());
        this.addPage(new RemoteConfig());
        this.addPage(new RemoteConfigSimple());
        this.addPage(new RemoteConfigRemote());
        this.addPage(new RemoteApplet());
        this.addPage(new RemoteAppletPaths());
        this.addPage(new LocalProgram());
        this.addPage(new LocalConfig());
        this.addPage(new LocalApplet());
    }

    private boolean installJarLocal() {
        try {
            if (!Jbutils.checkTargetDirectory(new LocalFile(((Data)this.data).installDir))) {
                return false;
            }
            if (((Data)this.data).config == Data.Config.LOCAL) {
                try {
                    LocalFile localFile = new LocalFile(((Data)this.data).confPath);
                    if (!Jbutils.checkTargetFile(localFile)) {
                        return false;
                    }
                    localFile.putBytes("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<jboom>\n<connections></connections>\n<sort recursive=\"true\" folderFirst=\"true\"/>\n<find case=\"false\" name=\"true\" url=\"true\"></find>\n<option extract=\"true\"/>\n<localFile>bookmarks.xml</localFile>\n</jboom>\n".getBytes());
                }
                catch (IOException iOException) {
                    Jbutils.showException(iOException);
                    return false;
                }
            }
            Jbutils.copyJar(new FileOutputStream(this.jarFile));
        }
        catch (IOException iOException) {
            Jbutils.showException(iOException);
            return false;
        }
        return true;
    }

    private Jbutils.Check installProgramLocal() {
        Data data = (Data)this.getData();
        if (!this.installJarLocal()) {
            return Jbutils.Check.ERR;
        }
        data.call = "java -jar \"" + this.jarPath + "\"";
        if (data.config == Data.Config.LOCAL) {
            data.call = data.call + " -c \"" + data.confPath + "\"";
        } else if (data.config == Data.Config.NO) {
            data.call = data.call + " -c -";
        }
        return Jbutils.Check.OK;
    }

    private Jbutils.Check installProgramRemote() {
        RemoteProgramInstaller remoteProgramInstaller = new RemoteProgramInstaller(this);
        return (Jbutils.Check)((Object)remoteProgramInstaller.start());
    }

    private Jbutils.Check installAppletLocal() {
        if (!this.installJarLocal()) {
            return Jbutils.Check.ERR;
        }
        try {
            Object object;
            if (((Data)this.data).config == Data.Config.LOCAL) {
                if (!Jbutils.checkTargetDirectory(new LocalFile(((Data)this.data).installDir))) {
                    return Jbutils.Check.ERR;
                }
                object = new LocalFile(((Data)this.data).confPath);
                if (Jbutils.checkTargetFile((EFile)object)) {
                    object.putBytes("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<jboom>\n<connections></connections>\n<sort recursive=\"true\" folderFirst=\"true\"/>\n<find case=\"false\" name=\"true\" url=\"true\"></find>\n<option extract=\"true\"/>\n<localFile>bookmarks.xml</localFile>\n</jboom>\n".getBytes());
                } else {
                    return Jbutils.Check.ERR;
                }
            }
            object = new File(((Data)this.data).installDir, ((Data)this.data).html1);
            File file = new File(((Data)this.data).installDir, ((Data)this.data).html2);
            if (((Data)this.data).javascript) {
                FileWriter fileWriter = new FileWriter((File)object);
                fileWriter.write(Jbutils.createHtml1(((Data)this.data).html2));
                fileWriter.close();
                fileWriter = new FileWriter(file);
                fileWriter.write(Jbutils.createHtml2((Data)this.data));
                fileWriter.close();
            } else {
                Jbutils.copyFile(Jbutils.class.getClassLoader().getResourceAsStream("html/jboombrw.html"), (File)object);
            }
        }
        catch (IOException iOException) {
            Jbutils.showException(iOException);
            return Jbutils.Check.ERR;
        }
        ((Data)this.getData()).call = "file://" + ((Data)this.data).installDir + "/" + ((Data)this.data).html1;
        return Jbutils.Check.OK;
    }

    private Jbutils.Check installAppletRemote() {
        RemoteAppletInstaller remoteAppletInstaller = new RemoteAppletInstaller(this);
        return (Jbutils.Check)((Object)remoteAppletInstaller.start());
    }

    @Override
    public boolean finish() {
        Jbutils.Check check;
        this.jarFile = new File(((Data)this.data).installDir, "jboom.jar");
        this.jarPath = this.jarFile.getAbsolutePath();
        if (((Data)this.data).location == Data.Location.REMOTE) {
            check = ((Data)this.data).modus == Data.Modus.PROGRAM ? this.installProgramRemote() : this.installAppletRemote();
        } else {
            Jbutils.Check check2 = check = ((Data)this.data).modus == Data.Modus.PROGRAM ? this.installProgramLocal() : this.installAppletLocal();
        }
        if (check == Jbutils.Check.ERR) {
            return false;
        }
        String string = "<html><p><font color=\"blue\">";
        String string2 = check == Jbutils.Check.OK ? Jbutils.getString("success1") : Jbutils.getString("success1w");
        BorderLayout borderLayout = new BorderLayout();
        JPanel jPanel = new JPanel(borderLayout);
        borderLayout.setVgap(20);
        JTextField jTextField = new JTextField();
        jTextField.setHorizontalAlignment(0);
        if (((Data)this.data).modus == Data.Modus.PROGRAM) {
            string2 = string2 + "\n" + Jbutils.getString("success2prog");
            jPanel.add((Component)new JLabel(string + "<p>" + Jbutils.getString("success2prog")), "North");
            jTextField.setText(((Data)this.data).call);
            jTextField.setEditable(false);
            jPanel.add(jTextField);
            if (((Data)this.data).location == Data.Location.LOCAL) {
                jPanel.add((Component)new JLabel(Jbutils.getString("succProgBot")), "South");
            }
        } else {
            string2 = string2 + "\n" + Jbutils.getString("success2appl");
            jPanel.add((Component)new JLabel(string + "<p>" + Jbutils.getString("success2appl")), "North");
            jTextField.setText(((Data)this.data).call);
            jTextField.setEditable(false);
            jPanel.add(jTextField);
            jPanel.add((Component)new JLabel(Jbutils.getString("succApplBot")), "South");
        }
        try {
            FileWriter fileWriter = new FileWriter(new File(System.getProperty("user.home"), "jbinstall.txt"));
            fileWriter.write(string2);
            fileWriter.write("\n\n");
            fileWriter.write(((Data)this.data).call);
            fileWriter.write(10);
            fileWriter.close();
        }
        catch (IOException iOException) {
            Jbutils.showException(iOException);
        }
        JOptionPane.showMessageDialog(this, jPanel);
        return true;
    }
}

