/*
 * Decompiled with CFR 0.152.
 */
package de.monoped.wizard;

import de.monoped.utils.Resource;
import de.monoped.wizard.Icons;
import de.monoped.wizard.Page;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.text.html.HTMLEditorKit;

public abstract class Wizard<T>
extends JDialog
implements ActionListener {
    private static final String CANCEL_CMD = "cancel";
    private static final String BACK_CMD = "back";
    private static final String FINISH_CMD = "finish";
    private static final String NEXT_CMD = "next";
    private static final String HELP_CMD = "help";
    private boolean debug;
    private FinishMode finishMode;
    protected Resource resource;
    private JLabel infoLabel;
    private HashMap<String, Page<T>> pageMap;
    private HashMap<String, Object> properties;
    private ArrayList<Page<T>> pageStack;
    private Page<T> page;
    private Page<T> startPage;
    private JComponent south;
    private Container content;
    private JButton backButton;
    private JButton finishButton;
    private JButton nextButton;
    private JButton helpButton;
    private JButton cancelButton;
    private JDialog helpDialog;
    private JEditorPane helpPane;
    private JScrollPane helpScroll;
    private URL helpURL;
    private String helpBase;
    private boolean success;
    private ClassLoader loader;
    protected T data;

    public Wizard(String string, String string2, T t, FinishMode finishMode) {
        this.data = t;
        this.finishMode = finishMode;
        this.setTitle(string);
        this.setModal(true);
        this.setDefaultCloseOperation(2);
        this.loader = this.getClass().getClassLoader();
        this.pageMap = new HashMap();
        this.properties = new HashMap();
        this.pageStack = new ArrayList();
        this.content = this.getContentPane();
        this.content.setLayout(new BorderLayout());
        this.resource = new Resource("de.monoped.wizard.Resources");
        this.content.add((Component)this.createTopPanel(), "North");
        this.south = this.createButtonPanel();
        this.content.add((Component)this.south, "South");
        if (string2 != null) {
            String string3 = Locale.getDefault().getLanguage();
            this.helpBase = string2 + "/" + string3 + "/";
            if (this.loader.getResource(this.helpBase) == null) {
                this.helpBase = string2 + "/en/";
                if (this.loader.getResource(this.helpBase) == null) {
                    this.helpBase = null;
                }
            }
        }
    }

    public Wizard(String string, String string2, T t) {
        this(string, string2, t, FinishMode.DEFAULT);
    }

    public Wizard(String string, String string2) {
        this(string, string2, null, FinishMode.DEFAULT);
    }

    public Wizard addPage(Page<T> page) {
        this.pageMap.put(page.getClass().getName(), page);
        if (this.startPage == null) {
            this.startPage = page;
        }
        page.setWizard(this);
        return this;
    }

    public void checkStatus() {
        if (this.debug) {
            System.out.println(this.page.getName() + "  last=" + (this.page.getNext() == null) + "  complete=" + this.page.isPageComplete());
        }
        this.setLast(this.page.getNext() == null);
        this.setPageComplete(this.page.isPageComplete());
    }

    private JComponent createButtonPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.backButton = new JButton(Icons.BACK);
        this.resource.nameButton(this.backButton, BACK_CMD);
        this.backButton.setEnabled(false);
        this.backButton.setActionCommand(BACK_CMD);
        this.backButton.addActionListener(this);
        this.nextButton = new JButton(Icons.NEXT);
        this.resource.nameButton(this.nextButton, NEXT_CMD);
        this.nextButton.setActionCommand(NEXT_CMD);
        this.nextButton.addActionListener(this);
        this.nextButton.setEnabled(false);
        this.finishButton = new JButton();
        this.finishButton.addActionListener(this);
        this.finishButton.setEnabled(false);
        if (this.finishMode != FinishMode.ATEND) {
            this.finishButton.setIcon(Icons.FINISH);
            this.resource.nameButton(this.finishButton, FINISH_CMD);
            this.finishButton.setActionCommand(FINISH_CMD);
        }
        this.helpPane = new JEditorPane();
        this.helpPane.setEditorKit(new HTMLEditorKit());
        this.helpPane.setEditable(false);
        this.helpScroll = new JScrollPane(this.helpPane);
        this.helpPane.setPreferredSize(new Dimension(500, 400));
        this.cancelButton = new JButton(Icons.CANCEL);
        this.resource.nameButton(this.cancelButton, CANCEL_CMD);
        this.cancelButton.setActionCommand(CANCEL_CMD);
        this.cancelButton.addActionListener(this);
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 0;
        jPanel.add((Component)this.backButton, gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.weightx = 0.0;
        jPanel.add((Component)this.cancelButton, gridBagConstraints);
        if (this.finishMode != FinishMode.ATEND) {
            ++gridBagConstraints.gridx;
            gridBagConstraints.weightx = 0.0;
            jPanel.add((Component)this.finishButton, gridBagConstraints);
        }
        ++gridBagConstraints.gridx;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 13;
        jPanel.add((Component)this.nextButton, gridBagConstraints);
        return jPanel;
    }

    private JComponent createTopPanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.infoLabel = new JLabel();
        this.infoLabel.setFont(this.infoLabel.getFont().deriveFont(0, 10.0f));
        this.helpButton = new JButton(Icons.HELP);
        this.helpButton.setMargin(new Insets(0, 0, 0, 0));
        this.helpButton.setActionCommand(HELP_CMD);
        this.helpButton.addActionListener(this);
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 0;
        jPanel.add((Component)this.infoLabel, gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.anchor = 13;
        jPanel.add((Component)this.helpButton, gridBagConstraints);
        return jPanel;
    }

    public abstract boolean finish();

    public void finishWizard() {
        if (!this.page.exit()) {
            return;
        }
        if (this.finish()) {
            this.setVisible(false);
            System.exit(0);
        }
    }

    public T getData() {
        return this.data;
    }

    public FinishMode getFinishMode() {
        return this.finishMode;
    }

    public HashMap getProperties() {
        return this.properties;
    }

    public Object getProperty(String string) {
        return this.properties.get(string);
    }

    public boolean isDebug() {
        return this.debug;
    }

    private boolean isWizardComplete() {
        if (this.page == null) {
            return false;
        }
        Page<T> page = this.page;
        if (this.finishMode == FinishMode.ATEND) {
            return page.getNext() == null;
        }
        while (page != null) {
            if ((this.finishMode == FinishMode.DEFAULT || this.finishMode == FinishMode.VISITED && page.isVisited()) && page.isPageComplete()) {
                page = this.pageMap.get(page.getNext());
                continue;
            }
            return false;
        }
        return true;
    }

    public boolean isSuccess() {
        return this.success;
    }

    private void nextPage() {
        if (!this.page.exit()) {
            return;
        }
        this.pageStack.add(this.page);
        String string = this.page.getNext();
        this.setPage(this.pageMap.get(string));
        this.backButton.setEnabled(true);
    }

    private void previousPage() {
        if (!this.page.exit()) {
            return;
        }
        Page<T> page = this.pageStack.get(this.pageStack.size() - 1);
        this.pageStack.remove(page);
        this.setPage(page);
        if (this.finishMode == FinishMode.ATEND && this.page.getNext() != null) {
            this.setNextFinish(false);
        }
        this.backButton.setEnabled(this.pageStack.size() > 0);
    }

    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    public void setInfo(String string) {
        this.infoLabel.setText(string);
    }

    private void setLast(boolean bl) {
        if (bl) {
            if (this.finishMode == FinishMode.ATEND) {
                this.setNextFinish(true);
                this.nextButton.setEnabled(this.page.isPageComplete());
            } else {
                this.finishButton.setEnabled(this.page.isPageComplete());
                this.nextButton.setEnabled(false);
            }
        } else {
            if (this.finishMode == FinishMode.ATEND) {
                this.setNextFinish(false);
            } else {
                this.finishButton.setEnabled(false);
            }
            this.nextButton.setEnabled(this.page.isPageComplete());
        }
    }

    private void setNextFinish(boolean bl) {
        if (bl) {
            this.nextButton.setIcon(Icons.FINISH);
            this.resource.nameButton(this.nextButton, FINISH_CMD);
            this.nextButton.setActionCommand(FINISH_CMD);
        } else {
            this.nextButton.setIcon(Icons.NEXT);
            this.resource.nameButton(this.nextButton, NEXT_CMD);
            this.nextButton.setActionCommand(NEXT_CMD);
        }
    }

    private void setPage(Page<T> page) {
        if (this.debug) {
            System.out.println("Page: " + page.getClass().getName());
        }
        if (this.helpDialog != null) {
            this.helpDialog.setVisible(false);
            this.helpDialog.dispose();
            this.helpDialog = null;
        }
        if (this.page != null) {
            this.content.remove(this.page);
        }
        this.page = page;
        page.setVisited(true);
        this.nextButton.setEnabled(false);
        if (this.finishButton != null) {
            this.finishButton.setEnabled(false);
        }
        page.start();
        this.checkStatus();
        if (this.isWizardComplete() && this.finishButton != null) {
            this.finishButton.setEnabled(true);
        }
        this.content.add(page);
        if (this.helpBase != null) {
            String string = this.helpBase + page.getHelpName();
            this.helpURL = this.loader.getResource(string);
            this.helpButton.setVisible(this.helpURL != null);
        }
        this.content.validate();
        this.content.repaint();
    }

    private void setPageComplete(boolean bl) {
        if (this.page.getNext() != null) {
            this.nextButton.setEnabled(bl);
            this.finishButton.setEnabled(this.isWizardComplete());
        } else if (this.finishMode == FinishMode.ATEND) {
            this.nextButton.setEnabled(this.isWizardComplete());
        } else {
            this.nextButton.setEnabled(false);
            this.finishButton.setEnabled(bl);
        }
    }

    public void setProperties(HashMap<String, Object> hashMap) {
        this.properties = hashMap;
    }

    public void setProperty(String string, Object object) {
        this.properties.put(string, object);
    }

    public void setStartPage(Page<T> page) {
        this.startPage = page;
    }

    private void showHelp() {
        if (this.helpDialog != null && this.helpDialog.isVisible()) {
            this.helpDialog.setVisible(false);
            this.helpDialog.dispose();
            this.helpDialog = null;
            return;
        }
        JOptionPane jOptionPane = new JOptionPane(this.helpScroll, -1);
        try {
            this.helpPane.setPage(this.helpURL);
        }
        catch (Exception exception) {
            if (this.debug) {
                exception.printStackTrace();
            }
            this.helpPane.setText(this.resource.getString("helpError") + "\n" + exception);
        }
        this.helpDialog = jOptionPane.createDialog(this, this.resource.getString("helphead"));
        this.helpDialog.setModal(false);
        this.helpDialog.setVisible(true);
    }

    public void start() {
        if (this.startPage != null) {
            this.setPage(this.startPage);
        }
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(CANCEL_CMD)) {
            this.dispose();
        } else if (string.equals(NEXT_CMD)) {
            this.nextPage();
        } else if (string.equals(BACK_CMD)) {
            this.previousPage();
        } else if (string.equals(HELP_CMD)) {
            this.showHelp();
        } else if (string.equals(FINISH_CMD)) {
            this.finishWizard();
        }
    }

    public static enum FinishMode {
        DEFAULT,
        VISITED,
        ATEND;

    }
}

