/*
 * Decompiled with CFR 0.152.
 */
package de.monoped.swing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class Utilities {
    public static Rectangle centerComponent(Component component, int n, int n2) {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n3 = 0;
        int n4 = 0;
        int n5 = dimension.width;
        int n6 = dimension.height;
        if (component != null) {
            Point point = component.getLocationOnScreen();
            Dimension dimension2 = component.getSize();
            if (dimension2.width >= n && dimension2.height >= n2) {
                n3 = point.x;
                n4 = point.y;
                n5 = dimension2.width;
                n6 = dimension2.height;
            }
        }
        return new Rectangle(n3 + (n5 - n) / 2, n4 + (n6 - n2) / 2, n, n2);
    }

    public static boolean treePathsAreBrothers(TreePath[] treePathArray) {
        if (treePathArray == null) {
            return true;
        }
        if (treePathArray.length < 2) {
            return true;
        }
        Object[] objectArray = treePathArray[0].getPath();
        int n = objectArray.length;
        for (int i = 1; i < treePathArray.length; ++i) {
            TreePath treePath = treePathArray[i];
            Object[] objectArray2 = treePath.getPath();
            if (objectArray2.length != n) {
                return false;
            }
            for (int j = 0; j < n - 1; ++j) {
                if (objectArray2[j] == objectArray[j]) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean treePathsSameParent(TreePath[] treePathArray) {
        if (treePathArray == null) {
            return true;
        }
        if (treePathArray.length < 2) {
            return true;
        }
        Object[] objectArray = treePathArray[0].getPath();
        TreeNode treeNode = (TreeNode)treePathArray[0].getLastPathComponent();
        int n = objectArray.length;
        if (treeNode.isLeaf()) {
            --n;
        }
        for (int i = 1; i < treePathArray.length; ++i) {
            Object[] objectArray2 = treePathArray[i].getPath();
            TreeNode treeNode2 = (TreeNode)treePathArray[i].getLastPathComponent();
            if (!treeNode2.isLeaf()) {
                return false;
            }
            if (objectArray2.length != n + 1) {
                return false;
            }
            for (int j = 0; j < n; ++j) {
                if (objectArray2[j] == objectArray[j]) continue;
                return false;
            }
        }
        return true;
    }
}

