/*
 * Decompiled with CFR 0.152.
 */
package de.monoped.swing;

import de.monoped.swing.Utilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public abstract class RunWait<T>
implements Callable<T> {
    protected WaitDialog dialog;
    private boolean cancelled;
    private static int DEF_WIDTH = 400;
    private static int DEF_HEIGHT = 150;
    private int dialogWidth;
    private int dialogHeight;
    private Component parent;
    private String title;
    private String cancelText;
    private String errorMsg;
    private JComponent component;
    private FutureTask<T> task;

    public RunWait(Component component, JComponent jComponent, String string, String string2) {
        this.parent = component;
        this.component = jComponent;
        this.title = string;
        this.cancelText = string2;
        this.dialogWidth = DEF_WIDTH;
        this.dialogHeight = DEF_HEIGHT;
    }

    public RunWait(Component component, String string, String string2, String string3) {
        this(component, new JLabel(string, 0), string2, string3);
    }

    public RunWait(Component component, String string, String string2) {
        this(component, new JLabel("Please wait..."), string, string2);
    }

    @Override
    public T call() {
        T t;
        try {
            t = this.result();
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(null, exception.toString(), "Error", 0);
            t = null;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                RunWait.this.removeDialog();
            }
        });
        return t;
    }

    public void cancel() {
        this.task.cancel(true);
    }

    public void cancel(String string) {
        this.errorMsg = string;
        this.task.cancel(true);
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }

    public boolean isCancelled() {
        return this.task.isCancelled();
    }

    public void removeDialog() {
        if (this.dialog == null) {
            return;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            this.dialog.setVisible(false);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    RunWait.this.dialog.setVisible(false);
                    RunWait.this.dialog.dispose();
                }
            });
        }
    }

    public abstract T result() throws Exception;

    public static void setDefaultSize(int n, int n2) {
        DEF_WIDTH = n;
        DEF_HEIGHT = n2;
    }

    public void setDialogSize(int n, int n2) {
        this.dialogWidth = n;
        this.dialogHeight = n2;
    }

    public void setComponent(JComponent jComponent) {
        this.component = jComponent;
    }

    public T start() {
        this.dialog = new WaitDialog(this.parent, this.component, this.title, this.cancelText);
        this.dialog.setSize(this.dialogWidth, this.dialogHeight);
        ExecutorService executorService = Executors.newFixedThreadPool(1);
        this.task = new FutureTask(this);
        executorService.execute(this.task);
        this.dialog.setVisible(true);
        try {
            return this.task.get();
        }
        catch (Exception exception) {
            return null;
        }
    }

    class WaitDialog
    extends JDialog
    implements ActionListener {
        private JButton cancelButton;

        WaitDialog(Component component, JComponent jComponent, String string, String string2) {
            this.setModal(true);
            this.setBounds(Utilities.centerComponent(component, RunWait.this.dialogWidth, RunWait.this.dialogHeight));
            this.setTitle(string);
            this.setDefaultCloseOperation(0);
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BorderLayout());
            jPanel.add(jComponent);
            this.cancelButton = new JButton(string2);
            this.cancelButton.addActionListener(this);
            JPanel jPanel2 = new JPanel();
            jPanel2.add(this.cancelButton);
            jPanel.add((Component)jPanel2, "South");
            this.setContentPane(jPanel);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == this.cancelButton) {
                RunWait.this.task.cancel(true);
                RunWait.this.removeDialog();
            }
        }
    }
}

