/*
 * Decompiled with CFR 0.152.
 */
package de.monoped.efile;

import com.trilead.ssh2.Connection;
import com.trilead.ssh2.SFTPv3Client;
import com.trilead.ssh2.SFTPv3DirectoryEntry;
import com.trilead.ssh2.SFTPv3FileAttributes;
import com.trilead.ssh2.SFTPv3FileHandle;
import de.monoped.efile.EFile;
import de.monoped.efile.Path;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Vector;

public class SshFile
implements EFile {
    private SFTPv3Client client;
    private Connection connection;
    private Path curpath;
    String user;
    String server;

    public SshFile(String string, String string2, String string3) throws IOException {
        this.server = string;
        this.user = string2;
        this.curpath = new Path(string3);
    }

    public SshFile(String string, String string2, String string3, String string4) throws IOException {
        this(string, string2, string4);
        this.connection = new Connection(string);
        this.connection.connect();
        if (!this.connection.authenticateWithPassword(string2, string3)) {
            throw new IOException("Authentication error");
        }
        this.client = new SFTPv3Client(this.connection);
    }

    public SshFile(String string, String string2, File file, String string3) throws IOException {
        this(string, string2, string3);
        this.connection = new Connection(string);
        this.connection.connect();
        if (!this.connection.authenticateWithPublicKey(string2, file, null)) {
            throw new IOException("Authentication error");
        }
        this.client = new SFTPv3Client(this.connection);
    }

    @Override
    public void addPath(String string) throws IOException {
        this.curpath.addPath(string);
    }

    @Override
    public void close() {
        this.client.close();
        this.connection.close();
    }

    @Override
    public void copyFrom(File file) throws IOException, FileNotFoundException {
        this.copyFrom(new FileInputStream(file));
    }

    @Override
    public void copyFrom(InputStream inputStream) throws IOException, FileNotFoundException {
        int n;
        OutputStream outputStream = this.getOutputStream();
        byte[] byArray = new byte[4096];
        while ((n = inputStream.read(byArray)) >= 0) {
            outputStream.write(byArray, 0, n);
        }
        inputStream.close();
        outputStream.close();
    }

    @Override
    public void delete() throws IOException {
        if (this.curpath.getPath().equals("/")) {
            return;
        }
        SFTPv3FileAttributes sFTPv3FileAttributes = this.client.stat(this.curpath.getPath());
        if (sFTPv3FileAttributes == null) {
            return;
        }
        if (sFTPv3FileAttributes.isDirectory()) {
            this.client.rmdir(this.curpath.getPath());
        } else {
            this.client.rm(this.curpath.getPath());
        }
    }

    @Override
    public void delete(boolean bl) throws IOException {
        if (!bl || !this.isDirectory()) {
            this.delete();
        } else {
            this.deleteDir(this.curpath.getPath());
        }
    }

    @Override
    public boolean exists() {
        try {
            this.client.stat(this.curpath.getPath());
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    @Override
    public String getBase() {
        return "ssh://" + this.user + "@" + this.server;
    }

    @Override
    public byte[] getBytes() throws IOException, FileNotFoundException {
        int n;
        InputStream inputStream = this.getInputStream();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[2048];
        while ((n = inputStream.read(byArray)) >= 0) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        inputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    @Override
    public InputStream getInputStream() throws IOException, FileNotFoundException {
        SFTPv3FileHandle sFTPv3FileHandle = this.client.openFileRO(this.curpath.getPath());
        return new SshInputStream(sFTPv3FileHandle);
    }

    @Override
    public String getName() {
        return this.curpath.getName();
    }

    @Override
    public OutputStream getOutputStream() throws IOException, FileNotFoundException {
        SFTPv3FileHandle sFTPv3FileHandle = this.client.createFileTruncate(this.curpath.getPath());
        return new SshOutputStream(sFTPv3FileHandle);
    }

    @Override
    public String getPath() {
        return this.curpath.getPath();
    }

    @Override
    public boolean isDirectory() {
        try {
            return this.client.stat(this.curpath.getPath()).isDirectory();
        }
        catch (IOException iOException) {
            return false;
        }
    }

    @Override
    public Iterator iterator() throws IOException {
        return new SshFileIterator(this.list());
    }

    @Override
    public Iterator iterator(FilenameFilter filenameFilter) throws IOException {
        return new SshFileIterator(this.list(filenameFilter));
    }

    @Override
    public String[] list() throws IOException {
        return this.list(this.curpath.getPath());
    }

    @Override
    public String[] list(FilenameFilter filenameFilter) throws IOException {
        Vector vector = this.client.ls(this.curpath.getPath());
        if (vector != null) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (SFTPv3DirectoryEntry sFTPv3DirectoryEntry : vector) {
                if (!filenameFilter.accept(null, sFTPv3DirectoryEntry.filename)) continue;
                arrayList.add(sFTPv3DirectoryEntry.filename);
            }
            return arrayList.toArray(new String[0]);
        }
        return null;
    }

    @Override
    public boolean mkdirs() throws IOException {
        String[] stringArray = this.curpath.getPath().split("/");
        String string = "/";
        for (int i = 0; i < stringArray.length; ++i) {
            String string2;
            String string3 = stringArray[i];
            if (string3.length() <= 0) continue;
            String[] stringArray2 = this.list(string);
            boolean bl = false;
            for (int j = 0; j < stringArray2.length; ++j) {
                String string4 = stringArray2[j];
                if (!string4.equals(string3)) continue;
                bl = true;
                break;
            }
            String string5 = string2 = string.endsWith("/") ? string + string3 : string + "/" + string3;
            if (!bl) {
                this.client.mkdir(string2, 493);
            }
            string = string2;
        }
        return true;
    }

    @Override
    public String getParent() {
        return this.curpath.getParentPath();
    }

    public EFile parentFile() {
        this.curpath.parent();
        return this;
    }

    @Override
    public void putBytes(byte[] byArray) throws IOException, FileNotFoundException {
        OutputStream outputStream = this.getOutputStream();
        outputStream.write(byArray);
        outputStream.close();
    }

    @Override
    public void setName(String string) {
        this.curpath.setName(string);
    }

    @Override
    public void setPath(String string) {
        this.curpath.setPath(string);
    }

    @Override
    public String toString() {
        return "ssh://" + this.user + "@" + this.server + this.curpath.getPath();
    }

    private boolean deleteDir(String string) throws IOException {
        Vector vector = this.client.ls(string);
        String string2 = string + "/";
        for (SFTPv3DirectoryEntry sFTPv3DirectoryEntry : vector) {
            if (sFTPv3DirectoryEntry.filename.equals(".") || sFTPv3DirectoryEntry.filename.equals("..")) continue;
            String string3 = string2 + sFTPv3DirectoryEntry.filename;
            if (sFTPv3DirectoryEntry.attributes.isDirectory()) {
                if (this.deleteDir(string3)) continue;
                return false;
            }
            this.client.rm(string3);
        }
        this.client.rmdir(string);
        return true;
    }

    private String[] list(String string) throws IOException {
        Vector vector = this.client.ls(string);
        if (vector != null) {
            String[] stringArray = new String[vector.size()];
            int n = 0;
            Iterator iterator = vector.iterator();
            while (iterator.hasNext()) {
                stringArray[n++] = ((SFTPv3DirectoryEntry)iterator.next()).filename;
            }
            return stringArray;
        }
        return null;
    }

    class SshFileIterator
    implements Iterator {
        String[] list;
        int i = 0;

        SshFileIterator(String[] stringArray) {
            this.list = stringArray;
        }

        @Override
        public boolean hasNext() {
            return this.list != null && this.i < this.list.length;
        }

        public Object next() throws NoSuchElementException {
            if (this.list == null || this.i >= this.list.length) {
                throw new NoSuchElementException(String.valueOf(this.i));
            }
            SshFile.this.setName(this.list[this.i++]);
            return SshFile.this;
        }

        @Override
        public void remove() throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }
    }

    class SshOutputStream
    extends OutputStream {
        private SFTPv3FileHandle handle;
        private long pos;

        SshOutputStream(SFTPv3FileHandle sFTPv3FileHandle) {
            this.handle = sFTPv3FileHandle;
        }

        @Override
        public void close() throws IOException {
            SshFile.this.client.closeFile(this.handle);
        }

        @Override
        public void write(int n) throws IOException {
            byte[] byArray = new byte[]{(byte)n};
            this.write(byArray, 0, 1);
        }

        @Override
        public void write(byte[] byArray, int n, int n2) throws IOException {
            SshFile.this.client.write(this.handle, this.pos, byArray, n, n2);
            this.pos += (long)n2;
        }

        @Override
        public void write(byte[] byArray) throws IOException {
            this.write(byArray, 0, byArray.length);
        }
    }

    class SshInputStream
    extends InputStream {
        private SFTPv3FileHandle handle;
        private long pos;

        SshInputStream(SFTPv3FileHandle sFTPv3FileHandle) {
            this.handle = sFTPv3FileHandle;
        }

        @Override
        public void close() throws IOException {
            SshFile.this.client.closeFile(this.handle);
        }

        @Override
        public int read() throws IOException {
            byte[] byArray = new byte[1];
            if (SshFile.this.client.read(this.handle, this.pos, byArray, 0, 1) < 0) {
                return -1;
            }
            ++this.pos;
            return byArray[0];
        }

        @Override
        public int read(byte[] byArray, int n, int n2) throws IOException {
            int n3 = SshFile.this.client.read(this.handle, this.pos, byArray, n, n2);
            if (n3 > 0) {
                this.pos += (long)n3;
            }
            return n3;
        }

        @Override
        public int read(byte[] byArray) throws IOException {
            return this.read(byArray, 0, byArray.length);
        }
    }
}

