/*
 * Decompiled with CFR 0.152.
 */
package de.monoped.efile;

import de.monoped.efile.EFile;
import de.monoped.efile.Path;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class LocalFile
implements EFile {
    private Path curpath;

    public LocalFile(String string) {
        this.curpath = new Path(string);
    }

    @Override
    public void addPath(String string) {
        this.curpath.addPath(string);
    }

    @Override
    public void close() {
    }

    @Override
    public void copyFrom(File file) throws IOException, FileNotFoundException {
        this.copyFrom(new FileInputStream(file));
    }

    @Override
    public void copyFrom(InputStream inputStream) throws IOException, FileNotFoundException {
        int n;
        OutputStream outputStream = this.getOutputStream();
        byte[] byArray = new byte[4096];
        while ((n = inputStream.read(byArray)) >= 0) {
            outputStream.write(byArray, 0, n);
        }
        inputStream.close();
        outputStream.close();
    }

    @Override
    public void delete() {
        new File(this.curpath.getPath()).delete();
    }

    @Override
    public void delete(boolean bl) {
        File file = new File(this.curpath.getPath());
        if (!bl || !file.isDirectory()) {
            file.delete();
        } else {
            this.deleteDir(file);
        }
    }

    private boolean deleteDir(File file) {
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            File file2 = fileArray[i];
            if (!(file2.isDirectory() ? !this.deleteDir(file2) : !file2.delete())) continue;
            return false;
        }
        file.delete();
        return true;
    }

    @Override
    public boolean exists() {
        return new File(this.curpath.getPath()).exists();
    }

    @Override
    public String getBase() {
        return this.curpath.getPath();
    }

    @Override
    public byte[] getBytes() throws IOException {
        int n;
        InputStream inputStream = this.getInputStream();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[2048];
        while ((n = inputStream.read(byArray)) >= 0) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        inputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    @Override
    public InputStream getInputStream() throws IOException, FileNotFoundException {
        return new FileInputStream(this.curpath.getPath());
    }

    @Override
    public String getName() {
        return this.curpath.getName();
    }

    @Override
    public String getParent() {
        return this.curpath.getParentPath();
    }

    @Override
    public String getPath() {
        return this.curpath.getPath();
    }

    @Override
    public OutputStream getOutputStream() throws IOException, FileNotFoundException {
        return new FileOutputStream(this.curpath.getPath());
    }

    @Override
    public boolean isDirectory() {
        return new File(this.curpath.getPath()).isDirectory();
    }

    @Override
    public String[] list() {
        return new File(this.curpath.getPath()).list();
    }

    @Override
    public String[] list(FilenameFilter filenameFilter) {
        return new File(this.curpath.getPath()).list(filenameFilter);
    }

    @Override
    public Iterator iterator() {
        return new LocalFileIterator(new File(this.curpath.getPath()).list());
    }

    @Override
    public Iterator iterator(FilenameFilter filenameFilter) {
        return new LocalFileIterator(new File(this.curpath.getPath()).list(filenameFilter));
    }

    @Override
    public boolean mkdirs() {
        File file = new File(this.curpath.getPath());
        file.mkdirs();
        return file.exists();
    }

    @Override
    public void putBytes(byte[] byArray) throws IOException, FileNotFoundException {
        OutputStream outputStream = this.getOutputStream();
        outputStream.write(byArray);
        outputStream.close();
    }

    @Override
    public void setName(String string) {
        this.curpath.setName(string);
    }

    @Override
    public void setPath(String string) {
        this.curpath.setPath(string);
    }

    @Override
    public String toString() {
        return this.curpath.getPath();
    }

    class LocalFileIterator
    implements Iterator {
        private int i = 0;
        private String[] list;

        LocalFileIterator(String[] stringArray) {
            this.list = stringArray;
        }

        @Override
        public boolean hasNext() {
            return this.list != null && this.i < this.list.length;
        }

        public Object next() throws NoSuchElementException {
            if (this.list == null || this.i >= this.list.length) {
                throw new NoSuchElementException(String.valueOf(this.i));
            }
            LocalFile.this.setName(this.list[this.i++]);
            return this;
        }

        @Override
        public void remove() throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }
    }
}

