/*
 * Decompiled with CFR 0.152.
 */
package de.monoped.efile;

import com.enterprisedt.net.ftp.FTPClient;
import com.enterprisedt.net.ftp.FTPException;
import com.enterprisedt.net.ftp.FTPFile;
import com.enterprisedt.net.ftp.FTPTransferType;
import de.monoped.efile.EFile;
import de.monoped.efile.Path;
import de.monoped.efile.Utils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class FtpFile
implements EFile {
    static final int READ = 1;
    static final int WRITE = 2;
    private FTPClient client;
    private String ftpdir;
    private String server;
    private String user;
    private String password;
    private Path curpath;
    private HashMap<String, FTPFile[]> dirmap;

    public FtpFile(String string, String string2, String string3, String string4) throws IOException, FTPException {
        this.server = string;
        this.user = string2;
        this.curpath = new Path(string4);
        this.password = string3;
        this.dirmap = new HashMap();
        this.client = new FTPClient();
        this.client.setRemoteHost(string);
        this.client.connect();
        this.client.user(string2);
        this.client.password(string3);
        this.client.setType(FTPTransferType.BINARY);
    }

    @Override
    public void addPath(String string) throws IOException {
        this.curpath.addPath(string);
    }

    @Override
    public void close() throws IOException {
        try {
            this.client.quit();
        }
        catch (FTPException fTPException) {
            throw new IOException(fTPException);
        }
    }

    @Override
    public void copyFrom(File file) throws IOException, FileNotFoundException {
        this.copyFrom(new FileInputStream(file));
    }

    @Override
    public void copyFrom(InputStream inputStream) throws IOException, FileNotFoundException {
        int n;
        OutputStream outputStream = this.getOutputStream();
        byte[] byArray = new byte[4096];
        while ((n = inputStream.read(byArray)) >= 0) {
            outputStream.write(byArray, 0, n);
        }
        inputStream.close();
        outputStream.close();
    }

    @Override
    public void delete() throws IOException {
        if (this.curpath.getPath().equals("/")) {
            return;
        }
        try {
            FTPFile fTPFile = this.getFtpFile();
            if (fTPFile == null) {
                return;
            }
            if (fTPFile.isDir()) {
                this.client.rmdir(this.curpath.getPath());
            } else {
                this.client.delete(this.curpath.getPath());
            }
        }
        catch (Exception exception) {
            throw new IOException(exception);
        }
        this.dirmap.remove(this.curpath.getParentPath());
    }

    @Override
    public void delete(boolean bl) throws IOException {
        if (!bl || !this.isDirectory()) {
            this.delete();
        } else {
            this.deleteDir(this.curpath.getPath());
        }
    }

    @Override
    public boolean exists() throws IOException {
        try {
            return this.curpath.getPath().equals("/") || this.getFtpFile() != null;
        }
        catch (Exception exception) {
            throw new IOException(exception.getMessage());
        }
    }

    @Override
    public String getBase() {
        return "ftp://" + this.user + "@" + this.server;
    }

    @Override
    public byte[] getBytes() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            this.client.get(byteArrayOutputStream, this.curpath.getPath());
        }
        catch (FTPException fTPException) {
            throw new IOException(fTPException.getMessage());
        }
        return byteArrayOutputStream.toByteArray();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        final PipedOutputStream pipedOutputStream = new PipedOutputStream();
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    FtpFile.this.client.get(pipedOutputStream, FtpFile.this.curpath.getPath());
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        };
        FtpInputStream ftpInputStream = new FtpInputStream(pipedOutputStream, thread);
        thread.start();
        return ftpInputStream;
    }

    @Override
    public String getName() {
        return this.curpath.getName();
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        final PipedInputStream pipedInputStream = new PipedInputStream();
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    FtpFile.this.client.put(pipedInputStream, FtpFile.this.curpath.getPath());
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        };
        FtpOutputStream ftpOutputStream = new FtpOutputStream(pipedInputStream, thread);
        thread.start();
        return ftpOutputStream;
    }

    @Override
    public String getParent() {
        return this.curpath.getParentPath();
    }

    @Override
    public String getPath() {
        return this.curpath.getPath();
    }

    @Override
    public boolean isDirectory() throws IOException {
        try {
            FTPFile fTPFile = this.getFtpFile();
            return fTPFile != null && fTPFile.isDir();
        }
        catch (Exception exception) {
            throw new IOException(exception.getMessage());
        }
    }

    @Override
    public Iterator iterator() throws IOException {
        return new FtpFileIterator(this.list());
    }

    @Override
    public Iterator iterator(FilenameFilter filenameFilter) throws IOException {
        return new FtpFileIterator(this.list(filenameFilter));
    }

    @Override
    public String[] list() throws IOException {
        try {
            FTPFile[] fTPFileArray = this.getChildren(this.curpath.getPath());
            if (fTPFileArray != null) {
                String[] stringArray = new String[fTPFileArray.length];
                for (int i = 0; i < fTPFileArray.length; ++i) {
                    stringArray[i] = fTPFileArray[i].getName();
                }
                return stringArray;
            }
        }
        catch (FTPException fTPException) {
            throw new IOException(fTPException.getMessage());
        }
        return null;
    }

    @Override
    public String[] list(FilenameFilter filenameFilter) throws IOException {
        try {
            FTPFile[] fTPFileArray = this.getChildren(this.curpath.getPath());
            if (fTPFileArray != null) {
                ArrayList<String> arrayList = new ArrayList<String>();
                for (int i = 0; i < fTPFileArray.length; ++i) {
                    String string = fTPFileArray[i].getName();
                    if (!filenameFilter.accept(null, string)) continue;
                    arrayList.add(string);
                }
                return arrayList.toArray(new String[0]);
            }
        }
        catch (FTPException fTPException) {
            throw new IOException(fTPException.getMessage());
        }
        return null;
    }

    @Override
    public boolean mkdirs() throws IOException {
        String[] stringArray = this.curpath.getPath().split("/");
        String string = "/";
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                String string2;
                String string3 = stringArray[i];
                if (string3.length() <= 0) continue;
                FTPFile[] fTPFileArray = this.getChildren(string);
                boolean bl = false;
                for (int j = 0; j < fTPFileArray.length; ++j) {
                    FTPFile fTPFile = fTPFileArray[j];
                    if (!fTPFile.getName().equals(string3)) continue;
                    bl = true;
                    break;
                }
                String string4 = string2 = string.endsWith("/") ? string + string3 : string + "/" + string3;
                if (!bl) {
                    this.client.mkdir(string2);
                    this.dirmap.remove(string);
                }
                string = string2;
            }
        }
        catch (FTPException fTPException) {
            throw new IOException(fTPException.getMessage());
        }
        return true;
    }

    public EFile parentFile() {
        this.curpath.parent();
        return this;
    }

    @Override
    public void putBytes(byte[] byArray) throws IOException {
        try {
            this.client.put(byArray, this.curpath.getPath());
        }
        catch (FTPException fTPException) {
            throw new IOException(fTPException.getMessage());
        }
    }

    @Override
    public void setName(String string) {
        if (!Utils.isName(string)) {
            throw new IllegalArgumentException(string);
        }
        this.curpath.setName(string);
    }

    @Override
    public void setPath(String string) {
        this.curpath.setPath(string);
    }

    @Override
    public String toString() {
        return "ftp://" + this.user + "@" + this.server + this.getPath();
    }

    private void chdir(String string) throws IOException, FTPException {
        if (!string.equals(this.ftpdir)) {
            this.ftpdir = string;
            this.client.chdir(this.ftpdir);
        }
    }

    private FTPFile[] getChildren(String string) throws IOException, FTPException {
        FTPFile[] fTPFileArray = this.dirmap.get(string);
        if (fTPFileArray == null) {
            try {
                fTPFileArray = this.client.dirDetails(string);
                this.dirmap.put(string, fTPFileArray);
            }
            catch (ParseException parseException) {
                throw new IOException(parseException.getMessage());
            }
        }
        return fTPFileArray;
    }

    private void deleteDir(String string) throws IOException {
        try {
            FTPFile[] fTPFileArray = this.getChildren(string);
            String string2 = string + "/";
            for (int i = 0; i < fTPFileArray.length; ++i) {
                FTPFile fTPFile = fTPFileArray[i];
                String string3 = string2 + fTPFile.getName();
                if (fTPFile.isDir()) {
                    this.deleteDir(string3);
                    continue;
                }
                this.client.delete(string3);
            }
            this.chdir("/");
            this.client.delete(string);
        }
        catch (FTPException fTPException) {
            throw new IOException(fTPException);
        }
    }

    private void dumpChildren(String string, FTPFile[] fTPFileArray) {
        System.out.println(string);
        if (fTPFileArray == null) {
            System.out.println("null");
        } else if (fTPFileArray.length == 0) {
            System.out.println("- keine -");
        } else {
            for (int i = 0; i < fTPFileArray.length; ++i) {
                FTPFile fTPFile = fTPFileArray[i];
                System.out.println("child: " + fTPFile.getName() + " dir: " + fTPFile.isDir() + " date: " + fTPFile.lastModified());
            }
        }
    }

    private FTPFile getFtpFile() throws FTPException, IOException, ParseException {
        FTPFile[] fTPFileArray = this.dirmap.get(this.curpath.getParentPath());
        if (fTPFileArray == null) {
            fTPFileArray = this.client.dirDetails(this.curpath.getParentPath());
            this.dirmap.put(this.curpath.getParentPath(), fTPFileArray);
        }
        for (int i = 0; i < fTPFileArray.length; ++i) {
            FTPFile fTPFile = fTPFileArray[i];
            if (!fTPFile.getName().equals(this.curpath.getName())) continue;
            return fTPFile;
        }
        return null;
    }

    class FtpFileIterator
    implements Iterator {
        String[] list;
        int i;

        FtpFileIterator(String[] stringArray) {
            this.list = stringArray;
            this.i = 0;
        }

        @Override
        public boolean hasNext() {
            return this.list != null && this.i < this.list.length;
        }

        public Object next() throws NoSuchElementException {
            if (this.list == null || this.i >= this.list.length) {
                throw new NoSuchElementException(String.valueOf(this.i));
            }
            FtpFile.this.setName(this.list[this.i++]);
            return FtpFile.this;
        }

        @Override
        public void remove() throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }
    }

    class FtpOutputStream
    extends PipedOutputStream {
        private Thread thread;

        FtpOutputStream(PipedInputStream pipedInputStream, Thread thread) throws IOException {
            super(pipedInputStream);
            this.thread = thread;
        }

        @Override
        public void close() throws IOException {
            super.close();
            try {
                this.thread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    class FtpInputStream
    extends PipedInputStream {
        private Thread thread;

        FtpInputStream(PipedOutputStream pipedOutputStream, Thread thread) throws IOException {
            super(pipedOutputStream);
            this.thread = thread;
        }

        @Override
        public void close() throws IOException {
            try {
                this.thread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            super.close();
        }
    }
}

