/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp.internal;

import com.enterprisedt.util.debug.Logger;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.Socket;

public class SocketUtils {
    private static Logger log = Logger.getLogger("SocketUtils");
    static /* synthetic */ Class class$java$net$Socket;
    static /* synthetic */ Class class$java$net$InetAddress;

    public static Socket createSocket(InetAddress host, int port, int timeout) throws IOException {
        if (timeout == 0) {
            return new Socket(host, port);
        }
        try {
            Class<?> socketAddress = Class.forName("java.net.SocketAddress");
            Method connectMethod = (class$java$net$Socket == null ? (class$java$net$Socket = SocketUtils.class$("java.net.Socket")) : class$java$net$Socket).getMethod("connect", socketAddress, Integer.TYPE);
            Socket sock = (Socket)(class$java$net$Socket == null ? (class$java$net$Socket = SocketUtils.class$("java.net.Socket")) : class$java$net$Socket).newInstance();
            Class<?> inetSocketAddress = Class.forName("java.net.InetSocketAddress");
            Constructor<?> inetSocketAddressCtr = inetSocketAddress.getConstructor(class$java$net$InetAddress == null ? (class$java$net$InetAddress = SocketUtils.class$("java.net.InetAddress")) : class$java$net$InetAddress, Integer.TYPE);
            Object address = inetSocketAddressCtr.newInstance(host, new Integer(port));
            log.debug("Invoking connect with timeout=" + timeout);
            connectMethod.invoke((Object)sock, address, new Integer(timeout));
            log.debug("Connected successfully");
            return sock;
        }
        catch (InvocationTargetException ex) {
            Throwable target = ex.getTargetException();
            if (target instanceof IOException) {
                throw (IOException)target;
            }
            log.debug("Could not use timeout connecting to host (" + ex.toString() + ")");
            return new Socket(host, port);
        }
        catch (Exception ex) {
            log.debug("Could not use timeout connecting to host (" + ex.toString() + ")");
            return new Socket(host, port);
        }
    }

    public static boolean isConnected(Socket sock) throws IOException {
        try {
            Method connectedMethod = (class$java$net$Socket == null ? (class$java$net$Socket = SocketUtils.class$("java.net.Socket")) : class$java$net$Socket).getMethod("isConnected", null);
            Boolean result = (Boolean)connectedMethod.invoke((Object)sock, (Object[])null);
            return result;
        }
        catch (InvocationTargetException ex) {
            Throwable target = ex.getTargetException();
            if (target instanceof IOException) {
                throw (IOException)target;
            }
            log.debug("Could not use Socket.isConnected (" + ex.toString() + ")");
            return true;
        }
        catch (Exception ex) {
            log.debug("Could not use Socket.isConnected (" + ex.toString() + ")");
            return true;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

