/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp;

import com.enterprisedt.net.ftp.FTPFile;
import com.enterprisedt.net.ftp.FTPFileParser;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;

public class UnixFileParser
extends FTPFileParser {
    public static final String cvsId = "@(#)$Id: UnixFileParser.java,v 1.19 2007-12-18 07:52:53 bruceb Exp $";
    private static final String SYMLINK_ARROW = "->";
    private static final char SYMLINK_CHAR = 'l';
    private static final char[] FILE_CHARS = new char[]{'-', 'p'};
    private static final char DIRECTORY_CHAR = 'd';
    private SimpleDateFormat noHHmmFormatter1;
    private SimpleDateFormat noHHmmFormatter2;
    private SimpleDateFormat noHHmmFormatter;
    private SimpleDateFormat hhmmFormatter1;
    private SimpleDateFormat hhmmFormatter2;
    private SimpleDateFormat hhmmFormatter;
    private static final int MIN_FIELD_COUNT = 8;

    public UnixFileParser() {
        this.setLocale(Locale.getDefault());
    }

    public void setLocale(Locale locale) {
        this.noHHmmFormatter1 = new SimpleDateFormat("MMM-dd-yyyy", locale);
        this.noHHmmFormatter2 = new SimpleDateFormat("dd-MMM-yyyy", locale);
        this.noHHmmFormatter = this.noHHmmFormatter1;
        this.hhmmFormatter1 = new SimpleDateFormat("MMM-dd-yyyy-HH:mm", locale);
        this.hhmmFormatter2 = new SimpleDateFormat("dd-MMM-yyyy-HH:mm", locale);
        this.hhmmFormatter = this.hhmmFormatter1;
    }

    public static boolean isUnix(String raw) {
        char ch = raw.charAt(0);
        if (ch == 'd' || ch == 'l') {
            return true;
        }
        for (int i = 0; i < FILE_CHARS.length; ++i) {
            if (ch != FILE_CHARS[i]) continue;
            return true;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    public FTPFile parse(String raw) throws ParseException {
        if (!UnixFileParser.isUnix(raw)) {
            return null;
        }
        fields = this.split(raw);
        if (fields.length < 8) {
            listing = new StringBuffer("Unexpected number of fields in listing '");
            listing.append(raw).append("' - expected minimum ").append(8).append(" fields but found ").append(fields.length).append(" fields");
            throw new ParseException(listing.toString(), 0);
        }
        index = 0;
        ch = raw.charAt(0);
        permissions = fields[index++];
        ch = permissions.charAt(0);
        isDir = false;
        isLink = false;
        if (ch == 'd') {
            isDir = true;
        } else if (ch == 'l') {
            isLink = true;
        }
        linkCount = 0;
        if (Character.isDigit(fields[index].charAt(0))) {
            try {
                linkCount = Integer.parseInt(fields[index++]);
            }
            catch (NumberFormatException ignore) {
                // empty catch block
            }
        }
        owner = fields[index++];
        group = fields[index++];
        size = 0L;
        sizeStr = fields[index];
        if (!Character.isDigit(sizeStr.charAt(0)) && Character.isDigit(group.charAt(0))) {
            sizeStr = group;
            group = "";
        } else {
            ++index;
        }
        try {
            size = Long.parseLong(sizeStr);
        }
        catch (NumberFormatException ex) {
            throw new ParseException("Failed to parse size: " + sizeStr, 0);
        }
        if (Character.isDigit(fields[index].charAt(0))) {
            ++index;
        }
        dateTimePos = index;
        lastModified = null;
        stamp = new StringBuffer(fields[index++]);
        stamp.append('-').append(fields[index++]).append('-');
        field = fields[index++];
        if (field.indexOf(58) < 0) {
            stamp.append(field);
            try {
                lastModified = this.noHHmmFormatter.parse(stamp.toString());
            }
            catch (ParseException ignore) {
                this.noHHmmFormatter = this.noHHmmFormatter == this.noHHmmFormatter1 ? this.noHHmmFormatter2 : this.noHHmmFormatter1;
                try {
                    lastModified = this.noHHmmFormatter.parse(stamp.toString());
                }
                catch (ParseException ex) {
                    if (this.ignoreDateParseErrors) ** GOTO lbl84
                    throw ex;
                }
            }
        } else {
            block33: {
                cal = Calendar.getInstance();
                year = cal.get(1);
                stamp.append(year).append('-').append(field);
                try {
                    lastModified = this.hhmmFormatter.parse(stamp.toString());
                }
                catch (ParseException ignore) {
                    this.hhmmFormatter = this.hhmmFormatter == this.hhmmFormatter1 ? this.hhmmFormatter2 : this.hhmmFormatter1;
                    try {
                        lastModified = this.hhmmFormatter.parse(stamp.toString());
                    }
                    catch (ParseException ex) {
                        if (this.ignoreDateParseErrors) break block33;
                        throw ex;
                    }
                }
            }
            cal.add(5, 2);
            if (lastModified != null && lastModified.after(cal.getTime())) {
                cal.setTime(lastModified);
                cal.add(1, -1);
                lastModified = cal.getTime();
            }
        }
lbl84:
        // 6 sources

        name = null;
        linkedname = null;
        pos = 0;
        ok = true;
        for (i = dateTimePos; i < dateTimePos + 3; ++i) {
            if ((pos = raw.indexOf(fields[i], pos)) < 0) {
                ok = false;
                break;
            }
            pos += fields[i].length();
        }
        if (ok) {
            remainder = this.trimStart(raw.substring(pos));
            if (!isLink) {
                name = remainder;
            } else {
                pos = remainder.indexOf("->");
                if (pos <= 0) {
                    name = remainder;
                } else {
                    len = "->".length();
                    name = remainder.substring(0, pos).trim();
                    if (pos + len < remainder.length()) {
                        linkedname = remainder.substring(pos + len);
                    }
                }
            }
        } else {
            throw new ParseException("Failed to retrieve name: " + raw, 0);
        }
        file = new FTPFile(raw, name, size, isDir, lastModified);
        file.setGroup(group);
        file.setOwner(owner);
        file.setLink(isLink);
        file.setLinkCount(linkCount);
        file.setLinkedName(linkedname);
        file.setPermissions(permissions);
        return file;
    }
}

