/*
 * Decompiled with CFR 0.152.
 */
package com.valeras.colorimetry.icc_profile;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ICC_CharacterisationData {
    private static final String TAG_ORIGINATOR = "ORIGINATOR";
    private static final String TAG_DESCRIPTOR = "DESCRIPTOR";
    private static final String TAG_CREATED = "CREATED";
    private static final String TAG_INSTRUMENTATION = "INSTRUMENTATION";
    private static final String TAG_PRINT_CONDITIONS = "PRINT_CONDITIONS";
    private static final String TAG_NUMBER_OF_FIELDS = "NUMBER_OF_FIELDS";
    private static final String TAG_BEGIN_DATA_FORMAT = "BEGIN_DATA_FORMAT";
    private static final String TAG_END_DATA_FORMAT = "END_DATA_FORMAT";
    private static final String TAG_NUMBER_OF_SETS = "NUMBER_OF_SETS";
    private static final String TAG_BEGIN_DATA = "BEGIN_DATA";
    private static final String TAG_END_DATA = "END_DATA";
    private static final String TAG_SAMPLE_ID = "SAMPLE_ID";
    private static final String TAG_CMYK_C = "CMYK_C";
    private static final String TAG_CMYK_M = "CMYK_M";
    private static final String TAG_CMYK_Y = "CMYK_Y";
    private static final String TAG_CMYK_K = "CMYK_K";
    private static final String TAG_XYZ_X = "XYZ_X";
    private static final String TAG_XYZ_Y = "XYZ_Y";
    private static final String TAG_XYZ_Z = "XYZ_Z";
    private static final String TAG_LAB_L = "LAB_L";
    private static final String TAG_LAB_A = "LAB_A";
    private static final String TAG_LAB_B = "LAB_B";
    private final String[] PROPERTY_TAGS = new String[]{"ORIGINATOR", "DESCRIPTOR", "CREATED", "INSTRUMENTATION", "PRINT_CONDITIONS", "NUMBER_OF_FIELDS", "NUMBER_OF_SETS"};
    private final String[] SCOPE_TAGS = new String[]{"BEGIN_DATA_FORMAT", "END_DATA_FORMAT", "BEGIN_DATA", "END_DATA"};
    private String signature;
    private int numberOfSets;
    private final ArrayList<Sample> samples;
    private final Properties properties = new Properties();
    private DataFormat dataFormat = null;

    public ICC_CharacterisationData(InputStream stream) {
        this.samples = new ArrayList();
        try {
            this.parse(stream);
        }
        catch (IOException ex) {
            Logger.getLogger(ICC_CharacterisationData.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (ParseException ex) {
            Logger.getLogger(ICC_CharacterisationData.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public Iterator<Sample> iterator() {
        return new SampleIterator();
    }

    public boolean containsColorComponents(int colorSpaceType) {
        return this.dataFormat.contains(colorSpaceType);
    }

    public String getSignature() {
        return this.signature;
    }

    public int getNumberOfSets() {
        return this.numberOfSets;
    }

    private void parse(InputStream stream) throws IOException, ParseException {
        String l_text;
        ParserState l_parserState = ParserState.Begin;
        int l_line = 0;
        BufferedReader l_br = new BufferedReader(new InputStreamReader(stream));
        while ((l_text = l_br.readLine()) != null) {
            l_text = l_text.trim();
            String[] l_tokens = l_text.split(" ");
            switch (l_parserState) {
                case Begin: {
                    this.signature = l_text;
                    l_parserState = ParserState.Header;
                    break;
                }
                case Header: {
                    if (this.indexIn(l_tokens[0], this.PROPERTY_TAGS) >= 0) {
                        this.parseProperty(l_text);
                        break;
                    }
                    if (this.indexIn(l_tokens[0], this.SCOPE_TAGS) < 0) break;
                    if ((l_text = l_text.toUpperCase()).equals(TAG_BEGIN_DATA_FORMAT)) {
                        l_parserState = ParserState.DataFormat;
                        break;
                    }
                    if (!l_text.equals(TAG_BEGIN_DATA)) break;
                    l_parserState = ParserState.SampleData;
                    break;
                }
                case DataFormat: {
                    this.dataFormat = new DataFormat(l_text);
                    l_parserState = ParserState.Header;
                    break;
                }
                case SampleData: {
                    if (l_text.toUpperCase().equals(TAG_END_DATA)) {
                        l_parserState = ParserState.Finished;
                        break;
                    }
                    Sample l_sample = this.dataFormat.parse(l_text);
                    this.samples.add(l_sample);
                }
            }
            ++l_line;
        }
        l_br.close();
        l_text = this.properties.getProperty(TAG_NUMBER_OF_SETS);
        if (l_text != null) {
            int l_count;
            this.numberOfSets = l_count = Integer.parseInt(l_text);
        } else {
            Logger.getLogger(ICC_CharacterisationData.class.getName()).log(Level.SEVERE, "Wrong number of samples: {0}", this.numberOfSets);
        }
    }

    private void parseProperty(String text) throws ParseException {
        int l_index = text.indexOf(" ");
        if (l_index <= 0) {
            throw new ParseException(text, 0);
        }
        this.properties.setProperty(text.substring(0, l_index), text.substring(l_index).trim());
    }

    private int indexIn(String str, String[] samples) {
        for (int i = 0; i < samples.length; ++i) {
            if (!str.toUpperCase().equals(samples[i].toUpperCase())) continue;
            return i;
        }
        return -1;
    }

    public static class Sample {
        private int index;
        private final float[] cmykComponents;
        private final float[] xyzComponents;
        private final float[] labComponents;

        public Sample(int index, float[] cmyk, float[] xyz, float[] lab) {
            this.index = index;
            this.cmykComponents = cmyk != null ? Arrays.copyOf(cmyk, 4) : null;
            this.xyzComponents = xyz != null ? Arrays.copyOf(xyz, 3) : null;
            this.labComponents = lab != null ? Arrays.copyOf(lab, 3) : null;
        }

        public int getIndex() {
            return this.index;
        }

        public float[] getComponents(int colorSpace) {
            float[] l_components = null;
            switch (colorSpace) {
                case 9: {
                    l_components = this.cmykComponents;
                    break;
                }
                case 0: {
                    l_components = this.xyzComponents;
                    break;
                }
                case 1: {
                    l_components = this.labComponents;
                }
            }
            return l_components;
        }

        public String toString() {
            return "Sample {" + this.index + " cmyk={" + this.cmykComponents[0] + ", " + this.cmykComponents[1] + ", " + this.cmykComponents[2] + ", " + this.cmykComponents[3] + ", " + "}, xyz={" + this.xyzComponents[0] + ", " + this.xyzComponents[1] + ", " + this.xyzComponents[2] + "}, lab={" + this.labComponents[0] + ", " + this.labComponents[1] + ", " + this.labComponents[2] + "}}";
        }
    }

    private static class DataFormat {
        private static final HashMap<String, SampleField> translate = new HashMap();
        private final SampleField[] fields;
        private boolean hasCMYK;
        private boolean hasXYZ;
        private boolean hasLab;

        public DataFormat(String text) {
            String[] l_tokens = text.split(" ");
            this.hasLab = false;
            this.hasXYZ = false;
            this.hasCMYK = false;
            this.fields = new SampleField[l_tokens.length];
            for (int i = 0; i < l_tokens.length; ++i) {
                this.fields[i] = translate.get(l_tokens[i].trim().toUpperCase());
            }
            block6: for (SampleField field : this.fields) {
                if (field == SampleField.SAMPLE_ID) continue;
                switch (this.typeOf(field)) {
                    case 9: {
                        this.hasCMYK = true;
                        continue block6;
                    }
                    case 0: {
                        this.hasXYZ = true;
                        continue block6;
                    }
                    case 1: {
                        this.hasLab = true;
                    }
                }
            }
        }

        public boolean contains(int csType) {
            boolean l_flag;
            switch (csType) {
                case 9: {
                    l_flag = this.hasCMYK;
                    break;
                }
                case 0: {
                    l_flag = this.hasXYZ;
                    break;
                }
                case 1: {
                    l_flag = this.hasLab;
                    break;
                }
                default: {
                    l_flag = false;
                }
            }
            return l_flag;
        }

        public Sample parse(String text) {
            String[] l_tokens = text.split(" ");
            int l_index = -1;
            float[] l_cmyk = new float[4];
            float[] l_xyz = new float[3];
            float[] l_lab = new float[3];
            int i = 0;
            block5: for (String l_text : l_tokens) {
                SampleField l_field;
                if (l_text.trim().isEmpty()) continue;
                if ((l_field = this.fields[i++]) == SampleField.SAMPLE_ID) {
                    l_index = Integer.parseInt(l_text);
                    continue;
                }
                float l_value = Float.parseFloat(l_text);
                int l_model = this.typeOf(l_field);
                int l_component = this.indexOf(l_field);
                switch (l_model) {
                    case 9: {
                        l_cmyk[l_component] = l_value;
                        continue block5;
                    }
                    case 0: {
                        l_xyz[l_component] = l_value;
                        continue block5;
                    }
                    case 1: {
                        l_lab[l_component] = l_value;
                    }
                }
            }
            Sample l_sample = new Sample(l_index, l_cmyk, l_xyz, l_lab);
            return l_sample;
        }

        private int typeOf(SampleField field) {
            int l_type;
            switch (field) {
                case CMYK_C: 
                case CMYK_M: 
                case CMYK_Y: 
                case CMYK_K: {
                    l_type = 9;
                    break;
                }
                case XYZ_X: 
                case XYZ_Y: 
                case XYZ_Z: {
                    l_type = 0;
                    break;
                }
                case LAB_L: 
                case LAB_A: 
                case LAB_B: {
                    l_type = 1;
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            return l_type;
        }

        private int indexOf(SampleField field) {
            int l_index = -1;
            switch (field) {
                case CMYK_C: 
                case XYZ_X: 
                case LAB_L: {
                    l_index = 0;
                    break;
                }
                case CMYK_M: 
                case XYZ_Y: 
                case LAB_A: {
                    l_index = 1;
                    break;
                }
                case CMYK_Y: 
                case XYZ_Z: 
                case LAB_B: {
                    l_index = 2;
                    break;
                }
                case CMYK_K: {
                    l_index = 3;
                }
            }
            return l_index;
        }

        static {
            translate.put(ICC_CharacterisationData.TAG_SAMPLE_ID, SampleField.SAMPLE_ID);
            translate.put(ICC_CharacterisationData.TAG_CMYK_C, SampleField.CMYK_C);
            translate.put(ICC_CharacterisationData.TAG_CMYK_M, SampleField.CMYK_M);
            translate.put(ICC_CharacterisationData.TAG_CMYK_Y, SampleField.CMYK_Y);
            translate.put(ICC_CharacterisationData.TAG_CMYK_K, SampleField.CMYK_K);
            translate.put(ICC_CharacterisationData.TAG_LAB_L, SampleField.LAB_L);
            translate.put(ICC_CharacterisationData.TAG_LAB_A, SampleField.LAB_A);
            translate.put(ICC_CharacterisationData.TAG_LAB_B, SampleField.LAB_B);
            translate.put(ICC_CharacterisationData.TAG_XYZ_X, SampleField.XYZ_X);
            translate.put(ICC_CharacterisationData.TAG_XYZ_Y, SampleField.XYZ_Y);
            translate.put(ICC_CharacterisationData.TAG_XYZ_Z, SampleField.XYZ_Z);
        }
    }

    private class SampleIterator
    implements Iterator<Sample> {
        private int index = 0;

        @Override
        public boolean hasNext() {
            return this.index < ICC_CharacterisationData.this.samples.size();
        }

        @Override
        public Sample next() {
            return (Sample)ICC_CharacterisationData.this.samples.get(this.index++);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    private static enum ParserState {
        Begin,
        Finished,
        Header,
        DataFormat,
        SampleData;

    }

    private static enum SampleField {
        SAMPLE_ID,
        CMYK_C,
        CMYK_M,
        CMYK_Y,
        CMYK_K,
        XYZ_X,
        XYZ_Y,
        XYZ_Z,
        LAB_L,
        LAB_A,
        LAB_B;

    }
}

