/*
 * Decompiled with CFR 0.152.
 */
package com.valeras.colorimetry.colour_difference;

import com.valeras.colorimetry.CIELab_ColorSpace;
import com.valeras.colorimetry.CIE_ColourDifference;
import java.awt.Color;
import java.awt.color.ColorSpace;

public class CIE94Formula
extends CIE_ColourDifference {
    private final ColorSpace cs = CIELab_ColorSpace.getInstance();
    private final float Kl;
    private final float Kc;
    private final float Kh;
    private final float K1;
    private final float K2;

    public CIE94Formula() {
        this.Kl = 1.0f;
        this.Kc = 1.0f;
        this.Kh = 1.0f;
        this.K1 = 0.045f;
        this.K2 = 0.015f;
    }

    @Override
    public float delta(Color reference, Color sample) {
        float[] Lab1 = this.cs.fromRGB(reference.getColorComponents(null));
        float[] Lab2 = this.cs.fromRGB(sample.getColorComponents(null));
        float dL = Lab1[0] - Lab2[0];
        float da = Lab1[1] - Lab2[1];
        float db = Lab1[2] - Lab2[2];
        float C1 = (float)Math.sqrt(Lab1[1] * Lab1[1] + Lab1[2] * Lab1[2]);
        float C2 = (float)Math.sqrt(Lab2[1] * Lab2[1] + Lab2[2] * Lab2[2]);
        float dC = C1 - C2;
        float dH = (float)Math.sqrt(da * da + db * db - dC * dC);
        float Sl = 1.0f;
        float Sc = 1.0f + this.K1 * C1;
        float Sh = 1.0f + this.K2 * C1;
        float v1 = dL / (this.Kl * Sl);
        float v2 = dC / (this.Kc * Sc);
        float v3 = dH / (this.Kh * Sh);
        float delta = (float)Math.sqrt(v1 * v1 + v2 * v2 + v3 * v3);
        return delta;
    }

    public String toString() {
        return "CIE94";
    }
}

