/*
 * Decompiled with CFR 0.152.
 */
package com.valeras.colorimetry;

import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DefaultColorSpaceProvider {
    private static final String ICC_FOLDER = "icc_profiles/";
    private static final String ICC_ADOBERGB1998 = "AdobeRGB1998.icc";
    private static final String ICC_CMYK_GENERIC = "CMYK.pf";
    private static final String ICC_CMYK_COATED_FOGRA27 = "CoatedFOGRA27.icc";
    private static final String ICC_CMYK_GRA = "GRACoL2006_Coated1v2.icc";

    public DefaultColorSpaceProvider() {
        ICC_ColorSpace l_adobe = null;
        try {
            ICC_Profile l_cmykProfile = this.loadICC_Profile(ICC_CMYK_COATED_FOGRA27);
        }
        catch (IOException ex) {
            Logger.getLogger(DefaultColorSpaceProvider.class.getName()).log(Level.SEVERE, null, ex);
        }
        try {
            ICC_Profile l_AdobeRGB = this.loadICC_Profile(ICC_ADOBERGB1998);
            l_adobe = new ICC_ColorSpace(l_AdobeRGB);
        }
        catch (IOException ex) {
            Logger.getLogger(DefaultColorSpaceProvider.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void addICC_ColorSpaces() {
        ICC_Profile l_profile = null;
        try {
            l_profile = this.loadICC_Profile(ICC_CMYK_GENERIC);
        }
        catch (IOException ex) {
            Logger.getLogger(DefaultColorSpaceProvider.class.getName()).log(Level.SEVERE, null, ex);
        }
        ICC_ColorSpace l_space = new ICC_ColorSpace(l_profile);
        System.out.println("type=" + l_space.getType());
        System.out.println("min=" + l_space.getMinValue(0) + ", max=" + l_space.getMaxValue(0));
        System.out.println("components=" + l_space.getNumComponents());
        System.out.println("name=" + l_space.getName(0));
        System.out.println("name=" + l_space.getName(1));
        System.out.println("name=" + l_space.getName(2));
        System.out.println("name=" + l_space.getName(3));
    }

    private ICC_Profile loadICC_Profile(String name) throws IOException {
        InputStream l_stream = null;
        ICC_Profile l_profile = null;
        if (l_stream != null) {
            l_stream.close();
        }
        return l_profile;
    }
}

