/*
 * Decompiled with CFR 0.152.
 */
package com.valeras.colorimetry;

import java.awt.color.ColorSpace;

public class CIELab_ColorSpace
extends ColorSpace {
    private static final String CS_NAME = "CIE 1976 (L*a*b*)";
    private static final float REF_X = 0.9642f;
    private static final float REF_Y = 1.0f;
    private static final float REF_Z = 0.8249f;
    private static final ColorSpace csRGB;
    private static CIELab_ColorSpace instance;
    private static final double TK = 0.20689655172413793;
    private static double FK;

    public static CIELab_ColorSpace getInstance() {
        if (instance == null) {
            instance = new CIELab_ColorSpace();
        }
        return instance;
    }

    public CIELab_ColorSpace() {
        super(1, 3);
    }

    @Override
    public float[] toRGB(float[] colorvalue) {
        return csRGB.fromCIEXYZ(this.toCIEXYZ(colorvalue));
    }

    @Override
    public float[] fromRGB(float[] rgbvalue) {
        return this.fromCIEXYZ(csRGB.toCIEXYZ(rgbvalue));
    }

    @Override
    public float[] toCIEXYZ(float[] colorvalue) {
        float[] xyz = new float[3];
        float nY = (colorvalue[0] + 16.0f) / 116.0f;
        xyz[0] = 0.9642f * this.fi(colorvalue[1] / 500.0f + nY);
        xyz[1] = 1.0f * this.fi_Y(nY, colorvalue[0]);
        xyz[2] = 0.8249f * this.fi(nY - colorvalue[2] / 200.0f);
        return xyz;
    }

    private float fi(float t) {
        return (float)((double)t > 0.20689655172413793 ? Math.pow(t, 3.0) : ((double)t - 0.13793103448275862) * 108.0 / 841.0);
    }

    private float fi_Y(float t, float L) {
        return (float)((double)t > 0.20689655172413793 || (double)L > 8.0 ? Math.pow(t, 3.0) : ((double)t - 0.13793103448275862) * 108.0 / 841.0);
    }

    @Override
    public float[] fromCIEXYZ(float[] colorvalue) {
        float[] lab = new float[3];
        float nt_X = this.f(colorvalue[0] / 0.9642f);
        float nt_Y = this.f(colorvalue[1] / 1.0f);
        float nt_Z = this.f(colorvalue[2] / 0.8249f);
        lab[0] = 116.0f * nt_Y - 16.0f;
        lab[1] = 500.0f * (nt_X - nt_Y);
        lab[2] = 200.0f * (nt_Y - nt_Z);
        return lab;
    }

    private float f(float t) {
        return (float)((double)t > FK ? Math.pow(t, 0.3333333333333333) : 7.787037037037037 * (double)t + 0.13793103448275862);
    }

    public String toString() {
        return CS_NAME;
    }

    @Override
    public float getMaxValue(int component) {
        float l_value;
        switch (component) {
            case 0: {
                l_value = 100.0f;
                break;
            }
            case 1: 
            case 2: {
                l_value = 127.0f;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return l_value;
    }

    @Override
    public float getMinValue(int component) {
        float l_value;
        switch (component) {
            case 0: {
                l_value = 0.0f;
                break;
            }
            case 1: 
            case 2: {
                l_value = -128.0f;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return l_value;
    }

    static {
        instance = null;
        csRGB = ColorSpace.getInstance(1000);
        FK = (float)Math.pow(0.20689655172413793, 3.0);
    }
}

