/*
 * Decompiled with CFR 0.152.
 */
package com.valeras.mdi;

import com.valeras.mdi.AbstractDocument;
import com.valeras.mdi.AbstractDocumentManager;
import com.valeras.mdi.FileType;
import java.util.ArrayList;
import java.util.List;

public class MultipleDocumentManager<T extends AbstractDocument>
extends AbstractDocumentManager<T> {
    protected final ArrayList<T> documentList = new ArrayList();
    private int selectedIndex = -1;

    public MultipleDocumentManager(FileType nativeFileType, FileType[] supportedFileTypes) {
        super(nativeFileType, supportedFileTypes);
    }

    @Override
    public boolean isMultipleDocumentManager() {
        return true;
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    @Override
    public T getSelectedDocument() {
        if (this.selectedIndex >= 0) {
            return (T)((AbstractDocument)this.documentList.get(this.selectedIndex));
        }
        return null;
    }

    @Override
    public void setSelectedDocument(T document) {
        if (!this.documentList.contains(document)) {
            this.documentList.add(document);
        }
        this.selectedIndex = this.documentList.indexOf(document);
        this.fireDocumentSelectedEvent((AbstractDocument)document);
    }

    @Override
    protected void documentAdd(T document) {
        this.documentList.add(document);
    }

    @Override
    protected void documentRemove(T document) {
        this.documentList.remove(document);
    }

    @Override
    public List<T> listDocuments() {
        return new ArrayList<T>(this.documentList);
    }
}

