/*
 * Decompiled with CFR 0.152.
 */
package com.valeras.mdi;

import com.valeras.mdi.CompositeFileFilter;
import com.valeras.mdi.FileFormat;
import java.io.File;
import java.util.ArrayList;
import javax.swing.filechooser.FileFilter;

public class FileType
extends ArrayList<FileFormat> {
    private static final String EXTENSION_SEPARATOR = ", ";
    private static final String EXTENSION_PREFIX = "*.";
    private final String description;

    public FileType(String description) {
        this.description = description;
    }

    public final String getDescription() {
        return this.description;
    }

    public FileFormat getNativeFileFormat() {
        return (FileFormat)this.get(0);
    }

    public FileFormat getFileFormat(File pathname) {
        for (FileFormat l_format : this) {
            if (!l_format.extensionEquals(pathname)) continue;
            return l_format;
        }
        return null;
    }

    public final boolean isCompatible(File pathname) {
        for (FileFormat l_format : this) {
            if (!l_format.extensionEquals(pathname)) continue;
            return true;
        }
        return false;
    }

    public FileFilter getFileFilter() {
        FileFilter l_filter = new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                for (FileFormat l_f : FileType.this) {
                    if (!l_f.extensionEquals(f)) continue;
                    return true;
                }
                return false;
            }

            @Override
            public String getDescription() {
                String l_text = FileType.this.description + " (";
                int l_count = FileType.this.size();
                for (int i = 0; i < l_count; ++i) {
                    FileFormat l_format = (FileFormat)FileType.this.get(i);
                    l_text = l_text + FileType.EXTENSION_PREFIX + l_format.getExtension();
                    if (i >= l_count - 1) continue;
                    l_text = l_text + FileType.EXTENSION_SEPARATOR;
                }
                l_text = l_text + ")";
                return l_text;
            }
        };
        return l_filter;
    }

    public static FileFilter[] createChoosableFileFilters(FileType[] fileTypes) {
        FileFilter[] l_filters = new FileFilter[fileTypes.length];
        int l_index = 0;
        for (FileType ft : fileTypes) {
            l_filters[l_index++] = ft.getFileFilter();
        }
        return l_filters;
    }

    public static FileFilter createCompositeFileFilter(FileType[] fileTypes, String description) {
        return new CompositeFileFilter(fileTypes, description);
    }
}

