/*
 * Decompiled with CFR 0.152.
 */
package com.valeras.mdi;

import com.valeras.mdi.CompositeFileFilter;
import java.io.File;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;

public class FileFormat {
    private String extension;
    private String description;
    private String name;

    public FileFormat(String name, String extension, String description) {
        this.extension = extension.toLowerCase();
        this.description = description;
        this.name = name;
    }

    public final String getExtension() {
        return this.extension;
    }

    public final String getDescription() {
        return this.description;
    }

    public String getName() {
        return this.name;
    }

    public final boolean extensionEquals(File pathname) {
        return pathname.getName().toLowerCase().endsWith(this.extension);
    }

    public FileFilter createFileFilter() {
        return new FileNameExtensionFilter(this.description + " (*." + this.extension + ")", this.extension);
    }

    @Deprecated
    public FileFilter getFileFilter() {
        FileFilter l_filter = new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                return FileFormat.this.extensionEquals(f);
            }

            @Override
            public String getDescription() {
                return FileFormat.this.description + " (*." + FileFormat.this.extension + ")";
            }
        };
        return l_filter;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof FileFormat)) {
            return false;
        }
        return this.name.equals(((FileFormat)obj).getName());
    }

    public int hashCode() {
        int hash = 7;
        hash = 59 * hash + (this.extension != null ? this.extension.hashCode() : 0);
        hash = 59 * hash + (this.name != null ? this.name.hashCode() : 0);
        return hash;
    }

    public String toString() {
        return this.name;
    }

    public static FileFilter[] createChoosableFileFilters(FileFormat[] formats) {
        FileFilter[] l_filters = new FileFilter[formats.length];
        int l_index = 0;
        for (FileFormat ff : formats) {
            l_filters[l_index++] = ff.createFileFilter();
        }
        return l_filters;
    }

    public static FileFilter createCompositeFileFilter(FileFormat[] formats, String description) {
        return new CompositeFileFilter(formats, description);
    }
}

