/*
 * Decompiled with CFR 0.152.
 */
package com.valeras.mdi;

import com.valeras.mdi.AbstractDocument;
import com.valeras.mdi.DocumentReader;
import com.valeras.mdi.DocumentWriter;
import com.valeras.mdi.FileFormat;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;

public class DocumentIO {
    private static final String MSG_NO_READER = "No reader registered for the given file format: {0}";
    private static final String MSG_NO_WRITER = "No writer registered for the given file format: {0}";
    private static final HashMap<String, ArrayList<DocumentReader>> registeredReaders = new HashMap();
    private static final HashMap<String, ArrayList<DocumentWriter>> registeredWriters = new HashMap();

    public static void registerReader(DocumentReader reader, FileFormat fileFormat) {
        ArrayList<Object> l_readers;
        String l_name = fileFormat.getName();
        if (!registeredReaders.containsKey(l_name)) {
            l_readers = new ArrayList();
            registeredReaders.put(l_name, l_readers);
        } else {
            l_readers = registeredReaders.get(l_name);
        }
        l_readers.add(reader);
    }

    public static void registerWriter(DocumentWriter writer, FileFormat fileFormat) {
        ArrayList<Object> l_writers;
        String l_name = fileFormat.getName();
        if (!registeredWriters.containsKey(l_name)) {
            l_writers = new ArrayList();
            registeredWriters.put(l_name, l_writers);
        } else {
            l_writers = registeredWriters.get(l_name);
        }
        l_writers.add(writer);
    }

    public void read(InputStream stream, FileFormat format, AbstractDocument document) throws IOException, ParseException {
        DocumentReader l_reader = DocumentIO.readerFor(format);
        if (l_reader == null) {
            throw new RuntimeException(MessageFormat.format(MSG_NO_READER, format));
        }
        l_reader.read(stream, document);
    }

    public void write(AbstractDocument document, OutputStream stream, FileFormat fileFormat) throws IOException {
        DocumentWriter l_writer = DocumentIO.writerFor(fileFormat);
        if (l_writer == null) {
            throw new RuntimeException(MessageFormat.format(MSG_NO_WRITER, fileFormat));
        }
        l_writer.write(document, stream);
    }

    protected static DocumentWriter writerFor(FileFormat fileFormat) {
        DocumentWriter l_writer = null;
        ArrayList<DocumentWriter> l_writers = registeredWriters.get(fileFormat.getName());
        if (l_writers != null) {
            l_writer = l_writers.get(0);
        }
        return l_writer;
    }

    protected static DocumentReader readerFor(FileFormat fileFormat) {
        DocumentReader l_reader = null;
        ArrayList<DocumentReader> l_readers = registeredReaders.get(fileFormat.getName());
        if (l_readers != null) {
            l_reader = l_readers.get(0);
        }
        return l_reader;
    }
}

