/*
 * Decompiled with CFR 0.152.
 */
package com.valeras.mdi;

import com.valeras.mdi.FileFormat;
import com.valeras.mdi.FileType;
import java.io.File;
import java.util.ArrayList;
import javax.swing.filechooser.FileFilter;

class CompositeFileFilter
extends FileFilter {
    private static final String EXTENSION_SEPARATOR = ", ";
    private static final String EXTENSION_PREFIX = "*.";
    private final ArrayList<FileFormat> formats;
    private final String description;

    public CompositeFileFilter(FileType[] fileTypes, String description) {
        String l_text = description + " (";
        this.formats = new ArrayList();
        for (FileType ft : fileTypes) {
            for (FileFormat ff : ft) {
                this.formats.add(ff);
                l_text = l_text + EXTENSION_PREFIX + ff.getExtension() + EXTENSION_SEPARATOR;
            }
        }
        this.description = l_text = l_text.substring(0, l_text.length() - EXTENSION_SEPARATOR.length()) + ")";
    }

    public CompositeFileFilter(FileFormat[] fileFormats, String description) {
        String l_text = description + " (";
        this.formats = new ArrayList();
        for (FileFormat ff : fileFormats) {
            this.formats.add(ff);
            l_text = l_text + EXTENSION_PREFIX + ff.getExtension() + EXTENSION_SEPARATOR;
        }
        this.description = l_text = l_text.substring(0, l_text.length() - EXTENSION_SEPARATOR.length()) + ")";
    }

    @Override
    public boolean accept(File f) {
        if (f.isDirectory()) {
            return true;
        }
        for (FileFormat format : this.formats) {
            if (!format.extensionEquals(f)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getDescription() {
        return this.description;
    }
}

