/*
 * Decompiled with CFR 0.152.
 */
package com.valeras.mdi;

import com.valeras.mdi.AbstractDocument;
import com.valeras.mdi.AbstractDocumentFactory;
import com.valeras.mdi.DocumentIO;
import com.valeras.mdi.DocumentView;
import com.valeras.mdi.DocumentViewFactory;
import com.valeras.mdi.FileFormat;
import com.valeras.mdi.FileType;
import com.valeras.mdi.event.DocumentManagerEvent;
import com.valeras.mdi.event.DocumentManagerListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public abstract class AbstractDocumentManager<T extends AbstractDocument> {
    private static final String MSG_INCOMPATIBLE_FILE = "File {0} is of unsupported type.";
    private static final int DEFAULT_BUFFER_SIZE = 1024;
    private AbstractDocumentFactory<T> documentFactory;
    private DocumentViewFactory<T> viewFactory;
    private final Map<AbstractDocument, DocumentView> viewMap;
    private final ArrayList<DocumentManagerListener> documentManagerListeners;
    private final DefaultDocumentChangeListener documentChangeListener;
    private DocumentIO documentIO;
    private final FileType nativeFileType;
    private final ArrayList<FileType> supportedFileTypes;

    protected AbstractDocumentManager(FileType nativeFileType, FileType[] supportedFileTypes) {
        this.nativeFileType = nativeFileType;
        this.supportedFileTypes = new ArrayList();
        if (supportedFileTypes != null) {
            this.supportedFileTypes.addAll(Arrays.asList(supportedFileTypes));
        }
        this.documentManagerListeners = new ArrayList();
        this.documentChangeListener = new DefaultDocumentChangeListener();
        this.documentFactory = null;
        this.viewFactory = null;
        this.viewMap = new HashMap<AbstractDocument, DocumentView>();
        this.documentIO = new DocumentIO();
    }

    public FileType getNativeFileType() {
        return this.nativeFileType;
    }

    public FileType[] getSupportedFileTypes() {
        FileType[] l_fileTypes = new FileType[1 + this.supportedFileTypes.size()];
        int l_index = 1;
        l_fileTypes[0] = this.nativeFileType;
        for (FileType ft : this.supportedFileTypes) {
            l_fileTypes[l_index++] = ft;
        }
        return l_fileTypes;
    }

    public void setDocumentIO(DocumentIO documentIO) {
        this.documentIO = documentIO;
    }

    public void setDocumentFactory(AbstractDocumentFactory<T> factory) {
        this.documentFactory = factory;
    }

    public AbstractDocumentFactory<T> getDocumentFactory() {
        return this.documentFactory;
    }

    public void setViewFactory(DocumentViewFactory<T> factory) {
        this.viewFactory = factory;
    }

    protected T createDocument(FileFormat format) {
        return this.documentFactory.createDocument(format);
    }

    public abstract boolean isMultipleDocumentManager();

    public abstract T getSelectedDocument();

    public abstract void setSelectedDocument(T var1);

    public T fileNew() {
        FileFormat l_format = this.nativeFileType.getNativeFileFormat();
        T l_document = this.createDocument(l_format);
        ((AbstractDocument)l_document).setFileFormat(l_format);
        return l_document;
    }

    public FileType getFileType(File file) {
        if (this.nativeFileType.isCompatible(file)) {
            return this.nativeFileType;
        }
        for (FileType fileType : this.supportedFileTypes) {
            if (!fileType.isCompatible(file)) continue;
            return fileType;
        }
        return null;
    }

    public T fileOpen(File file, T document, boolean readOnly) throws IOException, ParseException {
        FileType l_fileType = this.getFileType(file);
        if (l_fileType == null) {
            throw new RuntimeException(MessageFormat.format(MSG_INCOMPATIBLE_FILE, file.getAbsolutePath()));
        }
        FileFormat l_fileFormat = l_fileType.getFileFormat(file);
        T l_document = document != null ? document : this.createDocument(l_fileFormat);
        ((AbstractDocument)l_document).setIgnoreChanges(true);
        FileInputStream l_stream = new FileInputStream(file);
        this.documentIO.read(l_stream, l_fileFormat, (AbstractDocument)document);
        ((InputStream)l_stream).close();
        ((AbstractDocument)document).setFile(file);
        ((AbstractDocument)document).setFileFormat(l_fileFormat);
        ((AbstractDocument)l_document).setIgnoreChanges(false);
        return l_document;
    }

    public void fileSave(T document, File file, FileFormat fileFormat) throws IOException {
        int l_count;
        ByteArrayOutputStream l_bos = new ByteArrayOutputStream();
        byte[] l_buffer = new byte[1024];
        FileFormat l_fileFormat = fileFormat != null ? fileFormat : ((AbstractDocument)document).getFileFormat();
        this.documentIO.write((AbstractDocument)document, l_bos, l_fileFormat);
        if (fileFormat != null) {
            ((AbstractDocument)document).setFileFormat(fileFormat);
        }
        ByteArrayInputStream l_bis = new ByteArrayInputStream(l_bos.toByteArray());
        FileOutputStream l_os = new FileOutputStream(file);
        while ((l_count = l_bis.read(l_buffer, 0, 1024)) != -1) {
            ((OutputStream)l_os).write(l_buffer, 0, l_count);
        }
        ((OutputStream)l_os).close();
    }

    public void add(T document) {
        this.documentAdd(document);
        if (this.viewFactory != null) {
            DocumentView<T> l_view = this.viewFactory.createView(document);
            l_view.setDocument(document);
            this.viewMap.put((AbstractDocument)document, l_view);
        }
        this.fireDocumentOpenedEvent((AbstractDocument)document);
        ((AbstractDocument)document).addChangeListener(this.documentChangeListener);
    }

    public void remove(T document) {
        DocumentView l_view;
        this.documentRemove(document);
        if (this.viewFactory != null && (l_view = this.viewMap.get(document)) != null) {
            this.viewFactory.dispose(this.viewMap.get(document));
            this.viewMap.remove(document);
        }
        ((AbstractDocument)document).removeChangeListener(this.documentChangeListener);
        this.fireDocumentClosedEvent((AbstractDocument)document);
    }

    public abstract List<T> listDocuments();

    protected abstract void documentAdd(T var1);

    protected abstract void documentRemove(T var1);

    public boolean hasChangedDocuments() {
        List<T> l_documents = this.listDocuments();
        for (AbstractDocument d : l_documents) {
            if (!d.isChanged()) continue;
            return true;
        }
        return false;
    }

    public void addDocumentListener(DocumentManagerListener listener) {
        this.documentManagerListeners.add(listener);
    }

    public void removeDocumentListener(DocumentManagerListener listener) {
        this.documentManagerListeners.remove(listener);
    }

    public void removeAllDocumentListeners() {
        this.documentManagerListeners.clear();
    }

    protected void fireDocumentOpenedEvent(AbstractDocument document) {
        this.fireDocumentEvent(new DocumentManagerEvent(this, 1, document));
    }

    protected void fireDocumentClosedEvent(AbstractDocument document) {
        this.fireDocumentEvent(new DocumentManagerEvent(this, 2, document));
    }

    protected void fireDocumentSelectedEvent(AbstractDocument document) {
        this.fireDocumentEvent(new DocumentManagerEvent(this, 3, document));
    }

    protected void fireDocumentDeselectedEvent(AbstractDocument document) {
        this.fireDocumentEvent(new DocumentManagerEvent(this, 4, document));
    }

    protected void fireDocumentUpdateEvent(AbstractDocument document, String updateAction, float updateState) {
        this.fireDocumentEvent(new DocumentManagerEvent(this, 5, document, updateAction, updateState));
    }

    protected void fireDocumentChangedEvent(AbstractDocument document) {
        this.fireDocumentEvent(new DocumentManagerEvent(this, 6, document));
    }

    protected void fireDocumentEvent(DocumentManagerEvent event) {
        switch (event.getId()) {
            case 1: {
                for (DocumentManagerListener l : this.documentManagerListeners) {
                    l.documentOpened(event);
                }
                break;
            }
            case 2: {
                for (DocumentManagerListener l : this.documentManagerListeners) {
                    l.documentClosed(event);
                }
                break;
            }
            case 3: {
                for (DocumentManagerListener l : this.documentManagerListeners) {
                    l.documentSelected(event);
                }
                break;
            }
            case 4: {
                for (DocumentManagerListener l : this.documentManagerListeners) {
                    l.documentDeselected(event);
                }
                break;
            }
            case 5: {
                for (DocumentManagerListener l : this.documentManagerListeners) {
                    l.documentUpdate(event);
                }
                break;
            }
            case 6: {
                for (DocumentManagerListener l : this.documentManagerListeners) {
                    l.documentChanged(event);
                }
                break;
            }
        }
    }

    private class DefaultDocumentChangeListener
    implements ChangeListener {
        private DefaultDocumentChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            AbstractDocumentManager.this.fireDocumentChangedEvent((AbstractDocument)e.getSource());
        }
    }
}

