/*
 * Decompiled with CFR 0.152.
 */
package com.valeras.mdi;

import com.valeras.mdi.FileFormat;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public abstract class AbstractDocument {
    protected static final String PROPERTY_NAME = "document.name";
    protected static final String PROPERTY_REVISION = "document.revision";
    private File file = null;
    private FileFormat fileFormat = null;
    private boolean readOnly = false;
    protected final Properties properties = new Properties();
    private boolean changed = false;
    private boolean modified = false;
    private boolean ignoreChanges = false;
    protected final ArrayList<ChangeListener> changeListeners = new ArrayList();
    protected final ArrayList<PropertyChangeListener> propertyChangeListeners = new ArrayList();
    protected final ChangeEvent defaultChangeEvent = new ChangeEvent(this);

    protected AbstractDocument() {
        this.properties.setProperty(PROPERTY_REVISION, String.valueOf(0));
    }

    protected AbstractDocument(String name) {
        this();
        this.properties.setProperty(PROPERTY_NAME, name);
    }

    public boolean isChanged() {
        return this.changed;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean ro) {
        this.readOnly = ro;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public File getFile() {
        return this.file;
    }

    public void setFileFormat(FileFormat format) {
        this.fileFormat = format;
    }

    public FileFormat getFileFormat() {
        return this.fileFormat;
    }

    public void setIgnoreChanges(boolean flag) {
        this.ignoreChanges = flag;
    }

    public boolean isIgnoreChanges() {
        return this.ignoreChanges;
    }

    public void setChanged(boolean changed) {
        if (this.ignoreChanges) {
            return;
        }
        this.changed = changed;
        if (changed && !this.modified) {
            this.modified = true;
            int l_revision = this.getRevision();
            this.setRevision(++l_revision);
        }
        this.fireChangeEvent(this.defaultChangeEvent);
    }

    public boolean isModified() {
        return this.modified;
    }

    public int getRevision() {
        return Integer.valueOf(this.properties.getProperty(PROPERTY_REVISION, "0"));
    }

    public void setRevision(int revision) {
        if (!this.ignoreChanges) {
            this.modified = true;
        }
        this.setProperty(PROPERTY_REVISION, Integer.toString(revision));
    }

    public String getName() {
        return this.getProperty(PROPERTY_NAME);
    }

    public void setName(String name) {
        this.setProperty(PROPERTY_NAME, name);
    }

    public Map<Object, Object> getProperties() {
        return this.properties;
    }

    public String getProperty(String key) {
        return this.properties.getProperty(key);
    }

    public void setProperty(String key, String value) {
        String l_oldValue = this.properties.getProperty(key);
        this.properties.setProperty(key, value);
        this.firePropertyChangeEvent(new PropertyChangeEvent(this, key, l_oldValue, value));
        this.setChanged(true);
    }

    public void addChangeListener(ChangeListener l) {
        this.changeListeners.add(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.changeListeners.remove(l);
    }

    protected void fireChangeEvent(ChangeEvent e) {
        for (ChangeListener l : this.changeListeners) {
            l.stateChanged(e);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeListeners.add(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeListeners.remove(l);
    }

    protected void firePropertyChangeEvent(PropertyChangeEvent e) {
        if (!this.ignoreChanges) {
            for (PropertyChangeListener l : this.propertyChangeListeners) {
                l.propertyChange(e);
            }
        }
    }
}

