/*
 * Decompiled with CFR 0.152.
 */
package com.valeras.color_chart.reader.acb_acad;

import com.valeras.color_chart.ColorChart;
import com.valeras.color_chart.reader.acb_acad.ACB_PaletteTag;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Properties;
import java.util.Set;

public class ACB_PaletteTagMap
extends HashMap<String, ACB_PaletteTag> {
    private static final String STR_TAG_PREFIX = "tag";
    private static final String STR_FIELD_DELIMITER = ";";
    private static final String STR_VALUE_DELIMITER = "=";
    private static final String STR_FIELD_BOOKNAME = "bookName";
    private static final String STR_FIELD_CHARTNAME = "chart_name";
    private static final String STR_FIELD_CHARTDISPLAYNAME = "chart_display_name";
    private static final String STR_FIELD_EXTRACTMETHOD = "extract_method";
    private static final String STR_FIELD_ENTRYIDENTIFIER = "entry_identifier";
    private static final String STR_FIELD_CODEPREFIX = "code_prefix";

    public void load(InputStream inStream) throws IOException, ParseException {
        Properties l_data = new Properties();
        l_data.load(inStream);
        Set<String> l_entries = l_data.stringPropertyNames();
        for (String k : l_entries) {
            if (!k.startsWith(STR_TAG_PREFIX)) continue;
            Properties l_tagProperties = new Properties();
            String l_text = l_data.getProperty(k);
            String[] l_tokens = l_text.split(STR_FIELD_DELIMITER);
            for (int i = 0; i < l_tokens.length; ++i) {
                String[] l_pair = l_tokens[i].split(STR_VALUE_DELIMITER);
                if (l_pair.length != 2) {
                    throw new ParseException(l_tokens[i], 0);
                }
                l_tagProperties.setProperty(l_pair[0], l_pair[1]);
            }
            ACB_PaletteTag l_tag = this.createTag(l_tagProperties);
            this.put(l_tag.getBookName(), l_tag);
        }
    }

    protected ACB_PaletteTag createTag(Properties data) {
        ColorChart.EntryIdentifier l_entryIdentifier = ColorChart.EntryIdentifier.Code;
        String l_bookName = data.getProperty(STR_FIELD_BOOKNAME, null);
        String l_chartName = data.getProperty(STR_FIELD_CHARTNAME, null);
        String l_chartDisplayName = data.getProperty(STR_FIELD_CHARTDISPLAYNAME, null);
        String l_entryIdentifierName = data.getProperty(STR_FIELD_ENTRYIDENTIFIER, null);
        String l_extractMethod = data.getProperty(STR_FIELD_EXTRACTMETHOD, null);
        String l_codePrefix = data.getProperty(STR_FIELD_CODEPREFIX, null);
        if (l_entryIdentifierName != null) {
            l_entryIdentifier = l_entryIdentifierName.equalsIgnoreCase("code") ? ColorChart.EntryIdentifier.Code : ColorChart.EntryIdentifier.Name;
        }
        ACB_PaletteTag l_tag = new ACB_PaletteTag(l_bookName, l_chartName, l_entryIdentifier, l_extractMethod);
        if (l_chartDisplayName != null) {
            l_tag.setChartDisplayName(l_chartDisplayName);
        }
        if (l_codePrefix != null) {
            l_tag.setCodePrefix(l_codePrefix);
        }
        return l_tag;
    }
}

