/*
 * Decompiled with CFR 0.152.
 */
package com.valeras.color_chart.reader.acb_acad;

import com.valeras.color_chart.ColorChart;
import com.valeras.color_chart.reader.ColorChartReader;
import com.valeras.color_chart.reader.acb_acad.ACB_ExtractEntryNameMethod;
import com.valeras.color_chart.reader.acb_acad.ACB_PaletteTag;
import com.valeras.color_chart.reader.acb_acad.extract_methods.ACB_ExtractCodeAndNameMethod;
import com.valeras.color_chart.reader.acb_acad.extract_methods.ACB_ExtractCodeOnlyMethod;
import com.valeras.color_chart.reader.acb_acad.extract_methods.ACB_ExtractNameAndCodeMethod;
import com.valeras.color_chart.reader.acb_acad.extract_methods.ACB_ExtractNameOnlyMethod;
import java.awt.Color;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class ACB_PaletteReader
implements ColorChartReader {
    public static final String EXTRACT_NAME_METHOD = "name";
    public static final String EXTRACT_CODE_METHOD = "code";
    public static final String EXTRACT_NAME_CODE_METHOD = "name_par_code";
    public static final String EXTRACT_CODE_NAME_METHOD = "code_par_name";
    protected static final HashMap<String, ACB_PaletteTag> paletteTags = new HashMap();
    protected static final HashMap<String, ACB_ExtractEntryNameMethod> extractMethods = new HashMap();

    public static void addExtractMethod(String name, ACB_ExtractEntryNameMethod method) {
        extractMethods.put(name, method);
    }

    public static void putPaletteTag(ACB_PaletteTag tag) {
        paletteTags.put(tag.getBookName(), tag);
    }

    public static void putPaletteTags(Map<String, ACB_PaletteTag> tags) {
        paletteTags.putAll(tags);
    }

    @Override
    public void read(InputStream stream, ColorChart colorChart) throws IOException, ParseException {
        XMLStreamReader l_reader;
        XMLInputFactory l_factory = XMLInputFactory.newFactory();
        ACB_PaletteTag l_tag = null;
        ACB_ExtractEntryNameMethod l_extractMethod = extractMethods.get(EXTRACT_NAME_CODE_METHOD);
        ParserElement l_scope = ParserElement.NONE;
        ParserElement l_element = ParserElement.NONE;
        int l_redValue = 0;
        int l_greenValue = 0;
        int l_blueValue = 0;
        String l_colorNameValue = null;
        Color l_colorValue = null;
        try {
            l_reader = l_factory.createXMLStreamReader(stream);
        }
        catch (XMLStreamException ex) {
            Logger.getLogger(ACB_PaletteReader.class.getName()).log(Level.SEVERE, null, ex);
            return;
        }
        try {
            while (l_reader.hasNext()) {
                int l_event = l_reader.next();
                block3 : switch (l_event) {
                    case 1: {
                        String l_text = l_reader.getLocalName();
                        ParserElement l_token = this.parseElement(l_text);
                        switch (l_token) {
                            case ColorBook: {
                                l_scope = ParserElement.ColorBook;
                                l_element = ParserElement.NONE;
                                break block3;
                            }
                            case ColorEntry: {
                                l_scope = ParserElement.ColorEntry;
                                l_element = ParserElement.NONE;
                                break block3;
                            }
                            case RGB8: {
                                l_blueValue = 0;
                                l_greenValue = 0;
                                l_redValue = 0;
                                break block3;
                            }
                        }
                        l_element = l_token;
                        break;
                    }
                    case 4: {
                        String l_text = l_reader.getText();
                        switch (l_element) {
                            case BookName: {
                                l_tag = paletteTags.get(l_text);
                                if (l_tag == null) break block3;
                                colorChart.setName(l_tag.getChartName());
                                colorChart.setDisplayName(l_tag.getChartDisplayName());
                                colorChart.setEntryIdentifier(l_tag.getEntryIdentifier());
                                l_extractMethod = extractMethods.get(l_tag.getExtractMethod());
                                if (l_extractMethod != null) break block3;
                                throw new ParseException(l_text, 0);
                            }
                            case ColorName: {
                                l_colorNameValue = l_text;
                                break block3;
                            }
                            case Red: {
                                l_redValue = Integer.parseInt(l_text);
                                break block3;
                            }
                            case Green: {
                                l_greenValue = Integer.parseInt(l_text);
                                break block3;
                            }
                            case Blue: {
                                l_blueValue = Integer.parseInt(l_text);
                                break block3;
                            }
                        }
                        break;
                    }
                    case 2: {
                        String l_text = l_reader.getLocalName();
                        ParserElement l_endElement = this.parseElement(l_text);
                        switch (l_endElement) {
                            case ColorEntry: {
                                ACB_ExtractEntryNameMethod.Result l_codename = l_extractMethod.extract(l_colorNameValue);
                                colorChart.putEntry(l_codename.code, l_codename.name, l_colorValue);
                                break;
                            }
                            case RGB8: {
                                l_colorValue = new Color(l_redValue, l_greenValue, l_blueValue);
                                break;
                            }
                        }
                        l_element = ParserElement.NONE;
                    }
                }
            }
        }
        catch (XMLStreamException ex) {
            Logger.getLogger(ACB_PaletteReader.class.getName()).log(Level.SEVERE, null, ex);
        }
        try {
            l_reader.close();
        }
        catch (XMLStreamException ex) {
            Logger.getLogger(ACB_PaletteReader.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private ParserElement parseElement(String text) {
        String[] l_elements = new String[]{"bookName", "colorEntry", "colorName", "RGB8", "Red", "Green", "Blue"};
        ParserElement[] l_states = new ParserElement[]{ParserElement.BookName, ParserElement.ColorEntry, ParserElement.ColorName, ParserElement.RGB8, ParserElement.Red, ParserElement.Green, ParserElement.Blue};
        ParserElement l_state = ParserElement.NONE;
        for (int i = 0; i < l_elements.length; ++i) {
            if (!l_elements[i].equalsIgnoreCase(text)) continue;
            l_state = l_states[i];
            break;
        }
        return l_state;
    }

    static {
        extractMethods.put(EXTRACT_NAME_METHOD, new ACB_ExtractNameOnlyMethod());
        extractMethods.put(EXTRACT_CODE_METHOD, new ACB_ExtractCodeOnlyMethod());
        extractMethods.put(EXTRACT_NAME_CODE_METHOD, new ACB_ExtractNameAndCodeMethod());
        extractMethods.put(EXTRACT_CODE_NAME_METHOD, new ACB_ExtractCodeAndNameMethod());
    }

    private static enum ParserElement {
        NONE,
        ColorBook,
        ColorPage,
        PageColor,
        BookName,
        ColorEntry,
        ColorName,
        RGB8,
        Red,
        Green,
        Blue;

    }
}

