/*
 * Decompiled with CFR 0.152.
 */
package com.valeras.color_chart.io.format;

import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;

public class FloatArrayFormat
extends Format {
    public static final String NAME = "format.float_array";
    private static final String COMMA_DELIMITER = ",";
    private static final String SPACE_DELIMITER = " ";
    private static final String DEFAULT_NUMBER_PATTERN = "0.000";
    private final DecimalFormat numberFormat = new DecimalFormat("0.000");

    @Override
    public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
        float[] l_components = (float[])obj;
        String l_text = "";
        for (int i = 0; i < l_components.length; ++i) {
            String l_str = this.numberFormat.format(l_components[i]).replaceAll(COMMA_DELIMITER, ".");
            l_text = l_text + (i > 0 ? ", " : "") + l_str;
        }
        toAppendTo.append(l_text);
        return toAppendTo;
    }

    @Override
    public Object parseObject(String source, ParsePosition pos) {
        String text = source.substring(pos.getIndex());
        String[] l_tokens = text.indexOf(COMMA_DELIMITER) > 0 ? text.split(COMMA_DELIMITER) : text.split(SPACE_DELIMITER);
        float[] l_components = new float[l_tokens.length];
        for (int i = 0; i < l_tokens.length; ++i) {
            l_components[i] = Float.valueOf(l_tokens[i].trim()).floatValue();
        }
        pos.setIndex(source.length() - 1);
        return l_components;
    }
}

