/*
 * Decompiled with CFR 0.152.
 */
package com.valeras.color_chart.io.format;

import java.awt.Color;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;

public class ColorRGBTupleFormat
extends Format {
    public static final String NAME = "format.rgb_tuple";
    private static final String COMMA_DELIMITER = ",";
    private static final String SPACE_DELIMITER = " ";

    @Override
    public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
        int[] l_rgb = new int[]{((Color)obj).getRed(), ((Color)obj).getGreen(), ((Color)obj).getBlue()};
        String l_text = l_rgb[0] + ", " + l_rgb[1] + ", " + l_rgb[2];
        toAppendTo.append(l_text);
        return toAppendTo;
    }

    @Override
    public Object parseObject(String source, ParsePosition pos) {
        int[] l_rgb = new int[3];
        String text = source.substring(pos.getIndex());
        String[] l_tokens = text.indexOf(COMMA_DELIMITER) > 0 ? text.split(COMMA_DELIMITER) : text.split(SPACE_DELIMITER);
        for (int i = 0; i < 3; ++i) {
            l_rgb[i] = Integer.valueOf(l_tokens[i].trim());
        }
        Color l_color = new Color(l_rgb[0], l_rgb[1], l_rgb[2]);
        pos.setIndex(source.length() - 1);
        return l_color;
    }
}

